/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.osgi.framework.AdminPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public final class AdminPermission
extends BasicPermission {
    static final long serialVersionUID = 207051004521261705L;
    public static final String CLASS = "class";
    public static final String EXECUTE = "execute";
    public static final String EXTENSIONLIFECYCLE = "extensionLifecycle";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LISTENER = "listener";
    public static final String METADATA = "metadata";
    public static final String RESOLVE = "resolve";
    public static final String RESOURCE = "resource";
    public static final String STARTLEVEL = "startlevel";
    public static final String CONTEXT = "context";
    private static final int ACTION_CLASS = 1;
    private static final int ACTION_EXECUTE = 2;
    private static final int ACTION_LIFECYCLE = 4;
    private static final int ACTION_LISTENER = 8;
    private static final int ACTION_METADATA = 16;
    private static final int ACTION_RESOLVE = 64;
    private static final int ACTION_RESOURCE = 128;
    private static final int ACTION_STARTLEVEL = 256;
    private static final int ACTION_EXTENSIONLIFECYCLE = 512;
    private static final int ACTION_CONTEXT = 1024;
    private static final int ACTION_ALL = 2015;
    private static final int ACTION_NONE = 0;
    private boolean wildcard;
    private String filter;
    private String actions = null;
    private transient int action_mask = 0;
    private transient Bundle bundle;
    private transient Dictionary bundleProperties;
    private transient Filter filterImpl;

    public AdminPermission() {
        this("*", 2015);
    }

    public AdminPermission(String string, String string2) {
        this(string == null ? "*" : string, AdminPermission.getMask(string2 == null ? "*" : string2));
    }

    public AdminPermission(Bundle bundle, String string) {
        super(AdminPermission.createName(bundle));
        this.bundle = bundle;
        this.wildcard = false;
        this.filter = null;
        this.action_mask = AdminPermission.getMask(string);
    }

    private static String createName(Bundle bundle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(id=");
        stringBuffer.append(bundle.getBundleId());
        stringBuffer.append(")");
        return ((Object)stringBuffer).toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)object;
        return this.action_mask == adminPermission.action_mask && this.wildcard == adminPermission.wildcard && (this.bundle == null ? adminPermission.bundle == null : adminPermission.bundle != null && this.bundle.getBundleId() == adminPermission.bundle.getBundleId()) && (this.filter == null ? adminPermission.filter == null : this.filter.equals(adminPermission.filter));
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if ((this.action_mask & 1) == 1) {
                stringBuffer.append(CLASS);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 2) == 2) {
                stringBuffer.append(EXECUTE);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 0x200) == 512) {
                stringBuffer.append(EXTENSIONLIFECYCLE);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 4) == 4) {
                stringBuffer.append(LIFECYCLE);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 8) == 8) {
                stringBuffer.append(LISTENER);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 0x10) == 16) {
                stringBuffer.append(METADATA);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 0x40) == 64) {
                stringBuffer.append(RESOLVE);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 0x80) == 128) {
                stringBuffer.append(RESOURCE);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 0x100) == 256) {
                stringBuffer.append(STARTLEVEL);
                stringBuffer.append(',');
            }
            if ((this.action_mask & 0x400) == 1024) {
                stringBuffer.append(CONTEXT);
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.actions = ((Object)stringBuffer).toString();
        }
        return this.actions;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        if ((this.action_mask & adminPermission.action_mask) != adminPermission.action_mask) {
            return false;
        }
        if (adminPermission.filter != null) {
            throw new RuntimeException("Cannot imply a filter");
        }
        if (adminPermission.wildcard) {
            return this.wildcard;
        }
        if (this.filter != null) {
            Filter filter = this.getFilterImpl();
            return filter != null && filter.match(adminPermission.getProperties());
        }
        if (this.wildcard) {
            return true;
        }
        return this.bundle.equals(adminPermission.bundle);
    }

    public PermissionCollection newPermissionCollection() {
        return new AdminPermissionCollection();
    }

    AdminPermission(String string, int n) {
        super(string);
        if (string.equals("*")) {
            this.wildcard = true;
            this.filter = null;
        } else {
            this.wildcard = false;
            this.filter = string;
        }
        this.bundle = null;
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl69
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 4 || var3_3[var4_4 - 4] != 'c' && var3_3[var4_4 - 4] != 'C' || var3_3[var4_4 - 3] != 'l' && var3_3[var4_4 - 3] != 'L' || var3_3[var4_4 - 2] != 'a' && var3_3[var4_4 - 2] != 'A' || var3_3[var4_4 - 1] != 's' && var3_3[var4_4 - 1] != 'S' || var3_3[var4_4] != 's' && var3_3[var4_4] != 'S')) {
                    var6_6 = 5;
                    var2_2 |= 1;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 'x' && var3_3[var4_4 - 5] != 'X' || var3_3[var4_4 - 4] != 'e' && var3_3[var4_4 - 4] != 'E' || var3_3[var4_4 - 3] != 'c' && var3_3[var4_4 - 3] != 'C' || var3_3[var4_4 - 2] != 'u' && var3_3[var4_4 - 2] != 'U' || var3_3[var4_4 - 1] != 't' && var3_3[var4_4 - 1] != 'T' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 2;
                } else if (!(var4_4 < 17 || var3_3[var4_4 - 17] != 'e' && var3_3[var4_4 - 17] != 'E' || var3_3[var4_4 - 16] != 'x' && var3_3[var4_4 - 16] != 'X' || var3_3[var4_4 - 15] != 't' && var3_3[var4_4 - 15] != 'T' || var3_3[var4_4 - 14] != 'e' && var3_3[var4_4 - 14] != 'E' || var3_3[var4_4 - 13] != 'n' && var3_3[var4_4 - 13] != 'N' || var3_3[var4_4 - 12] != 's' && var3_3[var4_4 - 12] != 'S' || var3_3[var4_4 - 11] != 'i' && var3_3[var4_4 - 11] != 'I' || var3_3[var4_4 - 10] != 'o' && var3_3[var4_4 - 10] != 'O' || var3_3[var4_4 - 9] != 'n' && var3_3[var4_4 - 9] != 'N' || var3_3[var4_4 - 8] != 'l' && var3_3[var4_4 - 8] != 'L' || var3_3[var4_4 - 7] != 'i' && var3_3[var4_4 - 7] != 'I' || var3_3[var4_4 - 6] != 'f' && var3_3[var4_4 - 6] != 'F' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'c' && var3_3[var4_4 - 4] != 'C' || var3_3[var4_4 - 3] != 'y' && var3_3[var4_4 - 3] != 'Y' || var3_3[var4_4 - 2] != 'c' && var3_3[var4_4 - 2] != 'C' || var3_3[var4_4 - 1] != 'l' && var3_3[var4_4 - 1] != 'L' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 18;
                    var2_2 |= 512;
                } else if (!(var4_4 < 8 || var3_3[var4_4 - 8] != 'l' && var3_3[var4_4 - 8] != 'L' || var3_3[var4_4 - 7] != 'i' && var3_3[var4_4 - 7] != 'I' || var3_3[var4_4 - 6] != 'f' && var3_3[var4_4 - 6] != 'F' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'c' && var3_3[var4_4 - 4] != 'C' || var3_3[var4_4 - 3] != 'y' && var3_3[var4_4 - 3] != 'Y' || var3_3[var4_4 - 2] != 'c' && var3_3[var4_4 - 2] != 'C' || var3_3[var4_4 - 1] != 'l' && var3_3[var4_4 - 1] != 'L' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 9;
                    var2_2 |= 4;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'l' && var3_3[var4_4 - 7] != 'L' || var3_3[var4_4 - 6] != 'i' && var3_3[var4_4 - 6] != 'I' || var3_3[var4_4 - 5] != 's' && var3_3[var4_4 - 5] != 'S' || var3_3[var4_4 - 4] != 't' && var3_3[var4_4 - 4] != 'T' || var3_3[var4_4 - 3] != 'e' && var3_3[var4_4 - 3] != 'E' || var3_3[var4_4 - 2] != 'n' && var3_3[var4_4 - 2] != 'N' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 'r' && var3_3[var4_4] != 'R')) {
                    var6_6 = 8;
                    var2_2 |= 8;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'm' && var3_3[var4_4 - 7] != 'M' || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 't' && var3_3[var4_4 - 5] != 'T' || var3_3[var4_4 - 4] != 'a' && var3_3[var4_4 - 4] != 'A' || var3_3[var4_4 - 3] != 'd' && var3_3[var4_4 - 3] != 'D' || var3_3[var4_4 - 2] != 'a' && var3_3[var4_4 - 2] != 'A' || var3_3[var4_4 - 1] != 't' && var3_3[var4_4 - 1] != 'T' || var3_3[var4_4] != 'a' && var3_3[var4_4] != 'A')) {
                    var6_6 = 8;
                    var2_2 |= 16;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'r' && var3_3[var4_4 - 6] != 'R' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 's' && var3_3[var4_4 - 4] != 'S' || var3_3[var4_4 - 3] != 'o' && var3_3[var4_4 - 3] != 'O' || var3_3[var4_4 - 2] != 'l' && var3_3[var4_4 - 2] != 'L' || var3_3[var4_4 - 1] != 'v' && var3_3[var4_4 - 1] != 'V' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 64;
                } else if (!(var4_4 < 7 || var3_3[var4_4 - 7] != 'r' && var3_3[var4_4 - 7] != 'R' || var3_3[var4_4 - 6] != 'e' && var3_3[var4_4 - 6] != 'E' || var3_3[var4_4 - 5] != 's' && var3_3[var4_4 - 5] != 'S' || var3_3[var4_4 - 4] != 'o' && var3_3[var4_4 - 4] != 'O' || var3_3[var4_4 - 3] != 'u' && var3_3[var4_4 - 3] != 'U' || var3_3[var4_4 - 2] != 'r' && var3_3[var4_4 - 2] != 'R' || var3_3[var4_4 - 1] != 'c' && var3_3[var4_4 - 1] != 'C' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 8;
                    var2_2 |= 128;
                } else if (!(var4_4 < 9 || var3_3[var4_4 - 9] != 's' && var3_3[var4_4 - 9] != 'S' || var3_3[var4_4 - 8] != 't' && var3_3[var4_4 - 8] != 'T' || var3_3[var4_4 - 7] != 'a' && var3_3[var4_4 - 7] != 'A' || var3_3[var4_4 - 6] != 'r' && var3_3[var4_4 - 6] != 'R' || var3_3[var4_4 - 5] != 't' && var3_3[var4_4 - 5] != 'T' || var3_3[var4_4 - 4] != 'l' && var3_3[var4_4 - 4] != 'L' || var3_3[var4_4 - 3] != 'e' && var3_3[var4_4 - 3] != 'E' || var3_3[var4_4 - 2] != 'v' && var3_3[var4_4 - 2] != 'V' || var3_3[var4_4 - 1] != 'e' && var3_3[var4_4 - 1] != 'E' || var3_3[var4_4] != 'l' && var3_3[var4_4] != 'L')) {
                    var6_6 = 10;
                    var2_2 |= 256;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'c' && var3_3[var4_4 - 6] != 'C' || var3_3[var4_4 - 5] != 'o' && var3_3[var4_4 - 5] != 'O' || var3_3[var4_4 - 4] != 'n' && var3_3[var4_4 - 4] != 'N' || var3_3[var4_4 - 3] != 't' && var3_3[var4_4 - 3] != 'T' || var3_3[var4_4 - 2] != 'e' && var3_3[var4_4 - 2] != 'E' || var3_3[var4_4 - 1] != 'x' && var3_3[var4_4 - 1] != 'X' || var3_3[var4_4] != 't' && var3_3[var4_4] != 'T')) {
                    var6_6 = 7;
                    var2_2 |= 1024;
                } else if (var4_4 >= 0 && var3_3[var4_4] == '*') {
                    var6_6 = 1;
                    var2_2 |= 2015;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl69:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    private Dictionary getProperties() {
        if (this.bundleProperties == null) {
            this.bundleProperties = new Hashtable();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AdminPermission.this.bundleProperties.put("id", new Long(AdminPermission.this.bundle.getBundleId()));
                    AdminPermission.this.bundleProperties.put("location", AdminPermission.this.bundle.getLocation());
                    if (AdminPermission.this.bundle.getSymbolicName() != null) {
                        AdminPermission.this.bundleProperties.put("name", AdminPermission.this.bundle.getSymbolicName());
                    }
                    AdminPermission.this.bundleProperties.put("signer", new SignerWrapper(AdminPermission.this.bundle));
                    return null;
                }
            });
        }
        return this.bundleProperties;
    }

    private Filter getFilterImpl() {
        if (this.filterImpl == null) {
            try {
                int n = this.filter.indexOf("signer");
                if (n != -1) {
                    StringBuffer stringBuffer = new StringBuffer(this.filter);
                    int n2 = 0;
                    while (n != -1) {
                        int n3 = n - 1;
                        while (n3 >= 0 && Character.isWhitespace(this.filter.charAt(n3))) {
                            --n3;
                        }
                        if (n3 < 0) break;
                        if (this.filter.charAt(n3) != '(' || n3 > 0 && this.filter.charAt(n3 - 1) == '\\') {
                            n = this.filter.indexOf("signer", n + 6);
                            continue;
                        }
                        n += 6;
                        while (Character.isWhitespace(this.filter.charAt(n))) {
                            ++n;
                        }
                        if (this.filter.charAt(n) != '=') {
                            n = this.filter.indexOf("signer", n);
                            continue;
                        }
                        ++n;
                        while (this.filter.charAt(n) != ')' || this.filter.charAt(n - 1) == '\\') {
                            if (this.filter.charAt(n) == '*') {
                                stringBuffer.insert(n + n2, '\\');
                                ++n2;
                            }
                            ++n;
                        }
                        n = this.filter.indexOf("signer", n);
                    }
                    this.filter = ((Object)stringBuffer).toString();
                }
                this.filterImpl = new FilterImpl(this.filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return this.filterImpl;
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        if (this.filter == null && !this.wildcard) {
            throw new UnsupportedOperationException("cannot serialize");
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.action_mask = AdminPermission.getMask(this.actions);
    }

    private static class SignerWrapper {
        private Bundle bundle;
        private String pattern;

        public SignerWrapper(String string) {
            this.pattern = string;
        }

        SignerWrapper(Bundle bundle) {
            this.bundle = bundle;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SignerWrapper)) {
                return false;
            }
            SignerWrapper signerWrapper = (SignerWrapper)object;
            AbstractBundle abstractBundle = (AbstractBundle)(this.bundle != null ? this.bundle : signerWrapper.bundle);
            String string = this.bundle != null ? signerWrapper.pattern : this.pattern;
            return abstractBundle.getBundleData().matchDNChain(string);
        }
    }
}

