/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    boolean trimAdjusted;
    int oldWidth;
    int oldHeight;
    boolean exposed = false;
    int minWidth = -1;
    int minHeight = -1;
    Control lastFocusedControl = null;
    private ShellListener shellListener = null;
    private MenuItem closeMenuItem = null;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    Shell(Display display, Shell parent, int style, int handle) {
        this.checkSubclass();
        if (!this.isValidSubclass()) {
            Shell.error(43);
        }
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            Shell.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            Shell.error(5);
        }
        this.internal_style = Shell.checkStyle(style);
        this.internal_parent = parent;
        this.display = display;
        this.internal_handle = handle;
        this.visible = false;
        this.createWidget(0);
        if (Platform.isSmartPhone() && (this.internal_style & 0x40) != 0) {
            this.shellListener = new ShellListener(){

                public void shellActivated(ShellEvent e) {
                    Shell.this.createCloseMenuItem();
                }

                public void shellClosed(ShellEvent e) {
                }

                public void shellDeactivated(ShellEvent e) {
                    Shell.this.disposeCloseMenuItem();
                }

                public void shellDeiconified(ShellEvent e) {
                }

                public void shellIconified(ShellEvent e) {
                }
            };
            this.addShellListener(this.shellListener);
        }
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.getDisplay() : null, parent, style, 0);
    }

    void register() {
        this.display.addShell(this);
    }

    void deregister() {
        this.display.removeShell(this);
    }

    private void shellCallback(int event) {
        switch (event) {
            case 205: {
                this.getDisplay().activeShell = this;
                this.internal_sendEvent(26);
                break;
            }
            case 206: {
                Control c = this.display.getFocusControl();
                this.lastFocusedControl = c == null || c.isDisposed() || c.getShell() != this ? null : c;
                this.internal_sendEvent(27);
                break;
            }
            case 203: {
                this.internal_sendEvent(19);
                break;
            }
            case 204: {
                this.internal_sendEvent(20);
                break;
            }
            case 201: {
                this.close();
            }
        }
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            Shell.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    static int checkStyle(int style) {
        style = Decorations.checkStyle(style);
        int mask = 98304;
        int bits = style & ~mask;
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        if (!this.isEnabled()) {
            return;
        }
        Composite widget = this.internal_parent;
        while (widget != null && !widget.getShell().isModal()) {
            widget = widget.internal_parent;
        }
        if (widget == null) {
            Shell[] shells = this.getShells();
            for (int i = 0; i < shells.length; ++i) {
                Shell shell = shells[i];
                if (shell == this || !shell.isModal() || !shell.isVisible()) continue;
                shell.bringToTop();
                return;
            }
        }
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = this.internal_parent == null ? OS.Shell_New(this.display.internal_handle, this.internal_getNativeStyle()) : OS.Shell_NewChild(this.internal_parent.internal_handle, this.internal_getNativeStyle());
        if (this.internal_handle == 0) {
            Shell.error(2);
        }
        boolean resizable = false;
        if ((this.internal_style & 0x10) == 16) {
            resizable = true;
        }
        OS.Shell_SetResizable(this.internal_handle, resizable);
        this.trimAdjusted = false;
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop();
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 0x10000) == 65536) {
            nativeStyle |= 0x40;
        }
        if ((this.internal_style & 0) == 0) {
            nativeStyle |= 0x80;
        }
        if ((this.internal_style & 0x8000) == 32768) {
            nativeStyle |= 0x100;
        }
        if ((this.internal_style & 0x800) == 2048) {
            nativeStyle |= 0x800;
        }
        if ((this.internal_style & 0x40) == 64) {
            nativeStyle |= 1;
        }
        if ((this.internal_style & 0x80) == 128) {
            nativeStyle |= 2;
        }
        if ((this.internal_style & 0x400) == 1024) {
            nativeStyle |= 4;
        }
        if ((this.internal_style & 8) == 8) {
            nativeStyle |= 8;
        }
        if ((this.internal_style & 0x20) == 32) {
            nativeStyle |= 0x20;
        }
        if ((this.internal_style & 0x4000) == 16384) {
            nativeStyle |= 0x2000000;
        }
        return nativeStyle;
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (OS.Platform_GetCapability(3) != 0) {
            return OS.Shell_GetMaximized(this.internal_handle);
        }
        return super.getMaximized();
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (OS.Platform_GetCapability(3) != 0) {
            return OS.Shell_GetMinimized(this.internal_handle);
        }
        return super.getMinimized();
    }

    public void setImage(Image image) {
        super.setImage(image);
        int imageHandle = image == null ? 0 : image.internal_handle;
        OS.Shell_SetImage(this.internal_handle, imageHandle);
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Composite shell = shells[i];
            while ((shell = shell.internal_parent) != null && shell != this) {
            }
            if (shell != this) continue;
            ++count;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        for (int i = 0; i < shells.length; ++i) {
            Composite shell = shells[i];
            while ((shell = shell.internal_parent) != null && shell != this) {
            }
            if (shell != this) continue;
            result[index++] = shells[i];
        }
        return result;
    }

    boolean isModal() {
        this.checkWidget();
        return this.isStyleModal();
    }

    boolean isStyleModal() {
        boolean modal = (this.internal_style & 0x10000) != 0 || (this.internal_style & 0x8000) != 0;
        return modal;
    }

    public boolean isVisible() {
        return this.getVisible();
    }

    public void open() {
        this.checkWidget();
        this.layout(true);
        this.setVisible(true);
        this.bringToTop();
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    void releaseShells() {
        Shell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell.isDisposed()) continue;
            shell.releaseResources();
        }
    }

    void releaseWidget() {
        if (Platform.isSmartPhone() && (this.internal_style & 0x40) != 0 && this.shellListener != null) {
            this.removeShellListener(this.shellListener);
        }
        this.releaseShells();
        super.releaseWidget();
        this.oldHeight = 0;
        this.oldWidth = 0;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            Shell.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    public void setActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.bringToTop();
    }

    void bringToTop() {
        this.getDisplay().activeShell = this;
        OS.Control_MoveAbove(this.internal_handle, 0);
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        if (OS.Platform_GetCapability(3) != 0) {
            OS.Shell_SetMaximized(this.internal_handle, maximized);
        } else {
            super.setMaximized(maximized);
        }
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (OS.Platform_GetCapability(3) != 0) {
            OS.Shell_SetMinimized(this.internal_handle, minimized);
        } else {
            super.setMinimized(minimized);
        }
    }

    boolean traverseEscape() {
        if (this.internal_parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int windowHandle() {
        return this.internal_handle;
    }

    public void setMenuBar(Menu menu) {
        super.setMenuBar(menu);
        int menuHandle = menu == null ? 0 : menu.internal_handle;
        OS.Shell_SetMenuBar(this.internal_handle, menuHandle);
    }

    private void createCloseMenuItem() {
        Menu menu = this.getMenuBar();
        if (menu == null) {
            menu = new Menu(this, 2);
            this.setMenuBar(menu);
        }
        if (this.closeMenuItem == null || this.closeMenuItem.isDisposed()) {
            this.closeMenuItem = new MenuItem(menu, 64, 0);
            this.closeMenuItem.setText("Close");
            this.closeMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Shell.this.close();
                }
            });
        }
    }

    private void disposeCloseMenuItem() {
        if (this.closeMenuItem != null && !this.closeMenuItem.isDisposed()) {
            this.closeMenuItem.dispose();
        }
        this.closeMenuItem = null;
    }

    public void setText(String string) {
        super.setText(string);
        OS.Shell_SetText(this.internal_handle, string);
    }

    private void resizeCallback(int width, int height) {
        if (width == this.oldWidth && height == this.oldHeight) {
            return;
        }
        this.oldWidth = width;
        this.oldHeight = height;
        this.internal_sendEvent(11);
        this.layout(true);
    }

    private void moveCallback(int x, int y) {
        this.internal_sendEvent(10);
    }

    public String toString() {
        return "Shell {handle=" + this.internal_handle + "}";
    }

    protected boolean isValidSubclass() {
        return this.isValidClass(this.getClass());
    }

    boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        if (name.equals("org.eclipse.swt.widgets.Shell")) {
            return true;
        }
        return name.startsWith("org.eclipse.ercp.swt.mobile.MultiPageDialog");
    }

    boolean isTrueComposite() {
        return true;
    }
}

