/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.headless;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.Workbench;

public class SocketListener {
    public static final int DEFAULT_SOCKET_PORT = 9546;
    private static final String KEY_SOCKET_PORT = "HEADLESS_WORKBENCH_PORT";
    private static final int SOCKET_TIMEOUT = 1000;
    private static final String IDENTIFY_APP = "Headless Workbench Application";
    private static final String JVM_CLOSE = "JVM CLOSE";
    private static final String JVM_RESTART = "JVM RESTART";
    private static final byte[] LOCALHOST_ADDR;
    private int socket_port = 9546;
    private Workbench workbench;
    private Display display;
    private ServerSocket server;
    private ClientHandle client;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 127;
        byArray[3] = 1;
        LOCALHOST_ADDR = byArray;
    }

    public SocketListener(Display display, Workbench workbench) {
        this.display = display;
        this.workbench = workbench;
        this.readProperties();
    }

    private void readProperties() {
        try {
            String string = System.getProperty(KEY_SOCKET_PORT);
            try {
                this.socket_port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean start() {
        try {
            this.server = new ServerSocket(this.socket_port, 10, InetAddress.getByAddress(LOCALHOST_ADDR));
            this.server.setSoTimeout(1000);
            this.client = new ClientHandle(this, this.display, this.workbench, this.server);
            new Thread(this.client).start();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean bl) {
        try {
            if (bl) {
                this.notifyJVMRestartMessage();
            } else {
                this.notifyJVMCloseMessage();
            }
            this.client.setActive(false);
            this.server.close();
            if (this.workbench != null && !this.workbench.isClosing()) {
                this.workbench.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void notifyJVMRestartMessage() {
        try {
            Socket socket = new Socket(InetAddress.getByAddress(LOCALHOST_ADDR), this.socket_port + 1);
            PrintStream printStream = new PrintStream(socket.getOutputStream(), true);
            printStream.println(IDENTIFY_APP);
            printStream.println(JVM_RESTART);
            printStream.flush();
            printStream.close();
            printStream = null;
            socket.close();
            socket = null;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {}
    }

    private void notifyJVMCloseMessage() {
        try {
            Socket socket = new Socket(InetAddress.getByAddress(LOCALHOST_ADDR), this.socket_port + 1);
            PrintStream printStream = new PrintStream(socket.getOutputStream(), true);
            printStream.println(IDENTIFY_APP);
            printStream.println(JVM_CLOSE);
            printStream.flush();
            printStream.close();
            printStream = null;
            socket.close();
            socket = null;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {}
    }

    private class ClientHandle
    implements Runnable {
        private static final String IDENTIFY_APP_NAME_START = "START";
        private static final String IDENTIFY_APP_NAME_END = "END";
        private static final String RESPONSE_OK = "OK";
        private static final String RESPONSE_ERROR = "ERROR";
        private static final String IDENTIFY_CHECK_SERVER = "CHECK SERVER";
        private static final int STATE_INIT = 0;
        private static final int STATE_FUNCTION = 1;
        private static final int STATE_APP_NAME_START = 2;
        private static final int STATE_APP_NAME_END = 3;
        private static final int STATE_CHECK_SERVER = 4;
        private boolean active = true;
        private Socket client;
        private Display display;
        private ServerSocket server;
        private Workbench workbench;
        private SocketListener listener;

        ClientHandle(SocketListener socketListener2, Display display, Workbench workbench, ServerSocket serverSocket) {
            this.listener = socketListener2;
            this.display = display;
            this.workbench = workbench;
            this.server = serverSocket;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (this.active) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                Closeable closeable = this.server;
                synchronized (closeable) {
                    try {
                        this.client = this.server.accept();
                        if (this.client == null) {
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                try {
                    String string;
                    closeable = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                    PrintWriter printWriter = new PrintWriter(this.client.getOutputStream(), true);
                    boolean bl = false;
                    n = 0;
                    while (!bl && (string = ((BufferedReader)closeable).readLine()) != null) {
                        switch (n) {
                            case 0: {
                                if (!string.equals(SocketListener.IDENTIFY_APP)) break;
                                n = 1;
                                break;
                            }
                            case 1: {
                                if (string.equals(IDENTIFY_APP_NAME_START)) {
                                    n = 2;
                                    break;
                                }
                                if (!string.equals(IDENTIFY_CHECK_SERVER)) break;
                                n = 4;
                                bl = true;
                                break;
                            }
                            case 2: {
                                if (string.equals(IDENTIFY_APP_NAME_END)) {
                                    n = 3;
                                    bl = true;
                                    break;
                                }
                                vector.add(string);
                            }
                        }
                    }
                    if (n == 3) {
                        printWriter.write(RESPONSE_OK);
                        printWriter.flush();
                        this.runApp(vector);
                    } else if (n == 4) {
                        printWriter.write(RESPONSE_OK);
                        printWriter.flush();
                    } else {
                        printWriter.write(RESPONSE_ERROR);
                        printWriter.flush();
                    }
                    vector.clear();
                    printWriter.close();
                    ((BufferedReader)closeable).close();
                    this.client.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void runApp(Vector vector) {
            if (vector == null || vector.size() == 0) {
                return;
            }
            Vector vector2 = new Vector(vector);
            try {
                if (this.display != null && !this.display.isDisposed()) {
                    this.display.asyncExec(new Runnable(this, vector2){
                        final /* synthetic */ ClientHandle this$1;
                        private final /* synthetic */ Vector val$tmp;
                        {
                            this.this$1 = clientHandle;
                            this.val$tmp = vector;
                        }

                        public void run() {
                            int n = 0;
                            while (n < this.val$tmp.size()) {
                                ClientHandle.access$0(this.this$1).runApp((String)this.val$tmp.elementAt(n));
                                ++n;
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        static /* synthetic */ Workbench access$0(ClientHandle clientHandle) {
            return clientHandle.workbench;
        }
    }
}

