/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.StringTokenizer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.part.components.services.IPartDescriptor;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.ShowViewHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewDescriptor
implements IViewDescriptor,
IPluginContribution {
    private String id;
    private ImageDescriptor imageDescriptor;
    private IConfigurationElement configElement;
    private String[] categoryPath;
    private float fastViewWidthRatio;
    private IPartDescriptor viewInfo = new IPartDescriptor(){

        public String getId() {
            return ViewDescriptor.this.id;
        }

        public String getLabel() {
            return ViewDescriptor.this.getLabel();
        }

        public ImageDescriptor getImage() {
            return ViewDescriptor.this.getImageDescriptor();
        }
    };
    private IHandlerActivation handlerActivation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ViewDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.configElement = iConfigurationElement;
        this.loadFromExtension();
    }

    public IPartDescriptor getPartDescriptor() {
        return this.viewInfo;
    }

    public IViewPart createView() throws CoreException {
        Object object = WorkbenchPlugin.createExtension(this.getConfigurationElement(), "class");
        if (object instanceof IViewPart) {
            return (IViewPart)object;
        }
        return null;
    }

    public String[] getCategoryPath() {
        return this.categoryPath;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getDescription() {
        return RegistryReader.getDescription(this.configElement);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String string = this.configElement.getAttribute("icon");
        if (string == null) {
            return null;
        }
        IExtension iExtension = this.configElement.getDeclaringExtension();
        String string2 = iExtension.getNamespace();
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(string2, string);
        return this.imageDescriptor;
    }

    public String getLabel() {
        return this.configElement.getAttribute("name");
    }

    public String getAccelerator() {
        return this.configElement.getAttribute("accelerator");
    }

    public float getFastViewWidthRatio() {
        this.configElement.getAttribute("fastViewWidthRatio");
        return this.fastViewWidthRatio;
    }

    private void loadFromExtension() throws CoreException {
        this.id = this.configElement.getAttribute("id");
        String string = this.configElement.getAttribute("category");
        if (this.configElement.getAttribute("name") == null || RegistryReader.getClassValue(this.configElement, "class") == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getDeclaringExtension().getNamespace(), 0, "Invalid extension (missing label or class name): " + this.id, null));
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            this.categoryPath = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.categoryPath[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
    }

    public String toString() {
        return "View(" + this.getId() + ")";
    }

    public String getPluginId() {
        String string = this.configElement.getNamespace();
        return string == null ? "" : string;
    }

    public String getLocalId() {
        return this.getId() == null ? "" : this.getId();
    }

    public boolean getAllowMultiple() {
        String string = this.configElement.getAttribute("allowMultiple");
        return string == null ? false : Boolean.valueOf(string);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.getConfigurationElement();
        }
        return null;
    }

    public final void activateHandler() {
        if (this.handlerActivation == null) {
            ShowViewHandler showViewHandler = new ShowViewHandler(this.getId());
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IHandlerService iHandlerService = (IHandlerService)iWorkbench.getAdapter(clazz);
            this.handlerActivation = iHandlerService.activateHandler(this.getId(), (IHandler)showViewHandler);
        }
    }

    public final void deactivateHandler() {
        if (this.handlerActivation != null) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IHandlerService iHandlerService = (IHandlerService)iWorkbench.getAdapter(clazz);
            iHandlerService.deactivateHandler(this.handlerActivation);
            this.handlerActivation = null;
        }
    }
}

