/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.FilteredSourcePackage;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.RequiredBundle;

public class BundleLoaderProxy
implements RequiredBundle {
    private BundleLoader loader;
    private BundleHost bundle;
    private BundleDescription description;
    private boolean stale = false;
    private KeyedHashSet pkgSources;

    public BundleLoaderProxy(BundleHost bundleHost, BundleDescription bundleDescription) {
        this.bundle = bundleHost;
        this.description = bundleDescription;
        this.pkgSources = new KeyedHashSet(false);
    }

    synchronized BundleLoader getBundleLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.bundle.isResolved()) {
            try {
                this.loader = this.bundle.getBundleId() == 0L ? new SystemBundleLoader(this.bundle, this) : new BundleLoader(this.bundle, this);
            }
            catch (BundleException bundleException) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, bundleException);
                return null;
            }
        }
        return this.loader;
    }

    BundleLoader getBasicBundleLoader() {
        return this.loader;
    }

    AbstractBundle getBundleHost() {
        return this.bundle;
    }

    void setStale() {
        this.stale = true;
    }

    boolean isStale() {
        return this.stale;
    }

    public String toString() {
        String string = this.bundle.getSymbolicName();
        StringBuffer stringBuffer = new StringBuffer(string == null ? this.bundle.getBundleData().getLocation() : string);
        stringBuffer.append("; ").append("bundle-version");
        stringBuffer.append("=\"").append(this.description.getVersion().toString()).append("\"");
        return stringBuffer.toString();
    }

    public Bundle getBundle() {
        if (this.isStale()) {
            return null;
        }
        return this.bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.isStale()) {
            return null;
        }
        BundleDescription[] bundleDescriptionArray = this.description.getDependents();
        if (bundleDescriptionArray == null || bundleDescriptionArray.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addRequirers(bundleDescriptionArray[n], arrayList);
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new Bundle[arrayList.size()]);
    }

    void addRequirers(BundleDescription bundleDescription, ArrayList arrayList) {
        if (bundleDescription.getHost() != null) {
            return;
        }
        BundleLoaderProxy bundleLoaderProxy = this.getBundleLoader().getLoaderProxy(bundleDescription);
        if (bundleLoaderProxy == null) {
            return;
        }
        if (arrayList.contains(bundleLoaderProxy.bundle)) {
            return;
        }
        BundleLoader bundleLoader = bundleLoaderProxy.getBundleLoader();
        BundleLoaderProxy[] bundleLoaderProxyArray = bundleLoader.requiredBundles;
        int[] nArray = bundleLoader.reexportTable;
        if (bundleLoaderProxyArray == null) {
            return;
        }
        int n = nArray == null ? 0 : nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < bundleLoaderProxyArray.length) {
            if (bundleLoaderProxyArray[n3] == this) {
                arrayList.add(bundleLoaderProxy.bundle);
                if (n2 < n && nArray[n2] == n3) {
                    ++n2;
                    BundleDescription[] bundleDescriptionArray = bundleDescription.getDependents();
                    if (bundleDescriptionArray == null) {
                        return;
                    }
                    int n4 = 0;
                    while (n4 < bundleDescriptionArray.length) {
                        bundleLoaderProxy.addRequirers(bundleDescriptionArray[n4], arrayList);
                        ++n4;
                    }
                }
                return;
            }
            ++n3;
        }
    }

    public String getSymbolicName() {
        return this.description.getSymbolicName();
    }

    public Version getVersion() {
        return this.description.getVersion();
    }

    public boolean isRemovalPending() {
        return this.description.isRemovalPending();
    }

    BundleDescription getBundleDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource getPackageSource(String string) {
        PackageSource packageSource = (PackageSource)this.pkgSources.getByKey(string);
        if (packageSource == null) {
            packageSource = new SingleSourcePackage(string, -1, this);
            KeyedHashSet keyedHashSet = this.pkgSources;
            synchronized (keyedHashSet) {
                this.pkgSources.add(packageSource);
            }
        }
        return packageSource;
    }

    boolean inUse() {
        return this.description.getDependents().length > 0;
    }

    boolean forceSourceCreation(ExportPackageDescription exportPackageDescription) {
        if (!exportPackageDescription.isRoot()) {
            return true;
        }
        boolean bl = "strict".equals(this.bundle.framework.adaptor.getState().getPlatformProperties()[0].get("osgi.resolverMode"));
        return exportPackageDescription.getDirective("include") != null || exportPackageDescription.getDirective("exclude") != null || bl && exportPackageDescription.getDirective("x-friends") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource createPackageSource(ExportPackageDescription exportPackageDescription, boolean bl) {
        Object object;
        PackageSource packageSource = null;
        if (!exportPackageDescription.isRoot()) {
            packageSource = new ReexportPackageSource(exportPackageDescription.getName());
        } else {
            boolean bl2;
            object = (String)exportPackageDescription.getDirective("include");
            String string = (String)exportPackageDescription.getDirective("exclude");
            String[] stringArray = (String[])exportPackageDescription.getDirective("x-friends");
            if (stringArray != null && !(bl2 = "strict".equals(this.bundle.framework.adaptor.getState().getPlatformProperties()[0].get("osgi.resolverMode")))) {
                stringArray = null;
            }
            if (object != null || string != null || stringArray != null) {
                ExportPackageDescription[] exportPackageDescriptionArray = this.description.getExportPackages();
                int n = -1;
                int n2 = -1;
                int n3 = 0;
                while (n3 < exportPackageDescriptionArray.length) {
                    if (n2 == -1 && exportPackageDescriptionArray[n3].getName().equals(exportPackageDescription.getName())) {
                        n2 = n3;
                    }
                    if (exportPackageDescriptionArray[n3] == exportPackageDescription && n2 != n3) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
                packageSource = new FilteredSourcePackage(exportPackageDescription.getName(), n, this, (String)object, string, stringArray);
            }
        }
        if (bl) {
            if (packageSource != null && this.pkgSources.getByKey(exportPackageDescription.getName()) == null) {
                object = this.pkgSources;
                synchronized (object) {
                    this.pkgSources.add(packageSource);
                }
            }
        } else if (packageSource == null) {
            packageSource = this.getPackageSource(exportPackageDescription.getName());
        }
        return packageSource;
    }

    class ReexportPackageSource
    extends PackageSource {
        public ReexportPackageSource(String string) {
            super(string);
        }

        public synchronized SingleSourcePackage[] getSuppliers() {
            PackageSource packageSource = BundleLoaderProxy.this.getBundleLoader().getPackageSource(this.id);
            if (packageSource == null) {
                return null;
            }
            return packageSource.getSuppliers();
        }

        public Class loadClass(String string) {
            try {
                return BundleLoaderProxy.this.getBundleLoader().findClass(string, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public URL getResource(String string) {
            return BundleLoaderProxy.this.getBundleLoader().findResource(string, false);
        }

        public Enumeration getResources(String string) throws IOException {
            return BundleLoaderProxy.this.getBundleLoader().findResources(string);
        }
    }
}

