/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.Bundle;

public class ManifestLocalization {
    private AbstractBundle bundle = null;
    private Dictionary rawHeaders = null;
    private Dictionary defaultLocaleHeaders = null;
    private Hashtable cache = new Hashtable(5);

    public ManifestLocalization(AbstractBundle abstractBundle, Dictionary dictionary) {
        this.bundle = abstractBundle;
        this.rawHeaders = dictionary;
    }

    protected Dictionary getHeaders(String string) {
        if (string.length() == 0) {
            return this.rawHeaders;
        }
        boolean bl = false;
        String string2 = Locale.getDefault().toString();
        if (string.equals(string2)) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            bl = true;
        }
        try {
            this.bundle.checkValid();
        }
        catch (IllegalStateException illegalStateException) {
            if (this.defaultLocaleHeaders != null) {
                return this.defaultLocaleHeaders;
            }
            return this.rawHeaders;
        }
        ResourceBundle resourceBundle = this.getResourceBundle(string);
        if (resourceBundle == null && !bl) {
            resourceBundle = this.getResourceBundle(string2);
        }
        Enumeration enumeration = this.rawHeaders.keys();
        Headers headers = new Headers(this.rawHeaders.size());
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)this.rawHeaders.get(string3);
            if (string4.startsWith("%") && string4.length() > 1) {
                String string5 = string4.substring(1);
                try {
                    string4 = resourceBundle == null ? string5 : (String)resourceBundle.getObject(string5);
                }
                catch (MissingResourceException missingResourceException) {
                    string4 = string5;
                }
            }
            headers.set(string3, string4);
        }
        if (bl) {
            this.defaultLocaleHeaders = headers;
        }
        return headers;
    }

    private String[] buildNLVariants(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n = string.lastIndexOf(95)) != -1) {
            arrayList.add(string);
            if (n == -1) continue;
            string = string.substring(0, n);
        }
        arrayList.add(string);
        arrayList.add("");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceBundle getResourceBundle(String string) {
        BundleResourceBundle bundleResourceBundle;
        BundleResourceBundle bundleResourceBundle2;
        String string2 = (String)this.rawHeaders.get("Bundle-Localization");
        if (string2 == null) {
            string2 = "OSGI-INF/l10n/bundle";
        }
        if ((bundleResourceBundle2 = (BundleResourceBundle)this.cache.get(string)) != null) {
            BundleResourceBundle bundleResourceBundle3;
            if (bundleResourceBundle2.isEmpty()) {
                bundleResourceBundle3 = null;
                return (ResourceBundle)((Object)bundleResourceBundle3);
            }
            bundleResourceBundle3 = bundleResourceBundle2;
            return (ResourceBundle)((Object)bundleResourceBundle3);
        }
        String[] stringArray = this.buildNLVariants(string);
        BundleResourceBundle bundleResourceBundle4 = null;
        int n = stringArray.length - 1;
        while (true) {
            BundleResourceBundle bundleResourceBundle5;
            block16: {
                if (n < 0) {
                    bundleResourceBundle2 = (BundleResourceBundle)this.cache.get(string);
                    if (!bundleResourceBundle2.isEmpty()) break;
                    bundleResourceBundle = null;
                    return (ResourceBundle)((Object)bundleResourceBundle);
                }
                bundleResourceBundle5 = (BundleResourceBundle)this.cache.get(stringArray[n]);
                URL uRL = this.findResource(String.valueOf(string2) + (stringArray[n].equals("") ? stringArray[n] : String.valueOf('_') + stringArray[n]) + ".properties");
                if (uRL != null) {
                    Object var10_10;
                    InputStream inputStream = null;
                    try {
                        try {
                            inputStream = uRL.openStream();
                            bundleResourceBundle5 = new LocalizationResourceBundle(inputStream);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var10_10 = null;
                        if (inputStream == null) break block16;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                }
            }
            if (bundleResourceBundle5 == null) {
                bundleResourceBundle5 = new EmptyResouceBundle();
            }
            if (bundleResourceBundle4 != null) {
                bundleResourceBundle5.setParent((ResourceBundle)((Object)bundleResourceBundle4));
            }
            this.cache.put(stringArray[n], bundleResourceBundle5);
            bundleResourceBundle4 = bundleResourceBundle5;
            --n;
        }
        bundleResourceBundle = bundleResourceBundle2;
        return (ResourceBundle)((Object)bundleResourceBundle);
    }

    private URL findResource(String string) {
        AbstractBundle abstractBundle = this.bundle;
        if (this.bundle.isResolved()) {
            if (this.bundle.isFragment() && this.bundle.getHosts() != null && (abstractBundle = this.bundle.getHosts()[0].getBundleHost()).getState() == 1) {
                abstractBundle = this.bundle;
            }
            return this.findInResolved(string, abstractBundle);
        }
        return this.findInBundle(string, abstractBundle);
    }

    private URL findInResolved(String string, AbstractBundle abstractBundle) {
        URL uRL = this.findInBundle(string, abstractBundle);
        if (uRL != null) {
            return uRL;
        }
        return this.findInFragments(string, abstractBundle);
    }

    private URL findInBundle(String string, AbstractBundle abstractBundle) {
        return abstractBundle.getEntry(string);
    }

    private URL findInFragments(String string, AbstractBundle abstractBundle) {
        Bundle[] bundleArray = abstractBundle.getFragments();
        URL uRL = null;
        int n = 0;
        while (bundleArray != null && n < bundleArray.length && uRL == null) {
            if (bundleArray[n].getState() != 1) {
                uRL = bundleArray[n].getEntry(string);
            }
            ++n;
        }
        return uRL;
    }

    private static interface BundleResourceBundle {
        public void setParent(ResourceBundle var1);

        public boolean isEmpty();
    }

    private class LocalizationResourceBundle
    extends PropertyResourceBundle
    implements BundleResourceBundle {
        public LocalizationResourceBundle(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        public void setParent(ResourceBundle resourceBundle) {
            super.setParent(resourceBundle);
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private class EmptyResouceBundle
    extends ResourceBundle
    implements BundleResourceBundle {
        private EmptyResouceBundle() {
        }

        public Enumeration getKeys() {
            return null;
        }

        protected Object handleGetObject(String string) throws MissingResourceException {
            return null;
        }

        public void setParent(ResourceBundle resourceBundle) {
            super.setParent(resourceBundle);
        }

        public boolean isEmpty() {
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isEmpty();
        }
    }
}

