/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.EventListener;
import java.util.List;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.StartLevelEvent;
import org.eclipse.osgi.framework.internal.core.StartLevelImpl;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class StartLevelManager
implements EventDispatcher,
EventListener,
ServiceFactory {
    protected static Framework framework;
    protected static EventManager eventManager;
    protected static EventListeners startLevelListeners;
    protected int frameworkBeginningStartLevel = 1;
    protected int initialBundleStartLevel = 1;
    private static int activeSL;
    private static final Object lock;

    static {
        activeSL = 0;
        lock = new Object();
    }

    protected StartLevelManager(Framework framework) {
        StartLevelManager.framework = framework;
    }

    protected void initialize() {
        this.initialBundleStartLevel = StartLevelManager.framework.adaptor.getInitialBundleStartLevel();
        String string = framework.getProperty("osgi.framework.beginningstartlevel");
        if (string == null) {
            string = "1";
        } else {
            try {
                if (Integer.parseInt(string) <= 0) {
                    System.err.println(NLS.bind(Msg.PROPERTIES_INVALID_FW_STARTLEVEL, "1"));
                    string = "1";
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(NLS.bind(Msg.PROPERTIES_INVALID_FW_STARTLEVEL, "1"));
                string = "1";
            }
        }
        framework.setProperty("osgi.framework.beginningstartlevel", string);
        this.frameworkBeginningStartLevel = Integer.parseInt(string);
        eventManager = new EventManager("Start Level Event Dispatcher");
        startLevelListeners = new EventListeners();
        startLevelListeners.addListener(this, this);
    }

    protected void cleanup() {
        eventManager.close();
        eventManager = null;
        startLevelListeners.removeAllListeners();
        startLevelListeners = null;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public int getFrameworkStartLevel() {
        return this.frameworkBeginningStartLevel;
    }

    public void setInitialBundleStartLevel(int n) {
        framework.checkAdminPermission(StartLevelManager.framework.systemBundle, "startlevel");
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.initialBundleStartLevel = n;
        StartLevelManager.framework.adaptor.setInitialBundleStartLevel(n);
    }

    public int getStartLevel() {
        return activeSL;
    }

    public void setStartLevel(int n, Bundle bundle) {
        if (n <= 0) {
            throw new IllegalArgumentException(NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + n));
        }
        framework.checkAdminPermission(StartLevelManager.framework.systemBundle, "startlevel");
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("StartLevelImpl: setStartLevel: " + n + "; callerBundle = " + bundle.getBundleId());
        }
        this.issueEvent(new StartLevelEvent(1, n, (AbstractBundle)bundle));
    }

    protected void setStartLevel(int n) {
        this.setStartLevel(n, StartLevelManager.framework.systemBundle);
    }

    protected void launch(int n) {
        this.doSetStartLevel(n, StartLevelManager.framework.systemBundle);
    }

    protected void shutdown() {
        this.doSetStartLevel(0, StartLevelManager.framework.systemBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetStartLevel(int n, AbstractBundle abstractBundle) {
        Object object = lock;
        synchronized (object) {
            int n2 = activeSL;
            if (n > n2) {
                int n3 = n2;
                while (n3 < n) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("sync - incrementing Startlevel from " + n2);
                    }
                    ++n2;
                    this.incFWSL(n3 + 1, abstractBundle);
                    ++n3;
                }
            } else {
                int n4 = n2;
                while (n4 > n) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("sync - decrementing Startlevel from " + n2);
                    }
                    --n2;
                    this.decFWSL(n4 - 1);
                    --n4;
                }
            }
            framework.publishFrameworkEvent(8, abstractBundle, null);
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("StartLevelImpl: doSetStartLevel: STARTLEVEL_CHANGED event published");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveActiveStartLevel(int n) {
        Object object = lock;
        synchronized (object) {
            activeSL = n;
        }
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(Msg.BUNDLE_UNINSTALLED_EXCEPTION);
        }
        AbstractBundle abstractBundle = (AbstractBundle)bundle;
        int n = abstractBundle.getBundleData().getStatus();
        return (n & 1) == 1;
    }

    public int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(Msg.BUNDLE_UNINSTALLED_EXCEPTION);
        }
        return ((AbstractBundle)bundle).getStartLevel();
    }

    public void setBundleStartLevel(Bundle bundle, int n) {
        block11: {
            String string = null;
            if (bundle.getBundleId() == 0L) {
                string = Msg.STARTLEVEL_CANT_CHANGE_SYSTEMBUNDLE_STARTLEVEL;
            } else if (bundle.getState() == 1) {
                string = Msg.BUNDLE_UNINSTALLED_EXCEPTION;
            } else if (n <= 0) {
                string = NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + n);
            }
            if (string != null) {
                throw new IllegalArgumentException(string);
            }
            framework.checkAdminPermission(bundle, "execute");
            try {
                if (n == ((AbstractBundle)bundle).getStartLevel()) break block11;
                final AbstractBundle abstractBundle = (AbstractBundle)bundle;
                abstractBundle.getBundleData().setStartLevel(n);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            abstractBundle.getBundleData().save();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getException() instanceof IOException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    throw (RuntimeException)privilegedActionException.getException();
                }
                this.issueEvent(new StartLevelEvent(0, n, (AbstractBundle)bundle));
            }
            catch (IOException iOException) {
                framework.publishFrameworkEvent(2, bundle, iOException);
            }
        }
    }

    private void issueEvent(StartLevelEvent startLevelEvent) {
        ListenerQueue listenerQueue = new ListenerQueue(eventManager);
        listenerQueue.queueListeners(startLevelListeners, this);
        listenerQueue.dispatchEventAsynchronous(startLevelEvent.getType(), startLevelEvent);
    }

    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        try {
            switch (n) {
                case 0: {
                    this.setBundleSL((StartLevelEvent)object3);
                    break;
                }
                case 1: {
                    this.doSetStartLevel(((StartLevelEvent)object3).getNewSL(), ((StartLevelEvent)object3).getBundle());
                }
            }
        }
        catch (Throwable throwable) {
            StartLevelManager.framework.adaptor.handleRuntimeError(throwable);
        }
    }

    protected void incFWSL(int n, AbstractBundle abstractBundle) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: incFWSL: saving activeSL of " + n);
        }
        StartLevelManager.framework.startLevelManager.saveActiveStartLevel(n);
        BundleRepository bundleRepository = StartLevelManager.framework.bundles;
        AbstractBundle[] abstractBundleArray = this.getInstalledBundles(bundleRepository);
        if (n == 1) {
            this.loadInstalledBundles(abstractBundleArray);
            this.resumeBundles(abstractBundleArray, true);
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Framework started");
            }
            framework.publishFrameworkEvent(1, abstractBundle, null);
        } else {
            this.resumeBundles(abstractBundleArray, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBundle[] getInstalledBundles(BundleRepository bundleRepository) {
        Object[] objectArray;
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List list = bundleRepository.getBundles();
            objectArray = new AbstractBundle[list.size()];
            list.toArray(objectArray);
            Util.sort(objectArray, 0, objectArray.length);
        }
        return objectArray;
    }

    private void loadInstalledBundles(AbstractBundle[] abstractBundleArray) {
        int n = 0;
        while (n < abstractBundleArray.length) {
            AbstractBundle abstractBundle = abstractBundleArray[n];
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Trying to load bundle " + abstractBundle);
            }
            abstractBundle.load();
            ++n;
        }
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, boolean bl) {
        if (bl) {
            try {
                StartLevelManager.framework.systemBundle.state = 8;
                StartLevelManager.framework.systemBundle.context.start();
            }
            catch (BundleException bundleException) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Bundle resume exception: " + bundleException.getMessage());
                    Debug.printStackTrace(bundleException.getNestedException());
                }
                framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, bundleException);
                throw new RuntimeException(bundleException.getMessage());
            }
        }
        int n = StartLevelManager.framework.startLevelManager.getStartLevel();
        int n2 = 0;
        while (n2 < abstractBundleArray.length) {
            int n3 = abstractBundleArray[n2].getStartLevel();
            if (n3 >= n) {
                if (n3 != n) break;
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Active sl = " + n + "; Bundle " + abstractBundleArray[n2].getBundleId() + " sl = " + n3);
                }
                framework.resumeBundle(abstractBundleArray[n2]);
            }
            ++n2;
        }
        StartLevelManager.framework.systemBundle.state = 32;
    }

    protected void decFWSL(int n) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: decFWSL: saving activeSL of " + n);
        }
        StartLevelManager.framework.startLevelManager.saveActiveStartLevel(n);
        BundleRepository bundleRepository = StartLevelManager.framework.bundles;
        if (n == 0) {
            this.suspendAllBundles(bundleRepository);
            this.unloadAllBundles(bundleRepository);
        } else {
            AbstractBundle[] abstractBundleArray = this.getInstalledBundles(bundleRepository);
            int n2 = abstractBundleArray.length - 1;
            while (n2 >= 0) {
                int n3 = abstractBundleArray[n2].getStartLevel();
                if (n3 <= n + 1) {
                    if (n3 <= n) break;
                    if (abstractBundleArray[n2].isActive()) {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("SLL: stopping bundle " + abstractBundleArray[n2].getBundleId());
                        }
                        framework.suspendBundle(abstractBundleArray[n2], false);
                    }
                }
                --n2;
            }
        }
    }

    private void suspendAllBundles(BundleRepository bundleRepository) {
        boolean bl;
        do {
            bl = false;
            AbstractBundle[] abstractBundleArray = this.getInstalledBundles(bundleRepository);
            int n = abstractBundleArray.length - 1;
            while (n >= 0) {
                AbstractBundle abstractBundle = abstractBundleArray[n];
                if (framework.suspendBundle(abstractBundle, false)) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("SLL: stopped bundle " + abstractBundle.getBundleId());
                    }
                    bl = true;
                }
                --n;
            }
        } while (bl);
        try {
            StartLevelManager.framework.systemBundle.context.stop();
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle suspend exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException());
            }
            framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, bundleException);
        }
        StartLevelManager.framework.systemBundle.state = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllBundles(BundleRepository bundleRepository) {
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List list = bundleRepository.getBundles();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                AbstractBundle abstractBundle = (AbstractBundle)list.get(n2);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Trying to unload bundle " + abstractBundle);
                }
                abstractBundle.refresh();
                try {
                    abstractBundle.getBundleData().close();
                }
                catch (IOException iOException) {}
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSL(StartLevelEvent startLevelEvent) {
        Object object = lock;
        synchronized (object) {
            int n = StartLevelManager.framework.startLevelManager.getStartLevel();
            int n2 = startLevelEvent.getNewSL();
            AbstractBundle abstractBundle = startLevelEvent.getBundle();
            abstractBundle.getState();
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.print("SLL: bundle active=" + abstractBundle.isActive());
                Debug.print("; newSL = " + n2);
                Debug.println("; activeSL = " + n);
            }
            if (abstractBundle.isActive() && n2 > n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: stopping bundle " + abstractBundle.getBundleId());
                }
                framework.suspendBundle(abstractBundle, false);
            } else if (!abstractBundle.isActive() && n2 <= n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: starting bundle " + abstractBundle.getBundleId());
                }
                framework.resumeBundle(abstractBundle);
            }
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle Startlevel set to " + n2);
            }
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        return new StartLevelImpl(bundle, framework);
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object object) {
    }
}

