/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class Headers
extends Dictionary {
    Object[] headers;
    Object[] values;
    int size = 0;

    public Headers(int n) {
        this.headers = new Object[n];
        this.values = new Object[n];
    }

    public Headers(Dictionary dictionary) {
        this(dictionary.size());
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.set(k, dictionary.get(k));
        }
    }

    public synchronized Enumeration keys() {
        return new ArrayEnumeration(this.headers, this.size);
    }

    public synchronized Enumeration elements() {
        return new ArrayEnumeration(this.values, this.size);
    }

    private int getIndex(Object object) {
        boolean bl = object instanceof String;
        int n = 0;
        while (n < this.size) {
            if (bl && this.headers[n] instanceof String ? ((String)this.headers[n]).equalsIgnoreCase((String)object) : this.headers[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Object remove(int n) {
        Object object = this.values[n];
        int n2 = n;
        while (n2 < this.size) {
            if (n2 == this.headers.length - 1) {
                this.headers[n2] = null;
                this.values[n2] = null;
            } else {
                this.headers[n2] = this.headers[n2 + 1];
                this.values[n2] = this.values[n2 + 1];
            }
            ++n2;
        }
        if (n < this.size) {
            --this.size;
        }
        return object;
    }

    private void add(Object object, Object object2) {
        if (this.size == this.headers.length) {
            Object[] objectArray = new Object[this.headers.length + 10];
            Object[] objectArray2 = new Object[this.values.length + 10];
            System.arraycopy(this.headers, 0, objectArray, 0, this.headers.length);
            System.arraycopy(this.values, 0, objectArray2, 0, this.values.length);
            this.headers = objectArray;
            this.values = objectArray2;
        }
        this.headers[this.size] = object;
        this.values[this.size] = object2;
        ++this.size;
    }

    public synchronized Object get(Object object) {
        int n = -1;
        n = this.getIndex(object);
        if (n != -1) {
            return this.values[n];
        }
        return null;
    }

    public synchronized Object set(Object object, Object object2, boolean bl) {
        if (object instanceof String) {
            object = ((String)object).intern();
        }
        int n = this.getIndex(object);
        if (object2 == null) {
            if (n != -1) {
                return this.remove(n);
            }
        } else {
            if (n != -1) {
                if (!bl) {
                    throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, object));
                }
                Object object3 = this.values[n];
                this.values[n] = object2;
                return object3;
            }
            this.add(object, object2);
        }
        return null;
    }

    public synchronized Object set(Object object, Object object2) {
        return this.set(object, object2, false);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.values.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Headers parseManifest(InputStream inputStream) throws BundleException {
        Headers headers2;
        try {
            try {
                BufferedReader bufferedReader;
                Headers headers = new Headers(10);
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                }
                String string = null;
                StringBuffer stringBuffer = new StringBuffer(256);
                boolean bl = true;
                while (true) {
                    int n;
                    String string2;
                    if ((string2 = bufferedReader.readLine()) == null || string2.length() == 0) {
                        if (bl) break;
                        headers.set(string, stringBuffer.toString().trim(), true);
                        break;
                    }
                    if (string2.charAt(0) == ' ') {
                        if (bl) {
                            throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_SPACE, string2));
                        }
                        stringBuffer.append(string2.substring(1));
                        continue;
                    }
                    if (!bl) {
                        headers.set(string, stringBuffer.toString().trim(), true);
                        stringBuffer.setLength(0);
                    }
                    if ((n = string2.indexOf(58)) == -1) {
                        throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_LINE_NOCOLON, string2));
                    }
                    string = string2.substring(0, n).trim();
                    stringBuffer.append(string2.substring(n + 1));
                    bl = false;
                }
                headers2 = headers;
                Object var8_10 = null;
            }
            catch (IOException iOException) {
                throw new BundleException(Msg.MANIFEST_IOEXCEPTION, iOException);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return headers2;
    }

    class ArrayEnumeration
    implements Enumeration {
        private Object[] array;
        int cur = 0;

        public ArrayEnumeration(Object[] objectArray, int n) {
            this.array = new Object[n];
            System.arraycopy(objectArray, 0, this.array, 0, this.array.length);
        }

        public boolean hasMoreElements() {
            return this.cur < this.array.length;
        }

        public Object nextElement() {
            return this.array[this.cur++];
        }
    }
}

