/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class SubProgressMonitor
extends ProgressMonitorWrapper {
    public static final int SUPPRESS_SUBTASK_LABEL = 2;
    public static final int PREPEND_MAIN_LABEL_TO_SUBTASK = 4;
    private int parentTicks = 0;
    private double sentToParent = 0.0;
    private double scale = 0.0;
    private int nestedBeginTasks = 0;
    private boolean usedUp = false;
    private boolean hasSubTask = false;
    private int style;
    private String mainTaskLabel;

    public SubProgressMonitor(IProgressMonitor iProgressMonitor, int n) {
        this(iProgressMonitor, n, 0);
    }

    public SubProgressMonitor(IProgressMonitor iProgressMonitor, int n, int n2) {
        super(iProgressMonitor);
        this.parentTicks = n;
        this.style = n2;
    }

    public void beginTask(String string, int n) {
        ++this.nestedBeginTasks;
        if (this.nestedBeginTasks > 1) {
            return;
        }
        double d = this.scale = n <= 0 ? 0.0 : (double)this.parentTicks / (double)n;
        if ((this.style & 4) != 0) {
            this.mainTaskLabel = string;
        }
    }

    public void done() {
        if (this.nestedBeginTasks == 0 || --this.nestedBeginTasks > 0) {
            return;
        }
        double d = (double)this.parentTicks - this.sentToParent;
        if (d > 0.0) {
            super.internalWorked(d);
        }
        if (this.hasSubTask) {
            this.subTask("");
        }
        this.sentToParent = 0.0;
    }

    public void internalWorked(double d) {
        if (this.usedUp || this.nestedBeginTasks != 1) {
            return;
        }
        double d2 = this.scale * d;
        super.internalWorked(d2);
        this.sentToParent += d2;
        if (this.sentToParent >= (double)this.parentTicks) {
            this.usedUp = true;
        }
    }

    public void subTask(String string) {
        if ((this.style & 2) != 0) {
            return;
        }
        this.hasSubTask = true;
        String string2 = string;
        if ((this.style & 4) != 0 && this.mainTaskLabel != null && this.mainTaskLabel.length() > 0) {
            string2 = String.valueOf(this.mainTaskLabel) + ' ' + string2;
        }
        super.subTask(string2);
    }

    public void worked(int n) {
        this.internalWorked(n);
    }
}

