/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Graphics;

import java.util.Random;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

public class GraphicsShowCase
extends ShowCase
implements PaintListener,
KeyListener,
SelectionListener {
    Canvas canvas;
    Random random = new Random();
    int drawCase;
    int counter = 0;
    boolean eraseBgd;
    final int MAX_COUNTER = 1000;
    Command commandExit;
    Command commandNext;
    Color col1;
    Color col2;

    public String getName() {
        return Messages.getString("GraphicsShowCase.0");
    }

    public void show() {
        this.canvas = new Canvas(this.getComposite(), 262144);
        Rectangle rectangle = this.getComposite().getClientArea();
        this.canvas.setBounds(rectangle);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.drawCase = 0;
        this.eraseBgd = true;
        this.commandNext = new Command((Control)this.canvas, 2, 3);
        this.commandNext.setText(Messages.getString("GraphicsShowCase.1"));
        this.commandNext.addSelectionListener((SelectionListener)this);
        this.commandNext.setDefaultCommand();
        this.commandExit = new Command((Control)this.canvas, 7, 1);
        this.commandExit.setText(Messages.getString("GraphicsShowCase.2"));
        this.commandExit.setLongLabel(Messages.getString("GraphicsShowCase.3"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.canvas.setFocus();
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.eraseBgd) {
            paintEvent.gc.fillRectangle(this.canvas.getClientArea());
            this.eraseBgd = false;
        }
        switch (this.drawCase) {
            case 0: {
                if (this.counter >= 1000) break;
                this.randomDraw(paintEvent);
                this.canvas.redraw();
                ++this.counter;
                break;
            }
            case 1: {
                this.counter = 0;
                this.drawImage(paintEvent, "/res/gif.gif");
                break;
            }
            case 2: {
                this.drawImage(paintEvent, "/res/jpeg.jpg");
                break;
            }
            case 3: {
                this.drawImage(paintEvent, "/res/png.png");
                break;
            }
            default: {
                this.quit();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void drawImage(PaintEvent paintEvent, String string) {
        Image image = new Image((Device)this.canvas.getDisplay(), this.getClass().getResourceAsStream(string));
        Rectangle rectangle = image.getBounds();
        Rectangle rectangle2 = this.canvas.getBounds();
        int n = (rectangle2.width - rectangle.width) / 2;
        int n2 = (rectangle2.height - rectangle.height) / 2;
        GC gC = new GC((Drawable)this.canvas, 0);
        gC.fillRectangle(this.canvas.getClientArea());
        gC.drawImage(image, n, n2);
        image.dispose();
    }

    private void randomDraw(PaintEvent paintEvent) {
        Rectangle rectangle = this.canvas.getClientArea();
        int n = this.random.nextInt(rectangle.width);
        int n2 = this.random.nextInt(rectangle.width);
        int n3 = this.random.nextInt(rectangle.height);
        int n4 = this.random.nextInt(rectangle.height);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        paintEvent.gc.setXORMode(this.random.nextBoolean());
        boolean bl = this.random.nextBoolean();
        if (this.col1 != null) {
            this.col1.dispose();
        }
        this.col1 = this.generateRandomColor();
        if (!bl) {
            paintEvent.gc.setForeground(this.col1);
            paintEvent.gc.setLineStyle(this.random.nextInt(5) + 1);
            switch (this.random.nextInt(7)) {
                case 0: {
                    paintEvent.gc.drawLine(n, n3, n2, n4);
                    break;
                }
                case 1: {
                    paintEvent.gc.drawRectangle(n, n3, n5, n6);
                    break;
                }
                case 2: {
                    paintEvent.gc.drawOval(n, n3, n5, n6);
                    break;
                }
                case 3: {
                    int n7 = this.random.nextInt();
                    int n8 = this.random.nextInt(361);
                    paintEvent.gc.drawArc(n, n3, n5, n6, n7, n8);
                    break;
                }
                case 4: {
                    paintEvent.gc.drawPolygon(this.generateRandomPoints());
                    break;
                }
                case 5: {
                    paintEvent.gc.drawPolyline(this.generateRandomPoints());
                    break;
                }
                case 6: {
                    int n9 = Math.abs(n5) / 2;
                    int n10 = Math.abs(n6) / 2;
                    int n11 = n9 != 0 ? this.random.nextInt(n9) : 0;
                    int n12 = n10 != 0 ? this.random.nextInt(n10) : 0;
                    paintEvent.gc.drawRoundRectangle(n, n3, n5, n6, n11, n12);
                }
            }
        } else {
            paintEvent.gc.setBackground(this.col1);
            switch (this.random.nextInt(6)) {
                case 0: {
                    paintEvent.gc.fillRectangle(n, n3, n5, n6);
                    break;
                }
                case 1: {
                    paintEvent.gc.fillOval(n, n3, n5, n6);
                    break;
                }
                case 2: {
                    int n13 = this.random.nextInt();
                    int n14 = this.random.nextInt(361);
                    paintEvent.gc.fillArc(n, n3, n5, n6, n13, n14);
                    break;
                }
                case 3: {
                    paintEvent.gc.fillPolygon(this.generateRandomPoints());
                    break;
                }
                case 4: {
                    int n15 = Math.abs(n5) / 2;
                    int n16 = Math.abs(n6) / 2;
                    int n17 = n15 != 0 ? this.random.nextInt(n15) : 0;
                    int n18 = n16 != 0 ? this.random.nextInt(n16) : 0;
                    paintEvent.gc.fillRoundRectangle(n, n3, n5, n6, n17, n18);
                }
                case 5: {
                    if (this.col2 != null) {
                        this.col2.dispose();
                    }
                    this.col2 = this.generateRandomColor();
                    paintEvent.gc.setForeground(this.col2);
                    paintEvent.gc.fillGradientRectangle(n, n3, n5, n6, this.random.nextBoolean());
                }
            }
        }
    }

    private int[] generateRandomPoints() {
        Rectangle rectangle = this.canvas.getClientArea();
        int n = this.random.nextInt(100) + 2;
        int[] nArray = new int[n * 2];
        int n2 = 0;
        while (n2 < n * 2) {
            nArray[n2] = this.random.nextInt(rectangle.width);
            nArray[n2 + 1] = this.random.nextInt(rectangle.height);
            n2 += 2;
        }
        return nArray;
    }

    private Color generateRandomColor() {
        int n = this.random.nextInt(256);
        int n2 = this.random.nextInt(256);
        int n3 = this.random.nextInt(256);
        return new Color((Device)this.canvas.getDisplay(), n, n2, n3);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandExit) {
            this.counter = 0;
            this.quit();
        } else if (selectionEvent.widget == this.commandNext) {
            ++this.drawCase;
            this.eraseBgd = true;
            this.canvas.redraw();
        }
    }

    public void quit() {
        if (this.col1 != null) {
            this.col1.dispose();
        }
        if (this.col2 != null) {
            this.col2.dispose();
        }
        this.canvas.dispose();
        this.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

