/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.ManageScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UninstallScreen
extends AbsScreen {
    private static final int PROGRESS_MAX_VALUE = 20;
    private Composite pane;
    private Label featureName;
    private ProgressBar featureProgress;
    private IFeature uninstalledFeature;

    UninstallScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(null);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        this.pane.setLayout((Layout)new RowLayout(256));
        new Label(this.pane, 0).setText(UIMessages.Uninstalling);
        this.featureName = new Label(this.pane, 0);
        this.featureProgress = new ProgressBar(this.screen, 65536);
        this.featureProgress.setMaximum(20);
        this.fillSpace();
        this.screen.layout();
    }

    public void refresh() {
        this.uninstalledFeature = (IFeature)this.view.availableFeatures.elementAt(0);
        this.featureName.setText(this.uninstalledFeature.getLabel());
        this.screen.layout();
    }

    protected void action() {
        MessageBox messageBox;
        if (this.uninstalledFeature == null) {
            this.uninstalledFeature = (IFeature)this.view.availableFeatures.elementAt(0);
        }
        IConfiguredSite iConfiguredSite = null;
        iConfiguredSite = this.uninstalledFeature.getSite().getCurrentConfiguredSite();
        this.featureProgress.setSelection(6);
        if (iConfiguredSite == null) {
            System.out.println("Error: error to get configured site for uninstallation.");
            return;
        }
        boolean bl = false;
        UnconfigureAndUninstallFeatureOperation unconfigureAndUninstallFeatureOperation = (UnconfigureAndUninstallFeatureOperation)((OperationFactory)OperationsManager.getOperationFactory()).createUnconfigureAndUninstallFeatureOperation(iConfiguredSite, this.uninstalledFeature);
        try {
            bl = unconfigureAndUninstallFeatureOperation.execute(null, null);
            SiteManager.getLocalSite().save();
            this.featureProgress.setSelection(20);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        this.view.enableRestartCommand = true;
        if (bl) {
            if (this.uninstalledFeature.getVersionedIdentifier().getIdentifier().startsWith(ManageScreen.JVM_LIB_FEATURE_NAME)) {
                messageBox = new MessageBox(this.screen.getShell(), 194);
                messageBox.setText(UIMessages.ConfirmRestart);
                messageBox.setMessage(NLS.bind((String)UIMessages.NeedRestartManually, (Object[])this.view.RuntimeName));
                if (messageBox.open() == 64) {
                    System.getProperties().put("eworkbench.returnCode", new Integer(0));
                    PlatformUI.getWorkbench().close();
                }
            } else {
                messageBox = new MessageBox(this.screen.getShell(), 194);
                messageBox.setText(UIMessages.ConfirmRestart);
                messageBox.setMessage(NLS.bind((String)UIMessages.RecommendToRestart, (Object[])this.view.RuntimeName));
                if (messageBox.open() == 64) {
                    System.getProperties().put("eworkbench.returnCode", new Integer(1));
                    PlatformUI.getWorkbench().close();
                } else {
                    this.view.deletedFeatures.add(this.uninstalledFeature.getVersionedIdentifier());
                    this.setVisible(false);
                    ((Object)((Object)this.view)).getClass();
                    ((Object)((Object)this.view)).getClass();
                    this.view.showScreen(0, true);
                }
            }
        } else {
            messageBox = new MessageBox(this.screen.getShell(), 33);
            messageBox.setText(UIMessages.UninstallStatus);
            messageBox.setMessage(UIMessages.UninstallNotCompleted);
            messageBox.open();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, true);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }
}

