/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaIo;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaNio;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;

public class BasicLocation
implements Location {
    private boolean isReadOnly;
    private URL location = null;
    private Location parent;
    private URL defaultValue;
    private String property;
    private File lockFile;
    private Locker locker;
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    private static String LOCK_FILENAME = ".metadata/.lock";
    public static boolean DEBUG;

    private static boolean isRunningWithNio() {
        try {
            Class.forName("java.nio.channels.FileLock");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static Locker createLocker(File file, String string) {
        if (string == null) {
            string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        }
        if ("none".equals(string)) {
            return new MockLocker();
        }
        if ("java.io".equals(string)) {
            return new Locker_JavaIo(file);
        }
        if ("java.nio".equals(string)) {
            if (BasicLocation.isRunningWithNio()) {
                return new Locker_JavaNio(file);
            }
            return new Locker_JavaIo(file);
        }
        if (BasicLocation.isRunningWithNio()) {
            return new Locker_JavaNio(file);
        }
        return new Locker_JavaIo(file);
    }

    public BasicLocation(String string, URL uRL, boolean bl) {
        this.property = string;
        this.defaultValue = uRL;
        this.isReadOnly = bl;
    }

    public boolean allowsDefault() {
        return this.defaultValue != null;
    }

    public URL getDefault() {
        return this.defaultValue;
    }

    public Location getParentLocation() {
        return this.parent;
    }

    public synchronized URL getURL() {
        if (this.location == null && this.defaultValue != null) {
            this.setURL(this.defaultValue, false);
        }
        return this.location;
    }

    public synchronized boolean isSet() {
        return this.location != null;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public synchronized boolean setURL(URL uRL, boolean bl) throws IllegalStateException {
        if (this.location != null) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_CANNOT_CHANGE_LOCATION);
        }
        File file = null;
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            try {
                String string = new File(uRL.getFile()).getCanonicalPath();
                uRL = new URL("file:" + string);
            }
            catch (IOException iOException) {}
            file = new File(uRL.getFile(), LOCK_FILENAME);
        }
        boolean bl2 = bl = bl && !this.isReadOnly;
        if (bl) {
            try {
                if (!this.lock(file)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        this.lockFile = file;
        this.location = LocationManager.buildURL(uRL.toExternalForm(), true);
        if (this.property != null) {
            FrameworkProperties.setProperty(this.property, this.location.toExternalForm());
        }
        return bl;
    }

    public synchronized void setParent(Location location) {
        this.parent = location;
    }

    public synchronized boolean lock() throws IOException {
        if (!this.isSet()) {
            return false;
        }
        return this.lock(this.lockFile);
    }

    private boolean lock(File file) throws IOException {
        if (file == null || this.isReadOnly) {
            return false;
        }
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            return false;
        }
        this.setLocker(file);
        if (this.locker == null) {
            return true;
        }
        boolean bl = false;
        try {
            boolean bl2 = bl = this.locker.lock();
            Object var4_5 = null;
            if (!bl) {
                this.locker = null;
            }
            return bl2;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_6 = null;
                if (bl) break block6;
                this.locker = null;
            }
            throw throwable;
        }
    }

    private void setLocker(File file) {
        if (this.locker != null) {
            return;
        }
        String string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        this.locker = BasicLocation.createLocker(file, string);
    }

    public synchronized void release() {
        if (this.locker != null) {
            this.locker.release();
        }
    }

    private static class MockLocker
    implements Locker {
        private MockLocker() {
        }

        public boolean lock() throws IOException {
            return true;
        }

        public void release() {
        }
    }
}

