/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.IOException;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;

public class MRUBundleFileList
implements EventDispatcher {
    private static final String PROP_FILE_LIMIT = "osgi.bundlefile.limit";
    private static final int MIN = 10;
    private BundleFile[] bundleFileList;
    private long[] useStampList;
    private long curUseStamp = 0L;
    private int fileLimit = 0;
    private int numOpen = 0;
    private EventManager bundleFileCloserManager;
    private EventListeners bundleFileCloser;

    public MRUBundleFileList() {
        try {
            String string = BundleFile.secureAction.getProperty(PROP_FILE_LIMIT);
            if (string != null) {
                this.init(Integer.parseInt(string));
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public MRUBundleFileList(int n) {
        this.init(n);
    }

    private void init(int n) {
        if (n >= 10) {
            this.fileLimit = n;
            this.bundleFileList = new BundleFile[n];
            this.useStampList = new long[n];
            this.bundleFileCloserManager = new EventManager("Bundle File Closer");
            this.bundleFileCloser = new EventListeners();
            this.bundleFileCloser.addListener(this, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BundleFile bundleFile) throws IOException {
        if (this.fileLimit < 10) {
            return;
        }
        BundleFile bundleFile2 = null;
        BundleFile[] bundleFileArray = this.bundleFileList;
        synchronized (this.bundleFileList) {
            int n = 0;
            if (this.numOpen < this.fileLimit) {
                int n2 = 0;
                while (n2 < this.fileLimit) {
                    if (this.bundleFileList[n2] == null) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            } else {
                n = 0;
                int n3 = 1;
                while (n3 < this.fileLimit) {
                    if (this.useStampList[n3] < this.useStampList[n]) {
                        n = n3;
                    }
                    ++n3;
                }
                bundleFile2 = this.bundleFileList[n];
                this.remove(bundleFile2);
            }
            this.bundleFileList[n] = bundleFile;
            bundleFile.setMruIndex(n);
            this.incUseStamp(n);
            ++this.numOpen;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.closeBundleFile(bundleFile2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return false;
        }
        BundleFile[] bundleFileArray = this.bundleFileList;
        synchronized (this.bundleFileList) {
            block5: {
                int n = bundleFile.getMruIndex();
                if (n < 0 || n >= this.fileLimit || this.bundleFileList[n] != bundleFile) break block5;
                bundleFile.setMruIndex(-1);
                this.bundleFileList[n] = null;
                this.useStampList[n] = -1L;
                --this.numOpen;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void use(BundleFile bundleFile) {
        if (this.fileLimit < 10) {
            return;
        }
        BundleFile[] bundleFileArray = this.bundleFileList;
        synchronized (this.bundleFileList) {
            int n = bundleFile.getMruIndex();
            if (n >= 0 && n < this.fileLimit && this.bundleFileList[n] == bundleFile) {
                this.incUseStamp(n);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void incUseStamp(int n) {
        if (this.curUseStamp == Long.MAX_VALUE) {
            int n2 = 0;
            while (n2 < this.fileLimit) {
                this.useStampList[n2] = 0L;
                ++n2;
            }
            this.curUseStamp = 0L;
        }
        this.useStampList[n] = ++this.curUseStamp;
    }

    public final void dispatchEvent(Object object, Object object2, int n, Object object3) {
        try {
            ((BundleFile)object3).close();
        }
        catch (IOException iOException) {}
    }

    private void closeBundleFile(BundleFile bundleFile) {
        if (bundleFile == null) {
            return;
        }
        ListenerQueue listenerQueue = new ListenerQueue(this.bundleFileCloserManager);
        listenerQueue.queueListeners(this.bundleFileCloser, this);
        listenerQueue.dispatchEventAsynchronous(0, bundleFile);
    }
}

