/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class AbstractBundle
implements Bundle,
Comparable,
KeyedElement {
    protected Framework framework;
    protected volatile int state = 2;
    protected volatile Thread stateChanging = null;
    protected BundleData bundledata;
    protected Object statechangeLock = new Object();
    protected BundleProtectionDomain domain;
    protected ManifestLocalization manifestLocalization = null;

    protected static AbstractBundle createBundle(BundleData bundleData, Framework framework) throws BundleException {
        if ((bundleData.getType() & 1) > 0) {
            return new BundleFragment(bundleData, framework);
        }
        return new BundleHost(bundleData, framework);
    }

    protected AbstractBundle(BundleData bundleData, Framework framework) {
        this.bundledata = bundleData;
        this.framework = framework;
        bundleData.setBundle(this);
    }

    protected abstract void load();

    protected abstract boolean reload(AbstractBundle var1);

    protected abstract void refresh();

    protected abstract boolean unload();

    protected void close() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.close called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.state = 1;
    }

    protected BundleActivator loadBundleActivator() throws BundleException {
        String string = this.bundledata.getActivator();
        if (string != null) {
            try {
                Class clazz = this.loadClass(string, false);
                return (BundleActivator)clazz.newInstance();
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(throwable);
                }
                throw new BundleException(NLS.bind(Msg.BUNDLE_INVALID_ACTIVATOR_EXCEPTION, string, this.bundledata.getSymbolicName()), throwable);
            }
        }
        return null;
    }

    protected abstract Class loadClass(String var1, boolean var2) throws ClassNotFoundException;

    public int getState() {
        return this.state;
    }

    protected boolean isActive() {
        return (this.state & 0x28) != 0;
    }

    protected boolean isResolved() {
        return (this.state & 3) == 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws BundleException {
        this.framework.checkAdminPermission(this, "execute");
        this.checkValid();
        this.beginStateChange();
        try {
            this.startWorker(true);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    protected abstract void startWorker(boolean var1) throws BundleException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resume() throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            this.startWorker(false);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws BundleException {
        this.framework.checkAdminPermission(this, "execute");
        this.checkValid();
        this.beginStateChange();
        try {
            this.stopWorker(true);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    protected abstract void stopWorker(boolean var1) throws BundleException;

    protected void setStatus(final int n, final boolean bl) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException, IOException {
                    boolean bl3;
                    int n2 = AbstractBundle.this.bundledata.getStatus();
                    boolean bl2 = bl3 = (n2 & n) != 0;
                    if (bl3 != bl) {
                        AbstractBundle.this.bundledata.setStatus(bl ? n2 | n : n2 & ~n);
                        AbstractBundle.this.bundledata.save();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.framework.publishFrameworkEvent(2, this, privilegedActionException.getException());
        }
    }

    /*
     * Exception decompiling
     */
    protected void suspend(boolean var1_1) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 38->42)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.bundledata.getLocation());
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 6) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            final AccessControlContext accessControlContext = AccessController.getContext();
            this.updateWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    String string = AbstractBundle.this.bundledata.getLocation();
                    if (AbstractBundle.this.bundledata.getManifest().get("Bundle-UpdateLocation") != null) {
                        string = (String)AbstractBundle.this.bundledata.getManifest().get("Bundle-UpdateLocation");
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("   from location: " + string);
                        }
                    }
                    URLConnection uRLConnection = AbstractBundle.this.framework.adaptor.mapLocationToURLConnection(string);
                    AbstractBundle.this.updateWorkerPrivileged(uRLConnection, accessControlContext);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(final InputStream inputStream) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.bundledata.getLocation());
            Debug.println("   from: " + inputStream);
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 6) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            final AccessControlContext accessControlContext = AccessController.getContext();
            this.updateWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    BundleSource bundleSource = new BundleSource(inputStream);
                    AbstractBundle.this.updateWorkerPrivileged(bundleSource, accessControlContext);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.completeStateChange();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void updateWorker(PrivilegedExceptionAction var1_1) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 140->144)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWorkerPrivileged(URLConnection uRLConnection, AccessControlContext accessControlContext) throws BundleException {
        AbstractBundle abstractBundle = AbstractBundle.createBundle(this.bundledata, this.framework);
        boolean bl = false;
        BundleOperation bundleOperation = this.framework.adaptor.updateBundle(this.bundledata, uRLConnection);
        BundleRepository bundleRepository = this.framework.getBundles();
        try {
            boolean bl2;
            BundleData bundleData = bundleOperation.begin();
            final AbstractBundle abstractBundle2 = this.framework.createAndVerifyBundle(bundleData);
            String[] stringArray = this.framework.selectNativeCode(abstractBundle2);
            if (stringArray != null) {
                this.bundledata.installNativeCode(stringArray);
            }
            int n = this.getState();
            BundleRepository bundleRepository2 = bundleRepository;
            synchronized (bundleRepository2) {
                bl2 = this.reload(abstractBundle2);
                this.manifestLocalization = null;
            }
            bl = true;
            if (System.getSecurityManager() != null) {
                boolean bl3;
                boolean bl4 = bl3 = (this.bundledata.getType() & 6) != 0;
                if (bl3 && !this.hasPermission(new AllPermission())) {
                    throw new BundleException(Msg.BUNDLE_EXTENSION_PERMISSION, new SecurityException(Msg.BUNDLE_EXTENSION_PERMISSION));
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            AbstractBundle.this.framework.checkAdminPermission(abstractBundle2, "lifecycle");
                            if (bl3) {
                                AbstractBundle.this.framework.checkAdminPermission(abstractBundle2, "extensionLifecycle");
                            }
                            return null;
                        }
                    }, accessControlContext);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            if (n == 4) {
                this.framework.publishBundleEvent(64, this);
            }
            bundleOperation.commit(bl2);
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    bundleOperation.undo();
                    if (!bl) break block18;
                    BundleRepository bundleRepository3 = bundleRepository;
                    synchronized (bundleRepository3) {
                        this.reload(abstractBundle);
                    }
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, this, bundleException);
                }
            }
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            if (throwable instanceof BundleException) {
                throw (BundleException)throwable;
            }
            throw new BundleException(throwable.getMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("uninstall location: " + this.bundledata.getLocation());
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 6) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            this.uninstallWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    AbstractBundle.this.uninstallWorkerPrivileged();
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.completeStateChange();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.completeStateChange();
            return;
        }
    }

    protected void uninstallWorker(PrivilegedExceptionAction privilegedExceptionAction) throws BundleException {
        boolean bl = false;
        if (!this.isFragment()) {
            boolean bl2 = bl = this.state == 32;
        }
        if (bl) {
            try {
                this.stopWorker(true);
            }
            catch (BundleException bundleException) {
                this.framework.publishFrameworkEvent(2, this, bundleException);
            }
        }
        try {
            AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (bl) {
                try {
                    this.startWorker(false);
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, this, bundleException);
                }
            }
            throw (BundleException)privilegedActionException.getException();
        }
        this.framework.publishBundleEvent(16, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void uninstallWorkerPrivileged() throws BundleException {
        BundleWatcher bundleWatcher = this.framework.adaptor.getBundleWatcher();
        if (bundleWatcher != null) {
            bundleWatcher.watchBundle(this, 64);
        }
        boolean bl = false;
        this.getHeaders();
        BundleOperation bundleOperation = this.framework.adaptor.uninstallBundle(this.bundledata);
        BundleRepository bundleRepository = this.framework.getBundles();
        try {
            try {
                boolean bl2;
                bundleOperation.begin();
                int n = this.getState();
                BundleRepository bundleRepository2 = bundleRepository;
                synchronized (bundleRepository2) {
                    bundleRepository.remove(this);
                    bl2 = this.unload();
                }
                if (n == 4) {
                    this.framework.publishBundleEvent(64, this);
                }
                bl = true;
                bundleOperation.commit(bl2);
                this.close();
            }
            catch (BundleException bundleException) {
                try {
                    bundleOperation.undo();
                    if (!bl) throw bundleException;
                    BundleRepository bundleRepository3 = bundleRepository;
                    synchronized (bundleRepository3) {
                        this.load();
                        bundleRepository.add(this);
                        throw bundleException;
                    }
                }
                catch (BundleException bundleException2) {
                    this.framework.publishFrameworkEvent(2, this, bundleException2);
                }
                throw bundleException;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            BundleWatcher bundleWatcher2 = this.framework.adaptor.getBundleWatcher();
            if (bundleWatcher2 == null) throw throwable;
            bundleWatcher2.watchBundle(this, 128);
            throw throwable;
        }
        {
            Object var7_13 = null;
            BundleWatcher bundleWatcher3 = this.framework.adaptor.getBundleWatcher();
            if (bundleWatcher3 == null) return;
            bundleWatcher3.watchBundle(this, 128);
            return;
        }
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String string) {
        this.framework.checkAdminPermission(this, "metadata");
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException bundleException) {
            this.framework.publishFrameworkEvent(2, this, bundleException);
            return new Hashtable();
        }
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        return this.manifestLocalization.getHeaders(string);
    }

    public long getBundleId() {
        return this.bundledata.getBundleID();
    }

    public String getLocation() {
        this.framework.checkAdminPermission(this, "metadata");
        return this.bundledata.getLocation();
    }

    public boolean hasPermission(Object object) {
        this.checkValid();
        if (this.domain != null) {
            if (object instanceof Permission) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager instanceof FrameworkSecurityManager) {
                    AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{this.domain});
                    try {
                        securityManager.checkPermission((Permission)object, accessControlContext);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return this.domain.implies((Permission)object);
            }
            return false;
        }
        return true;
    }

    protected void beginStateChange() throws BundleException {
        Object object = this.statechangeLock;
        synchronized (object) {
            boolean bl = false;
            while (true) {
                if (this.stateChanging == null) {
                    this.stateChanging = Thread.currentThread();
                    return;
                }
                if (bl || this.stateChanging == Thread.currentThread()) {
                    throw new BundleException(NLS.bind(Msg.BUNDLE_STATE_CHANGE_EXCEPTION, this.getBundleData().getLocation(), this.stateChanging.getName()));
                }
                try {
                    long l;
                    long l2 = 0L;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(" Waiting for state to change in bundle " + this);
                        l2 = System.currentTimeMillis();
                    }
                    this.statechangeLock.wait(5000L);
                    if (Debug.DEBUG_GENERAL && (l = System.currentTimeMillis()) - l2 > 0L) {
                        System.out.println("Waiting... : " + this.getSymbolicName() + ' ' + (l - l2));
                    }
                }
                catch (InterruptedException interruptedException) {}
                bl = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeStateChange() {
        Object object = this.statechangeLock;
        synchronized (object) {
            if (this.stateChanging != null) {
                this.stateChanging = null;
                this.statechangeLock.notify();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.bundledata.getLocation()) + " [" + this.getBundleId() + "]";
    }

    public int compareTo(Object object) {
        int n = this.getStartLevel() - ((AbstractBundle)object).getStartLevel();
        if (n != 0) {
            return n;
        }
        long l = this.getBundleId() - ((AbstractBundle)object).getBundleId();
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }

    protected void checkValid() {
        if (this.state == 1) {
            throw new IllegalStateException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
    }

    protected BundleProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    protected void unresolvePermissions() {
        if (this.domain != null) {
            BundlePermissionCollection bundlePermissionCollection = (BundlePermissionCollection)this.domain.getPermissions();
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unresolving permissions in bundle " + this);
            }
            bundlePermissionCollection.unresolvePermissions();
        }
    }

    protected Bundle[] getFragments() {
        this.checkValid();
        return null;
    }

    protected boolean isFragment() {
        return false;
    }

    protected BundleLoaderProxy[] getHosts() {
        this.checkValid();
        return null;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public Enumeration getEntryPaths(final String string) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AbstractBundle.this.bundledata.getEntryPaths(string);
            }
        });
    }

    public URL getEntry(String string) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (System.getSecurityManager() == null) {
            return this.bundledata.getEntry(string);
        }
        final String string2 = string;
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AbstractBundle.this.bundledata.getEntry(string2);
            }
        });
    }

    public String getSymbolicName() {
        return this.bundledata.getSymbolicName();
    }

    public long getLastModified() {
        return this.bundledata.getLastModified();
    }

    public BundleData getBundleData() {
        return this.bundledata;
    }

    public Version getVersion() {
        return this.bundledata.getVersion();
    }

    protected BundleDescription getBundleDescription() {
        return this.framework.adaptor.getState().getBundle(this.getBundleId());
    }

    protected int getStartLevel() {
        return this.bundledata.getStartLevel();
    }

    protected abstract BundleLoader getBundleLoader();

    protected void resolve() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.resolve called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 2) {
            this.state = 4;
        }
    }

    protected abstract BundleContextImpl getContext();

    public String getResolutionFailureMessage() {
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return Msg.BUNDLE_UNRESOLVED_EXCEPTION;
        }
        if (bundleDescription.isResolved()) {
            throw new IllegalStateException(Msg.BUNDLE_UNRESOLVED_STATE_CONFLICT);
        }
        return NLS.bind(Msg.BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION, this.getResolverError(bundleDescription));
    }

    private String getResolverError(BundleDescription bundleDescription) {
        ResolverError[] resolverErrorArray = this.framework.adaptor.getState().getResolverErrors(bundleDescription);
        if (resolverErrorArray == null || resolverErrorArray.length == 0) {
            return Msg.BUNDLE_UNRESOLVED_EXCEPTION;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < resolverErrorArray.length) {
            stringBuffer.append(resolverErrorArray[n].toString());
            if (n < resolverErrorArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getKeyHashCode() {
        return (int)this.getBundleId();
    }

    public boolean compare(KeyedElement keyedElement) {
        return this.getBundleId() == ((AbstractBundle)keyedElement).getBundleId();
    }

    public Object getKey() {
        return new Long(this.getBundleId());
    }

    public ResourceBundle getResourceBundle(String string) {
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException bundleException) {
            return null;
        }
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        return this.manifestLocalization.getResourceBundle(string);
    }

    private void initializeManifestLocalization() throws BundleException {
        if (this.manifestLocalization == null) {
            Dictionary dictionary = this.bundledata.getManifest();
            this.manifestLocalization = new ManifestLocalization(this, dictionary);
        }
    }

    public boolean testStateChanging(Object object) {
        return this.stateChanging == object;
    }

    public Thread getStateChanging() {
        return this.stateChanging;
    }

    public Enumeration findEntries(String string, String string2, boolean bl) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (!this.isResolved()) {
            this.framework.packageAdmin.resolveBundles(new Bundle[]{this});
        }
        ArrayList arrayList = new ArrayList();
        FilterImpl filterImpl = null;
        Hashtable hashtable = null;
        if (string2 != null) {
            try {
                filterImpl = new FilterImpl("(filename=" + string2 + ")");
                hashtable = new Hashtable(2);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        this.findLocalEntryPaths(string, filterImpl, hashtable, bl, arrayList);
        final Bundle[] bundleArray = this.getFragments();
        final int n = bundleArray == null ? -1 : bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((AbstractBundle)bundleArray[n2]).findLocalEntryPaths(string, filterImpl, hashtable, bl, arrayList);
            ++n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        final String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return new Enumeration(){
            int curIndex = 0;
            int curFragment = -1;
            URL nextElement = null;
            boolean noMoreElements = false;

            public boolean hasMoreElements() {
                if (this.nextElement != null) {
                    return true;
                }
                this.getNextElement();
                return this.nextElement != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.nextElement;
                this.getNextElement();
                return uRL;
            }

            private void getNextElement() {
                this.nextElement = null;
                if (this.curIndex >= stringArray.length) {
                    return;
                }
                String string = stringArray[this.curIndex];
                if (this.curFragment == -1) {
                    this.nextElement = AbstractBundle.this.getEntry(string);
                    ++this.curFragment;
                }
                while (this.nextElement == null && this.curFragment < n) {
                    this.nextElement = bundleArray[this.curFragment++].getEntry(string);
                }
                if (n == -1 || this.curFragment >= n) {
                    ++this.curIndex;
                    this.curFragment = -1;
                }
                if (this.nextElement == null) {
                    this.getNextElement();
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected void findLocalEntryPaths(String var1_1, Filter var2_2, Hashtable var3_3, boolean var4_4, List var5_5) {
        var6_6 = this.bundledata.getEntryPaths(var1_1);
        if (var6_6 != null) ** GOTO lbl25
        return;
lbl-1000:
        // 1 sources

        {
            var7_7 = (String)var6_6.nextElement();
            var8_8 = var7_7.lastIndexOf(47);
            if (var3_3 != null) {
                var9_9 = var7_7.lastIndexOf(47, var8_8 - 1);
                var11_11 = var7_7.length();
                if (var8_8 < 0) {
                    var10_10 = 0;
                } else if (var8_8 != var7_7.length() - 1) {
                    var10_10 = var8_8 + 1;
                } else {
                    var11_11 = var8_8;
                    var10_10 = var9_9 < 0 ? 0 : var9_9 + 1;
                }
                var12_12 = var7_7.substring(var10_10, var11_11);
                var3_3.put("filename", var12_12);
            }
            if (!var5_5.contains(var7_7) && (var2_2 == null || var2_2.matchCase(var3_3))) {
                var5_5.add(var7_7);
            }
            if (!var4_4 || var7_7.equals(var1_1) || var7_7.length() <= 0 || var8_8 != var7_7.length() - 1) continue;
            this.findLocalEntryPaths(var7_7, var2_2, var3_3, var4_4, var5_5);
lbl25:
            // 3 sources

            ** while (var6_6.hasMoreElements())
        }
lbl26:
        // 1 sources

    }
}

