/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionSet;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissions;

final class BundleCombinedPermissions
extends BundlePermissionCollection {
    private static final long serialVersionUID = 4049357526208360496L;
    private static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private BundlePermissionCollection assigned;
    private BundlePermissionCollection implied;
    private ConditionalPermissions conditional;
    private ConditionalPermissionSet restrictedPermissions;
    private boolean isDefault;

    BundleCombinedPermissions(BundlePermissionCollection bundlePermissionCollection) {
        this.implied = bundlePermissionCollection;
        this.setReadOnly();
    }

    void setAssignedPermissions(BundlePermissionCollection bundlePermissionCollection, boolean bl) {
        this.assigned = bundlePermissionCollection;
        this.isDefault = bl;
    }

    void setConditionalPermissions(ConditionalPermissions conditionalPermissions) {
        this.conditional = conditionalPermissions;
    }

    void checkConditionalPermissionInfo(ConditionalPermissionInfoImpl conditionalPermissionInfoImpl) {
        if (this.conditional != null) {
            this.conditional.checkConditionalPermissionInfo(conditionalPermissionInfoImpl);
        }
    }

    void unresolvePermissions() {
        if (this.assigned != null) {
            this.assigned.unresolvePermissions();
        }
        if (this.implied != null) {
            this.implied.unresolvePermissions();
        }
        if (this.conditional != null) {
            this.conditional.unresolvePermissions();
        }
        if (this.restrictedPermissions != null) {
            this.restrictedPermissions.unresolvePermissions();
        }
    }

    public void add(Permission permission) {
        throw new SecurityException();
    }

    public Enumeration elements() {
        return EMPTY_ENUMERATION;
    }

    public boolean implies(Permission permission) {
        if (this.implied != null && this.implied.implies(permission)) {
            return true;
        }
        if (this.restrictedPermissions != null && !this.restrictedPermissions.implies(permission)) {
            return false;
        }
        if (!this.isDefault && this.assigned != null) {
            return this.assigned.implies(permission);
        }
        if (this.conditional != null) {
            boolean bl = this.conditional.implies(permission);
            if (!this.conditional.isEmpty()) {
                return bl;
            }
        }
        return this.assigned.implies(permission);
    }

    public void setRestrictedPermissions(ConditionalPermissionSet conditionalPermissionSet) {
        this.restrictedPermissions = conditionalPermissionSet;
    }
}

