/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleHost
extends AbstractBundle {
    private BundleLoaderProxy proxy;
    protected BundleContextImpl context = null;
    protected BundleFragment[] fragments = null;

    public BundleHost(BundleData bundleData, Framework framework) throws BundleException {
        super(bundleData, framework);
    }

    protected void load() {
        SecurityManager securityManager;
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.load called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.proxy != null) {
                Debug.println("Bundle.load called when proxy != null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        if (this.framework.isActive() && (securityManager = System.getSecurityManager()) != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        this.proxy = null;
    }

    protected boolean reload(AbstractBundle abstractBundle) {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean bl = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy();
                bl = bundleLoaderProxy.inUse();
                if (bl) {
                    bundleLoaderProxy.getBundleLoader().createClassLoader();
                } else {
                    BundleHost.closeBundleLoader(this.proxy);
                }
                this.state = 2;
                this.proxy = null;
                this.fragments = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = abstractBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null && this.framework.permissionAdmin != null) {
            this.domain = this.framework.permissionAdmin.createProtectionDomain(this);
        }
        return bl;
    }

    protected void refresh() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.reload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            BundleHost.closeBundleLoader(this.proxy);
            this.proxy = null;
            this.fragments = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean bl = false;
        if (this.framework.isActive() && this.state == 4) {
            BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy();
            bl = bundleLoaderProxy.inUse();
            if (bl) {
                bundleLoaderProxy.getBundleLoader().createClassLoader();
            } else {
                BundleHost.closeBundleLoader(this.proxy);
            }
            this.state = 2;
            this.proxy = null;
            this.fragments = null;
            this.domain = null;
        }
        if (!bl) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    private BundleLoader checkLoader() {
        BundleLoader bundleLoader;
        this.checkValid();
        if (!this.isResolved() && !this.framework.packageAdmin.resolveBundles(new Bundle[]{this})) {
            return null;
        }
        if (Debug.DEBUG_GENERAL && (this.state & 0x3C) == 0) {
            Debug.println("Bundle.checkLoader() called when state != STARTING | ACTIVE | STOPPING | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if ((bundleLoader = this.getBundleLoader()) == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.checkLoader() called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return bundleLoader;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        BundleLoader bundleLoader;
        if (bl) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException securityException) {
                throw new ClassNotFoundException();
            }
        }
        if ((bundleLoader = this.checkLoader()) == null) {
            throw new ClassNotFoundException(NLS.bind(Msg.BUNDLE_CNFE_NOT_RESOLVED, this.getBundleData().getLocation(), string));
        }
        return bundleLoader.loadClass(string);
    }

    public URL getResource(String string) {
        BundleLoader bundleLoader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        bundleLoader = this.checkLoader();
        if (bundleLoader == null) {
            return null;
        }
        return bundleLoader.getResource(string);
    }

    public Enumeration getResources(String string) throws IOException {
        BundleLoader bundleLoader = null;
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        bundleLoader = this.checkLoader();
        if (bundleLoader == null) {
            return null;
        }
        Enumeration enumeration = bundleLoader.getResources(string);
        if (enumeration.hasMoreElements()) {
            return enumeration;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected void startWorker(boolean var1_1) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 475->479)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected BundleContextImpl createContext() {
        return new BundleContextImpl(this);
    }

    protected BundleContextImpl getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopWorker(boolean bl) throws BundleException {
        if (bl) {
            this.setStatus(1, false);
        }
        if (!this.framework.active) return;
        if ((this.state & 0x16) != 0) {
            return;
        }
        BundleWatcher bundleWatcher = this.framework.adaptor.getBundleWatcher();
        if (bundleWatcher != null) {
            bundleWatcher.watchBundle(this, 16);
        }
        this.state = 16;
        this.framework.publishBundleEvent(256, this);
        try {
            this.context.stop();
        }
        catch (Throwable throwable) {
            bundleWatcher = null;
            this.context.close();
            this.context = null;
            this.checkValid();
            this.state = 4;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("->stopped " + this);
            }
            this.framework.publishBundleEvent(4, this);
            BundleWatcher bundleWatcher2 = this.framework.adaptor.getBundleWatcher();
            if (bundleWatcher2 == null) throw throwable;
            bundleWatcher2.watchBundle(this, 32);
            throw throwable;
        }
        {
            bundleWatcher = null;
            this.context.close();
            this.context = null;
        }
        this.checkValid();
        this.state = 4;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->stopped " + this);
        }
        this.framework.publishBundleEvent(4, this);
        BundleWatcher bundleWatcher3 = this.framework.adaptor.getBundleWatcher();
        if (bundleWatcher3 == null) return;
        bundleWatcher3.watchBundle(this, 32);
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getServicesInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle[] getFragments() {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            block4: {
                if (this.fragments != null) break block4;
                return null;
            }
            Bundle[] bundleArray = new Bundle[this.fragments.length];
            System.arraycopy(this.fragments, 0, bundleArray, 0, bundleArray.length);
            return bundleArray;
        }
    }

    protected void attachFragment(BundleFragment bundleFragment) throws BundleException {
        BundleLoader bundleLoader = this.getLoaderProxy().getBasicBundleLoader();
        if (bundleLoader != null) {
            bundleLoader.attachFragment(bundleFragment);
        }
        if (this.fragments == null) {
            this.fragments = new BundleFragment[]{bundleFragment};
        } else {
            boolean bl = false;
            BundleFragment[] bundleFragmentArray = new BundleFragment[this.fragments.length + 1];
            int n = 0;
            while (n < this.fragments.length) {
                if (bundleFragment == this.fragments[n]) {
                    return;
                }
                if (!bl && bundleFragment.getBundleId() < this.fragments[n].getBundleId()) {
                    if (bundleLoader != null) {
                        throw new BundleException(NLS.bind(Msg.BUNDLE_LOADER_ATTACHMENT_ERROR, this.fragments[n].getSymbolicName(), this.getSymbolicName()));
                    }
                    bundleFragmentArray[n] = bundleFragment;
                    bl = true;
                }
                bundleFragmentArray[bl ? n + 1 : n] = this.fragments[n];
                ++n;
            }
            if (!bl) {
                bundleFragmentArray[bundleFragmentArray.length - 1] = bundleFragment;
            }
            this.fragments = bundleFragmentArray;
        }
    }

    protected BundleLoader getBundleLoader() {
        return this.getLoaderProxy().getBundleLoader();
    }

    protected synchronized BundleLoaderProxy getLoaderProxy() {
        if (this.proxy != null) {
            return this.proxy;
        }
        BundleDescription bundleDescription = this.getBundleDescription();
        this.proxy = new BundleLoaderProxy(this, bundleDescription);
        bundleDescription.setUserObject(this.proxy);
        return this.proxy;
    }

    static void closeBundleLoader(BundleLoaderProxy bundleLoaderProxy) {
        if (bundleLoaderProxy == null) {
            return;
        }
        BundleLoader bundleLoader = bundleLoaderProxy.getBasicBundleLoader();
        if (bundleLoader != null) {
            bundleLoader.close();
        }
        bundleLoaderProxy.setStale();
        BundleDescription bundleDescription = bundleLoaderProxy.getBundleDescription();
        bundleDescription.setUserObject(null);
    }
}

