/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class FilteredServiceListener
implements ServiceListener {
    protected FilterImpl filter;
    protected ServiceListener listener;
    protected BundleContextImpl context;
    protected boolean allservices = false;

    protected FilteredServiceListener(String string, ServiceListener serviceListener, BundleContextImpl bundleContextImpl) throws InvalidSyntaxException {
        if (string != null) {
            this.filter = new FilterImpl(string);
        }
        this.listener = serviceListener;
        this.context = bundleContextImpl;
        this.allservices = serviceListener instanceof AllServiceListener;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String string;
        if (!this.context.hasListenServicePermission(serviceEvent)) {
            return;
        }
        if (this.filter == null) {
            if (this.allservices || this.context.isAssignableTo((ServiceReferenceImpl)serviceEvent.getServiceReference())) {
                this.listener.serviceChanged(serviceEvent);
            }
            return;
        }
        ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)serviceEvent.getServiceReference();
        if (Debug.DEBUG_EVENTS) {
            string = String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
            Debug.println("filterServiceEvent(" + string + ", \"" + this.filter + "\", " + serviceReferenceImpl.registration.properties + ")");
        }
        if (this.filter.match(serviceReferenceImpl) && (this.allservices || this.context.isAssignableTo((ServiceReferenceImpl)serviceEvent.getServiceReference()))) {
            if (Debug.DEBUG_EVENTS) {
                string = String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(this.listener.hashCode());
                Debug.println("dispatchFilteredServiceEvent(" + string + ")");
            }
            this.listener.serviceChanged(serviceEvent);
        }
    }

    public String toString() {
        return this.filter == null ? this.listener.toString() : this.filter.toString();
    }
}

