/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.math.BigInteger;

public class BERProcessor {
    byte[] buffer;
    int offset;
    int lastOffset;
    int contentOffset;
    int contentLength;
    int endOffset;
    int classOfTag;
    static final int UNIVERSAL_TAGCLASS = 0;
    static final int APPLICATION_TAGCLASS = 1;
    static final int CONTEXTSPECIFIC_TAGCLASS = 2;
    static final int PRIVATE_TAGCLASS = 3;
    static final byte BOOLTAG = 1;
    static final byte INTTAG = 2;
    static final byte OIDTAG = 6;
    static final byte SEQTAG = 16;
    static final byte SETTAG = 17;
    static final byte NULLTAG = 5;
    static final String[] tagNames = new String[]{"<null>", "boolean", "int", "bitstring", "octetstring", "null", "objid", "objdesc", "external", "real", "enum", "pdv", "utf8", "relobjid", "resv", "resv", "sequence", "set", "char string"};
    public boolean constructed;
    public byte tag;

    public BERProcessor(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.offset = n;
        this.lastOffset = n2 + n;
        this.processStructure();
    }

    public void processStructure() {
        if (this.offset == -1) {
            return;
        }
        this.endOffset = this.offset;
        this.classOfTag = (this.buffer[this.offset] & 0xFF) >> 6;
        this.constructed = (this.buffer[this.offset] & 0x20) != 0;
        byte by = (byte)(this.buffer[this.offset] & 0x1F);
        if (by >= 32) {
            throw new IllegalArgumentException("Can't handle tags > 32");
        }
        this.tag = by;
        this.endOffset = this.offset + 1;
        if ((this.buffer[this.endOffset] & 0x80) == 0) {
            this.contentLength = this.buffer[this.endOffset];
            ++this.endOffset;
        } else {
            int n = this.buffer[this.endOffset] & 0x7F;
            if (n > 3) {
                throw new ArrayIndexOutOfBoundsException("ContentLength octet count too large: " + n);
            }
            this.contentLength = 0;
            ++this.endOffset;
            int n2 = 0;
            while (n2 < n) {
                this.contentLength <<= 8;
                this.contentLength |= this.buffer[this.endOffset] & 0xFF;
                ++this.endOffset;
                ++n2;
            }
            if (n == 0) {
                this.contentLength = -1;
            }
        }
        this.contentOffset = this.endOffset;
        if (this.contentLength != -1) {
            this.endOffset += this.contentLength;
        }
        if (this.endOffset > this.lastOffset) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(this.endOffset) + " > " + this.lastOffset);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.classOfTag) {
            case 0: {
                stringBuffer.append('U');
                break;
            }
            case 1: {
                stringBuffer.append('A');
                break;
            }
            case 2: {
                stringBuffer.append('C');
                break;
            }
            case 3: {
                stringBuffer.append('P');
            }
        }
        stringBuffer.append(this.constructed ? (char)'C' : 'P');
        stringBuffer.append(" tag=" + this.tag);
        if (this.tag < tagNames.length) {
            stringBuffer.append("(" + tagNames[this.tag] + ")");
        }
        stringBuffer.append(" len=");
        stringBuffer.append(this.contentLength);
        switch (this.tag) {
            case 2: {
                stringBuffer.append(" value=" + this.getIntValue());
                break;
            }
            case 6: {
                stringBuffer.append(" value=");
                int[] nArray = this.getObjId();
                int n = 0;
                while (n < nArray.length) {
                    if (n > 0) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(nArray[n]);
                    ++n;
                }
                break;
            }
        }
        if (this.tag == 12 || this.tag >= 18 && this.tag <= 22 || this.tag >= 25 && this.tag <= 30) {
            stringBuffer.append(" value=");
            stringBuffer.append(this.getString());
        }
        return stringBuffer.toString();
    }

    public BERProcessor stepInto() {
        return new BERProcessor(this.buffer, this.contentOffset, this.contentLength);
    }

    public void stepOver() {
        this.offset = this.endOffset;
        if (this.endOffset >= this.lastOffset) {
            this.offset = -1;
            return;
        }
        this.processStructure();
    }

    public boolean endOfSequence() {
        return this.offset == -1;
    }

    public String getString() {
        return new String(this.buffer, this.contentOffset, this.contentLength);
    }

    public BigInteger getIntValue() {
        return new BigInteger(this.getBytes());
    }

    public int[] getObjId() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.contentLength) {
            if ((this.buffer[this.contentOffset + n2] & 0x80) == 0) {
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[++n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.contentLength) {
            n4 <<= 7;
            n4 |= this.buffer[this.contentOffset + n5] & 0x7F;
            if ((this.buffer[this.contentOffset + n5] & 0x80) == 0) {
                if (n3 == 0) {
                    nArray[n3++] = n4 / 40;
                    nArray[n3++] = n4 % 40;
                } else {
                    nArray[n3++] = n4;
                }
                n4 = 0;
            }
            ++n5;
        }
        return nArray;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.contentLength];
        System.arraycopy(this.buffer, this.contentOffset, byArray, 0, this.contentLength);
        return byArray;
    }
}

