/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public final class Color {
    public int internal_handle;
    Device device;

    Color() {
    }

    public static Color internal_newFromHandle(Device device, int handle) {
        Color color = new Color();
        color.device = device;
        color.internal_handle = handle;
        return color;
    }

    public Color(Device device, int red, int green, int blue) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, red, green, blue);
    }

    public Color(Device device, RGB rgb) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(device, rgb.red, rgb.green, rgb.blue);
    }

    public void dispose() {
        if (this.internal_handle == 0) {
            return;
        }
        OS.Color_Dispose(this.internal_handle);
        this.internal_handle = 0;
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && this.getRed() == color.getRed() && this.getGreen() == color.getGreen() && this.getBlue() == color.getBlue();
    }

    public int getBlue() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return OS.Color_GetBlue(this.internal_handle);
    }

    public int getGreen() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return OS.Color_GetGreen(this.internal_handle);
    }

    public int getRed() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        return OS.Color_GetRed(this.internal_handle);
    }

    public RGB getRGB() {
        if (this.internal_handle == 0) {
            SWT.error(44);
        }
        int red = OS.Color_GetRed(this.internal_handle);
        int green = OS.Color_GetGreen(this.internal_handle);
        int blue = OS.Color_GetBlue(this.internal_handle);
        return new RGB(red, green, blue);
    }

    public int hashCode() {
        if (this.internal_handle == 0) {
            return 0;
        }
        int red = OS.Color_GetRed(this.internal_handle);
        int green = OS.Color_GetGreen(this.internal_handle);
        int blue = OS.Color_GetBlue(this.internal_handle);
        return red ^ green ^ blue;
    }

    void init(Device device, int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        this.internal_handle = OS.Color_New(device.internal_handle, red, green, blue);
    }

    public boolean isDisposed() {
        return this.internal_handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

