/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    public static final int LIMIT = OS.Combo_GetDefaultTextLimit();
    private Vector items;
    private int textLimit = LIMIT;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
        this.items = new Vector();
        if ((style & 8) != 0) {
            this.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (event.keyCode == 13) {
                        Combo.this.internal_sendEvent(14);
                    }
                }
            });
        }
    }

    protected void internal_createHandle(int index) {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 8) != 0) {
            nativeStyle |= 0x1000000;
        }
        if ((this.internal_style & 4) != 0) {
            nativeStyle |= 0x4000000;
        }
        this.internal_handle = OS.Combo_New(this.internal_parent.internal_handle, nativeStyle);
    }

    void createScrollBars() {
        this.horizontalBar = null;
        this.verticalBar = null;
    }

    boolean isTrueComposite() {
        return false;
    }

    Control[] _getChildren() {
        return new Control[0];
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        style = Combo.checkBits(style, 4, 0, 0, 0, 0, 0);
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Combo.error(43);
        }
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        }
        if (index < 0 || index > this.items.size()) {
            Combo.error(6);
        }
        this.items.insertElementAt(string, index);
        OS.Choice_AddItem(this.internal_handle, string, index);
    }

    public void add(String string) {
        this.add(string, this.items.size());
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void clearSelection() {
        this.checkWidget();
        OS.Combo_SetTextSelection(this.internal_handle, 0, 0);
    }

    Point minimumSize() {
        int width = 0;
        int height = 0;
        int[] pointArray = OS.Control_GetMinimumSize(this.internal_handle);
        width = pointArray[0];
        height = pointArray[1];
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        String text = OS.Combo_GetText(this.internal_handle);
        int[] sel = OS.Combo_GetTextSelection(this.internal_handle);
        String selText = text.substring(sel[0], sel[1]);
        if (selText.length() > 0) {
            OS.Clipboard_SetText(selText);
        }
    }

    public void cut() {
        this.checkWidget();
        int[] sel = OS.Combo_GetTextSelection(this.internal_handle);
        String text = OS.Combo_GetText(this.internal_handle);
        text = text.substring(sel[0], sel[1]);
        if (text.equals("")) {
            return;
        }
        String newText = "";
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText("", sel[0], sel[1], null)) == null) {
            return;
        }
        OS.Clipboard_SetText(text);
        OS.Combo_ReplaceText(this.internal_handle, newText, sel[0], sel[1]);
        OS.Combo_SetTextSelection(this.internal_handle, sel[0], sel[0]);
        this.internal_sendEvent(24);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        OS.Combo_DeselectItem(this.internal_handle, index);
    }

    public void deselectAll() {
        this.checkWidget();
        OS.Combo_DeselectAllItems(this.internal_handle);
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            Combo.error(6);
        }
        return (String)this.items.elementAt(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public int getItemHeight() {
        this.checkWidget();
        return OS.Combo_GetItemHeight(this.internal_handle);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.internal_style & 0x6000000;
    }

    public String[] getItems() {
        this.checkWidget();
        String[] array = new String[this.items.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)this.items.elementAt(i);
        }
        return array;
    }

    public Point getSelection() {
        this.checkWidget();
        int[] selection = OS.Combo_GetTextSelection(this.internal_handle);
        return new Point(selection[0], selection[1]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.Choice_GetSelectedItemIndex(this.internal_handle);
    }

    public String getText() {
        this.checkWidget();
        return OS.Combo_GetText(this.internal_handle);
    }

    public int getTextHeight() {
        this.checkWidget();
        return OS.Combo_GetTextHeight(this.internal_handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int index = -1;
        int itemCount = this.items.size();
        if (start < 0 || start >= itemCount) {
            return -1;
        }
        for (int i = start; i < itemCount; ++i) {
            String item = (String)this.items.elementAt(i);
            if (!string.equals(item)) continue;
            index = i;
            break;
        }
        return index;
    }

    public void paste() {
        this.checkWidget();
        String text = OS.Clipboard_GetText();
        if (text == null) {
            return;
        }
        String str = text;
        int[] selection = OS.Combo_GetTextSelection(this.internal_handle);
        OS.Combo_ReplaceText(this.internal_handle, str, selection[0], selection[1]);
        int start = selection[0] + str.length();
        OS.Combo_SetTextSelection(this.internal_handle, start, start);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int itemCount = this.items.size();
        if (start < 0 || start >= itemCount) {
            Combo.error(6);
        }
        if (end < 0 || end >= itemCount) {
            Combo.error(6);
        }
        for (int i = end; i >= start; --i) {
            this.items.removeElementAt(i);
            OS.Choice_RemoveItem(this.internal_handle, i);
        }
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            Combo.error(6);
        }
        this.doRemove(index);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int index = -1;
        int itemCount = this.items.size();
        for (int i = 0; i < itemCount; ++i) {
            String text = (String)this.items.elementAt(i);
            if (!string.equals(text)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            Combo.error(5);
        }
        this.doRemove(index);
    }

    private void doRemove(int index) {
        this.items.removeElementAt(index);
        OS.Choice_RemoveItem(this.internal_handle, index);
    }

    public void removeAll() {
        this.checkWidget();
        this.items.removeAllElements();
        OS.Choice_RemoveAllItems(this.internal_handle);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener == null) {
            Combo.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        OS.Choice_SelectItem(this.internal_handle, index);
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        }
        if (index < 0 || index >= this.items.size()) {
            Combo.error(6);
        }
        this.doSetItem(index, string);
    }

    private void doSetItem(int index, String string) {
        this.items.setElementAt(string, index);
        OS.Combo_SetItem(this.internal_handle, string, index);
    }

    public void setItems(String[] newItems) {
        this.checkWidget();
        if (newItems == null) {
            Combo.error(4);
        }
        this.items.removeAllElements();
        OS.Choice_RemoveAllItems(this.internal_handle);
        for (int i = 0; i < newItems.length; ++i) {
            this.items.addElement(newItems[i]);
            OS.Choice_AddItem(this.internal_handle, newItems[i], i);
        }
    }

    public void setOrientation(int orientation) {
        int flags = 0x6000000;
        if ((orientation & flags) == 0 || (orientation & flags) == flags) {
            return;
        }
        int nativeOrientation = 16384;
        if (orientation == 0x4000000) {
            nativeOrientation = 32768;
        }
        OS.Combo_SetOrientation(this.internal_handle, nativeOrientation);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            Combo.error(4);
        }
        OS.Combo_SetTextSelection(this.internal_handle, selection.x, selection.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        } else if (string.equals("") && string.equals(this.getText())) {
            return;
        }
        if ((this.internal_style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
            return;
        }
        String text = OS.Combo_GetText(this.internal_handle);
        String newText = "";
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(string, 0, text.length(), null)) == null) {
            return;
        }
        OS.Combo_SetText(this.internal_handle, string);
        this.internal_sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            Combo.error(7);
        }
        if (limit < 0) {
            return;
        }
        this.textLimit = limit;
        OS.Combo_SetTextLimit(this.internal_handle, limit);
    }

    void textChanged() {
        this.internal_sendEvent(24);
    }

    void activated(int index) {
        this.postEvent(13);
    }

    public int getVisibleItemCount() {
        return OS.Combo_GetVisibleItemCount(this.internal_handle);
    }

    public void setVisibleItemCount(int count) {
        OS.Combo_SetVisibleItemCount(this.internal_handle, count);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle r = this.getBounds();
        r.x = 0;
        r.y = 0;
        return r;
    }

    void choiceCallback(int index) {
        this.internal_sendEvent(13);
    }

    void comboCallback(int type) {
        switch (type) {
            case 1: {
                this.internal_sendEvent(24);
                break;
            }
            case 2: {
                this.internal_sendEvent(14);
            }
        }
    }

    public Control[] getChildren() {
        return null;
    }

    public Layout getLayout() {
        return null;
    }

    public Control[] getTabList() {
        return null;
    }

    public void layout() {
    }

    public void layout(boolean changed) {
    }

    public void setLayout(Layout layout) {
    }

    public void setTabList(Control[] tabList) {
    }

    public boolean allowTraverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000001: {
                if (this.getSelectionIndex() > 0) break;
                return true;
            }
            case 0x1000003: {
                if (super.isEnableTraverse()) {
                    return true;
                }
                if ((this.internal_style & 8) == 0) break;
                return true;
            }
            case 0x1000002: {
                if (this.getSelectionIndex() < this.getItemCount() - 1) break;
                return true;
            }
            case 0x1000004: {
                if (super.isEnableTraverse()) {
                    return true;
                }
                if ((this.internal_style & 8) == 0) break;
                return true;
            }
        }
        return false;
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }
}

