/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;

public class URLTool {
    public static URL appendTrailingSlash(URL uRL) {
        String string = uRL.getFile();
        if (string.endsWith("/")) {
            return uRL;
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(string) + "/");
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue((boolean)false, (String)"internal error");
            return null;
        }
    }

    public static URL getChild(URL uRL, String string) {
        String string2 = uRL.getFile();
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(string2) + string);
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue((boolean)false, (String)"internal error");
            return null;
        }
    }

    public static Vector getElements(URL uRL) {
        Vector<String> vector = new Vector<String>(5);
        String string = null;
        while ((string = URLTool.getLastElement(uRL)) != null) {
            vector.insertElementAt(string, 0);
            uRL = URLTool.getParent(uRL);
        }
        return vector;
    }

    public static String getLastElement(URL uRL) {
        String string = uRL.getFile();
        int n = string.length();
        if (n == 0 || n == 1 && string.charAt(0) == '/') {
            return null;
        }
        int n2 = -1;
        int n3 = n - 2;
        while (n2 == -1 && n3 >= 0) {
            if (string.charAt(n3) == '/') {
                n2 = n3;
            }
            --n3;
        }
        int n4 = n3 = string.charAt(n - 1) == '/' ? 1 : 0;
        if (n2 == -1) {
            if (n3 != 0) {
                return string.substring(0, n - 1);
            }
            return string;
        }
        if (n3 != 0) {
            return string.substring(n2 + 1, n - 1);
        }
        return string.substring(n2 + 1, n);
    }

    public static URL getParent(URL uRL) {
        String string = uRL.getFile();
        int n = string.length();
        if (n == 0 || n == 1 && string.charAt(0) == '/') {
            return null;
        }
        int n2 = -1;
        int n3 = n - 2;
        while (n2 == -1 && n3 >= 0) {
            if (string.charAt(n3) == '/') {
                n2 = n3;
            }
            --n3;
        }
        string = n2 == -1 ? "" : string.substring(0, n2 + 1);
        try {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue((boolean)false, (String)malformedURLException.getMessage());
        }
        return uRL;
    }

    public static URL getRoot(String string) throws MalformedURLException {
        return URLTool.getRoot(new URL(string));
    }

    public static URL getRoot(URL uRL) {
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {
            Assert.isTrue((boolean)false, (String)"internal error");
            return null;
        }
    }

    public static URL removeTrailingSlash(URL uRL) {
        String string = uRL.getFile();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
            try {
                return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            }
            catch (MalformedURLException malformedURLException) {
                Assert.isTrue((boolean)false, (String)malformedURLException.getMessage());
            }
        } else {
            return uRL;
        }
        return null;
    }

    public static boolean urlsOverlap(URL uRL, URL uRL2) {
        if (!URLTool.getRoot(uRL).equals(URLTool.getRoot(uRL2))) {
            return false;
        }
        Vector vector = URLTool.getElements(uRL);
        Vector vector2 = URLTool.getElements(uRL2);
        int n = 0;
        while (n < vector.size() && n < vector2.size()) {
            String string;
            String string2 = (String)vector.elementAt(n);
            if (!string2.equals(string = (String)vector2.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

