/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ExtensionEventHandlerMessages;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.ShowMessage;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

class ExtensionEventHandler
implements IRegistryChangeListener {
    private static final String TAG_CATEGORY = "category";
    private static final String ATT_TARGET_ID = "targetID";
    private static final String TAG_PART = "part";
    private static final String ATT_ID = "id";
    private static final String TAG_PROVIDER = "imageprovider";
    private static final String TAG_ACTION_SET_PART_ASSOCIATION = "actionSetPartAssociation";
    private Workbench workbench;
    private List changeList = new ArrayList(10);

    public ExtensionEventHandler(Workbench workbench) {
        this.workbench = workbench;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        try {
            Display display;
            IExtensionDelta[] iExtensionDeltaArray;
            block20: {
                block19: {
                    IWorkbenchWindow[] iWorkbenchWindowArray;
                    block18: {
                        iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas(WorkbenchPlugin.PI_WORKBENCH);
                        iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                        if (iWorkbenchWindowArray.length != 0) break block18;
                        break block19;
                    }
                    display = iWorkbenchWindowArray[0].getShell().getDisplay();
                    if (display != null) break block20;
                }
                Object var14_4 = null;
                this.changeList.clear();
                return;
            }
            ArrayList<IExtensionDelta> arrayList = new ArrayList<IExtensionDelta>(5);
            ArrayList<IExtensionDelta> arrayList2 = new ArrayList<IExtensionDelta>(5);
            String string = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < iExtensionDeltaArray.length) {
                block22: {
                    block21: {
                        string = iExtensionDeltaArray[n3].getExtensionPoint().getSimpleIdentifier();
                        if (iExtensionDeltaArray[n3].getKind() != 1) break block21;
                        if (string.equals("actionSets")) {
                            arrayList.add(0, iExtensionDeltaArray[n3]);
                            break block22;
                        } else if (!(string.equals("perspectives") || string.equals("views") || string.equals("actionSets"))) {
                            arrayList.add(arrayList.size() - n, iExtensionDeltaArray[n3]);
                        }
                        break block22;
                    }
                    if (iExtensionDeltaArray[n3].getKind() == 2) {
                        if (string.equals("actionSetPartAssociations")) {
                            arrayList2.add(0, iExtensionDeltaArray[n3]);
                            ++n2;
                        } else if (string.equals("perspectives")) {
                            arrayList2.add(n2, iExtensionDeltaArray[n3]);
                        } else {
                            arrayList2.add(iExtensionDeltaArray[n3]);
                        }
                    }
                }
                ++n3;
            }
            Iterator iterator = arrayList.iterator();
            IExtensionDelta iExtensionDelta = null;
            while (iterator.hasNext()) {
                iExtensionDelta = (IExtensionDelta)iterator.next();
                IExtensionPoint iExtensionPoint = iExtensionDelta.getExtensionPoint();
                IExtension iExtension = iExtensionDelta.getExtension();
                this.asyncAppear(display, iExtensionPoint, iExtension);
            }
            this.resetCurrentPerspective(display);
            Object var14_6 = null;
            this.changeList.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var14_5 = null;
            this.changeList.clear();
            throw throwable;
        }
    }

    private void asyncAppear(Display display, final IExtensionPoint iExtensionPoint, final IExtension iExtension) {
        Runnable runnable = new Runnable(){

            public void run() {
                ExtensionEventHandler.this.appear(iExtensionPoint, iExtension);
            }
        };
        display.syncExec(runnable);
    }

    private void asyncRevoke(Display display, final IExtensionPoint iExtensionPoint, final IExtension iExtension) {
        Runnable runnable = new Runnable(){

            public void run() {
                ExtensionEventHandler.this.revoke(iExtensionPoint, iExtension);
            }
        };
        display.syncExec(runnable);
    }

    private void appear(IExtensionPoint iExtensionPoint, IExtension iExtension) {
    }

    private void revoke(IExtensionPoint iExtensionPoint, IExtension iExtension) {
        String string = iExtensionPoint.getSimpleIdentifier();
        if (string.equalsIgnoreCase("views")) {
            this.unloadView(iExtension);
            return;
        }
        if (string.equalsIgnoreCase("perspectives")) {
            this.unloadPerspective(iExtension);
            return;
        }
    }

    private void restoreViewState(MultiStatus multiStatus, String string) {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
            IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IMemento iMemento = (IMemento)((WorkbenchPage)iWorkbenchPageArray[n2]).getStateMap().remove(string);
                if (iMemento != null) {
                    IMemento[] iMementoArray = iMemento.getChildren("view");
                    ViewFactory viewFactory = ((WorkbenchPage)iWorkbenchPageArray[n2]).getViewFactory();
                    int n3 = 0;
                    while (n3 < iMementoArray.length) {
                        viewFactory.restoreViewState(iMementoArray[n3]);
                        this.createOpenPerspectiveView(iWorkbenchPageArray[n2], viewFactory, iMementoArray[n3]);
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void createOpenPerspectiveView(IWorkbenchPage iWorkbenchPage, ViewFactory viewFactory, IMemento iMemento) {
        String string = iMemento.getString(ATT_ID);
        String string2 = iMemento.getString("perspective");
        Perspective perspective = ((WorkbenchPage)iWorkbenchPage).getActivePerspective();
        if (perspective.getDesc().getId().equals(string2)) {
            try {
                viewFactory.createView(string);
                iWorkbenchPage.showView(string);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void unloadView(IExtension iExtension) {
    }

    private void saveViewState(IWorkbenchPage iWorkbenchPage, String string, IMemento iMemento) {
        Perspective perspective = ((WorkbenchPage)iWorkbenchPage).getActivePerspective();
        if (perspective.findView(string) != null) {
            iMemento.putString("perspective", perspective.getDesc().getId());
        }
    }

    private Object[] findShowViewIdsRemoved(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        Object[] objectArray = arrayList.toArray();
        Object[] objectArray2 = arrayList2.toArray();
        int n = 0;
        while (n < objectArray.length) {
            int n2 = 0;
            while (n2 < objectArray2.length) {
                if (((String)objectArray2[n2]).equals((String)objectArray[n])) {
                    arrayList3.add(objectArray2[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList3.toArray();
    }

    private boolean checkOpenable(IMemento iMemento, IWorkbenchPage iWorkbenchPage) {
        IMemento iMemento2 = iMemento.getChild("input");
        String string = null;
        if (iMemento2 != null) {
            string = iMemento2.getString("factoryID");
        }
        if (string == null) {
            return false;
        }
        IElementFactory iElementFactory = WorkbenchPlugin.getDefault().getElementFactory(string);
        if (iElementFactory == null) {
            return false;
        }
        iElementFactory.createElement(iMemento2);
        return false;
    }

    private void unloadPerspective(IExtension iExtension) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.ViewFactory_problemsSavingViews, null);
        IPerspectiveRegistry iPerspectiveRegistry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IPerspectiveDescriptor iPerspectiveDescriptor;
            String string;
            if (iConfigurationElementArray[n].getName().equals("perspective") && (string = iConfigurationElementArray[n].getAttribute(ATT_ID)) != null && (iPerspectiveDescriptor = iPerspectiveRegistry.findPerspectiveWithId(string)) != null) {
                ((PerspectiveRegistry)iPerspectiveRegistry).deletePerspective(iPerspectiveDescriptor);
                IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
                int n2 = 0;
                while (n2 < iWorkbenchWindowArray.length) {
                    WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
                    int n3 = 0;
                    while (n3 < iWorkbenchPageArray.length) {
                        iWorkbenchPageArray[n3].closePerspective(iPerspectiveDescriptor, true, true);
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (multiStatus.getSeverity() != 0) {
            ShowMessage.printError(WorkbenchMessages.Workbench_problemsSavingMsg, (IStatus)multiStatus);
        }
    }

    private void restorePerspectiveState(MultiStatus multiStatus, String string) {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
            IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
            int n2 = iWorkbenchPageArray.length - 1;
            while (n2 >= 0) {
                IMemento iMemento = (IMemento)((WorkbenchPage)iWorkbenchPageArray[n2]).getStateMap().remove(string);
                if (iMemento != null) {
                    try {
                        Perspective perspective = new Perspective(null, (WorkbenchPage)iWorkbenchPageArray[n2]);
                        multiStatus.merge(perspective.restoreState(iMemento));
                        ((WorkbenchPage)iWorkbenchPageArray[n2]).addPerspective(perspective);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
                --n2;
            }
            ++n;
        }
    }

    private void resetCurrentPerspective(Display display) {
        if (this.changeList.isEmpty()) {
            return;
        }
        final StringBuffer stringBuffer = new StringBuffer(ExtensionEventHandlerMessages.ExtensionEventHandler_following_changes);
        Iterator iterator = this.changeList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append(ExtensionEventHandlerMessages.ExtensionEventHandler_need_to_reset);
        display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = null;
                IWorkbenchWindow iWorkbenchWindow = ExtensionEventHandler.this.workbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    if (ExtensionEventHandler.this.workbench.getWorkbenchWindowCount() == 0) {
                        return;
                    }
                    iWorkbenchWindow = ExtensionEventHandler.this.workbench.getWorkbenchWindows()[0];
                }
                if (ShowMessage.openQuestion(shell = iWorkbenchWindow.getShell(), ExtensionEventHandlerMessages.ExtensionEventHandler_reset_perspective, stringBuffer.toString())) {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    if (iWorkbenchPage == null) {
                        return;
                    }
                    iWorkbenchPage.resetPerspective();
                }
            }
        });
    }

    private void removeActionSet(WorkbenchPage workbenchPage, String string) {
    }

    private void stopView(IExtension iExtension) {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
            IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n3 = 0;
                while (n3 < iConfigurationElementArray.length) {
                    ViewFactory viewFactory;
                    IViewReference iViewReference;
                    String string;
                    if (iConfigurationElementArray[n3].getName().equals("view") && (string = iConfigurationElementArray[n3].getAttribute(ATT_ID)) != null && (iViewReference = (viewFactory = ((WorkbenchPage)iWorkbenchPageArray[n2]).getViewFactory()).getView(string)) != null) {
                        ((WorkbenchPage)iWorkbenchPageArray[n2]).hideView(iViewReference);
                        ((WorkbenchPage)iWorkbenchPageArray[n2]).getViewFactory().releaseView(iViewReference);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void stopPerspective(IExtension iExtension) {
        IPerspectiveRegistry iPerspectiveRegistry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IPerspectiveDescriptor iPerspectiveDescriptor;
            String string;
            if (iConfigurationElementArray[n].getName().equals("perspective") && (string = iConfigurationElementArray[n].getAttribute(ATT_ID)) != null && (iPerspectiveDescriptor = iPerspectiveRegistry.findPerspectiveWithId(string)) != null) {
                ((PerspectiveRegistry)iPerspectiveRegistry).deletePerspective(iPerspectiveDescriptor);
                IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
                int n2 = 0;
                while (n2 < iWorkbenchWindowArray.length) {
                    WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
                    int n3 = 0;
                    while (n3 < iWorkbenchPageArray.length) {
                        Perspective perspective = ((WorkbenchPage)iWorkbenchPageArray[n3]).findPerspective(iPerspectiveDescriptor);
                        if (perspective == null) {
                            return;
                        }
                        iWorkbenchPageArray[n3].closePerspective(iPerspectiveDescriptor, true, true);
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }
}

