/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;

public class EditBookmarkScreen
extends AbsScreen
implements ModifyListener {
    Text name;
    Text url;
    Button changeUrlButton;
    Vector bookmarks = new Vector();
    BookmarkSite selectedBookmark = null;

    public EditBookmarkScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(UIMessages.EditBookmark);
        CaptionedControl captionedControl = new CaptionedControl(this.screen, 0);
        this.name = new Text((Composite)captionedControl, 2048);
        this.name.addModifyListener((ModifyListener)this);
        captionedControl.setText(UIMessages.BookmarkName);
        captionedControl.setLayoutData((Object)new GridData(768));
        CaptionedControl captionedControl2 = new CaptionedControl(this.screen, 0);
        this.url = new Text((Composite)captionedControl2, 2048);
        captionedControl2.setText(UIMessages.BookmarkURL);
        captionedControl2.setLayoutData((Object)new GridData(768));
        this.changeUrlButton = new Button(this.screen, 8);
        this.changeUrlButton.setLayoutData((Object)new GridData(128));
        this.changeUrlButton.setText(UIMessages.ChangeURL);
        this.changeUrlButton.addSelectionListener((SelectionListener)this);
        this.fillSpace();
        this.separator();
        this.setButtons(1, 0, 4);
        this.screen.layout();
    }

    protected void refresh() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        if (this.view.currentName != null && this.view.bookmarkFile != null) {
            BookmarkUtil.load(this.view.bookmarkFile, this.bookmarks);
            int n = 0;
            while (n < this.bookmarks.size()) {
                this.selectedBookmark = (BookmarkSite)this.bookmarks.elementAt(n);
                if (this.view.currentName.equals(this.selectedBookmark.getName())) {
                    this.name.setText(this.selectedBookmark.getName());
                    this.url.setText(this.selectedBookmark.getURL().toString());
                    this.url.setEditable(!this.selectedBookmark.getLocal());
                    this.changeUrlButton.setVisible(this.selectedBookmark.getLocal());
                    break;
                }
                ++n;
            }
        }
    }

    protected void action() {
        this.name.setSelection(this.name.getCharCount());
        this.name.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, false);
        } else if (selectionEvent.widget == this.nextButton) {
            this.selectedBookmark.setName(this.name.getText());
            this.selectedBookmark.setURL(this.url.getText());
            BookmarkUtil.store(this.view.bookmarkFile, this.bookmarks);
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(1, true);
        } else if (selectionEvent.widget == this.changeUrlButton) {
            FileDialog fileDialog = new FileDialog(this.view.parent.getShell(), 0);
            fileDialog.setText(UIMessages.SelectSite);
            String[] stringArray = new String[]{"site.xml"};
            fileDialog.setFilterExtensions(stringArray);
            String[] stringArray2 = new String[]{UIMessages.SiteXMLfiles};
            fileDialog.setFilterNames(stringArray2);
            if (fileDialog.open() != null) {
                if ("win32".equals(Platform.getOS())) {
                    if ("x86".equals(Platform.getOSArch())) {
                        this.url.setText("file:///" + fileDialog.getFilterPath() + fileDialog.getFileName());
                    } else {
                        this.url.setText("file://" + fileDialog.getFilterPath() + fileDialog.getFileName());
                    }
                } else if ("unknown".equals(Platform.getOS())) {
                    this.url.setText("file:/" + fileDialog.getFilterPath() + "/" + fileDialog.getFileName());
                }
            }
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (!(this.name.getText().equals(this.view.currentName) || this.name.getText().length() != 0 && BookmarkUtil.searchByName(this.bookmarks, this.name.getText()) < 0)) {
            this.nextButton.setEnabled(false);
            return;
        }
        this.nextButton.setEnabled(true);
    }
}

