/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.util.FeatureWrap;

public class LicenseScreen
extends AbsScreen {
    SortedList featureList;
    Text licenseArea;
    Button acceptButton;
    Button noAcceptButton;
    Label acceptText;
    Label noAcceptText;
    Composite pane;
    Composite namePane;
    FormData fdFeatures;
    FormData fdLicense;
    FormData fdAcceptButton;
    FormData fdNoAcceptButton;

    public LicenseScreen(NormalView normalView) {
        super(normalView);
    }

    protected void createScreen() {
        this.init(null);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayout((Layout)new FormLayout());
        this.pane.setLayoutData((Object)new GridData(1808));
        this.featureList = new SortedList(this.pane, 2560);
        this.featureList.addSelectionListener((SelectionListener)this);
        this.licenseArea = new Text(this.pane, 2626);
        this.licenseArea.setEditable(false);
        this.acceptButton = new Button(this.pane, 80);
        this.acceptButton.setText(UIMessages.Accept);
        this.acceptButton.addSelectionListener((SelectionListener)this);
        this.noAcceptButton = new Button(this.pane, 80);
        this.noAcceptButton.setText(UIMessages.NoAccept);
        this.noAcceptButton.addSelectionListener((SelectionListener)this);
        this.setButtons(1, 2, 3);
        this.fdFeatures = new FormData();
        this.fdLicense = new FormData();
        this.fdAcceptButton = new FormData();
        this.fdNoAcceptButton = new FormData();
    }

    protected void refresh() {
        this.acceptButton.setSelection(false);
        this.noAcceptButton.setSelection(false);
        this.backButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.featureList.removeAll();
        this.licenseArea.setText("");
        FeatureWrap featureWrap = null;
        int n = 0;
        while (n < this.view.availableFeatures.size()) {
            featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
            if (featureWrap.isSelected()) {
                this.featureList.add(featureWrap.getShowedName());
                if (this.licenseArea.getText().length() < 1) {
                    this.featureList.select(featureWrap.getShowedName());
                    this.licenseArea.setText(featureWrap.getLicense());
                }
            }
            ++n;
        }
        n = 25;
        int n2 = 49;
        int n3 = 100 - n - n2;
        if (this.view.parent.getClientArea().width > this.view.parent.getClientArea().height) {
            this.fdFeatures.top = new FormAttachment(0, 0);
            this.fdFeatures.bottom = new FormAttachment(n + n2, -5);
            this.fdFeatures.left = new FormAttachment(0, 0);
            this.fdFeatures.right = new FormAttachment(50, -2);
            this.fdLicense.top = new FormAttachment(0, 0);
            this.fdLicense.bottom = new FormAttachment(n + n2, -5);
            this.fdLicense.left = new FormAttachment(50, 2);
            this.fdLicense.right = new FormAttachment(100, 0);
        } else {
            this.fdFeatures.top = new FormAttachment(0, 0);
            this.fdFeatures.bottom = new FormAttachment(n, 0);
            this.fdFeatures.left = new FormAttachment(0, 0);
            this.fdFeatures.right = new FormAttachment(100, 0);
            this.fdLicense.top = new FormAttachment(n, 5);
            this.fdLicense.bottom = new FormAttachment(n + n2, -5);
            this.fdLicense.left = new FormAttachment(0, 0);
            this.fdLicense.right = new FormAttachment(100, 0);
        }
        this.fdAcceptButton.top = new FormAttachment(100 - n3, 0);
        this.fdAcceptButton.bottom = new FormAttachment(100 - n3 / 2, 0);
        this.fdAcceptButton.left = new FormAttachment(0, 0);
        this.fdAcceptButton.right = new FormAttachment(100, 0);
        this.fdNoAcceptButton.top = new FormAttachment(100 - n3 / 2, 0);
        this.fdNoAcceptButton.bottom = new FormAttachment(100, 0);
        this.fdNoAcceptButton.left = new FormAttachment(0, 0);
        this.fdNoAcceptButton.right = new FormAttachment(100, 0);
        this.featureList.setLayoutData((Object)this.fdFeatures);
        this.licenseArea.setLayoutData((Object)this.fdLicense);
        this.acceptButton.setLayoutData((Object)this.fdAcceptButton);
        this.noAcceptButton.setLayoutData((Object)this.fdNoAcceptButton);
        this.screen.layout();
    }

    protected void action() {
        this.acceptButton.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String[] stringArray;
        if (selectionEvent.widget == this.featureList && (stringArray = this.featureList.getSelection()).length > 0) {
            int n = 0;
            while (n < this.view.availableFeatures.size()) {
                FeatureWrap featureWrap = (FeatureWrap)this.view.availableFeatures.elementAt(n);
                if (featureWrap.isSelected() && stringArray[0].equals(featureWrap.getShowedName())) {
                    this.licenseArea.setText(featureWrap.getLicense());
                }
                ++n;
            }
        }
        if (selectionEvent.widget == this.acceptButton) {
            this.nextButton.setEnabled(true);
        } else if (selectionEvent.widget == this.noAcceptButton) {
            this.nextButton.setEnabled(false);
        } else if (selectionEvent.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(2, false);
        } else if (selectionEvent.widget == this.cancelButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, false);
        } else if (selectionEvent.widget == this.nextButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(4, true);
        }
    }
}

