/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.preferences.Activator;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class PreferencesOSGiUtils {
    private ServiceTracker logTracker = null;
    private ServiceTracker initTracker = null;
    private ServiceTracker debugTracker = null;
    private ServiceTracker bundleTracker = null;
    private ServiceTracker configurationLocationTracker = null;
    private ServiceTracker instanceLocationTracker = null;
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    private static final PreferencesOSGiUtils singleton = new PreferencesOSGiUtils();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static PreferencesOSGiUtils getDefault() {
        return singleton;
    }

    private PreferencesOSGiUtils() {
    }

    void openServices() {
        BundleContext bundleContext = Activator.getContext();
        if (bundleContext == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("PreferencesOSGiUtils called before plugin started");
            }
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.preferences.exchange.ILegacyPreferences");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.initTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.initTracker.open(true);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logTracker = new ServiceTracker(bundleContext, clazz2.getName(), null);
        this.logTracker.open();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(bundleContext, clazz3.getName(), null);
        this.debugTracker.open();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundleTracker = new ServiceTracker(bundleContext, clazz4.getName(), null);
        this.bundleTracker.open();
        Filter filter = null;
        try {
            filter = bundleContext.createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocationTracker = new ServiceTracker(bundleContext, filter, null);
        this.configurationLocationTracker.open();
        try {
            filter = bundleContext.createFilter(Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocationTracker = new ServiceTracker(bundleContext, filter, null);
        this.instanceLocationTracker.open();
    }

    void closeServices() {
        if (this.initTracker != null) {
            this.initTracker.close();
            this.initTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.configurationLocationTracker != null) {
            this.configurationLocationTracker.close();
            this.configurationLocationTracker = null;
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
            this.instanceLocationTracker = null;
        }
    }

    public ILegacyPreferences getLegacyPreferences() {
        if (this.initTracker != null) {
            return (ILegacyPreferences)this.initTracker.getService();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Legacy preference tracker is not set");
        }
        return null;
    }

    public FrameworkLog getFrameworkLog() {
        if (this.logTracker != null) {
            return (FrameworkLog)this.logTracker.getService();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Log tracker is not set");
        }
        return null;
    }

    public boolean getBooleanDebugOption(String string, boolean bl) {
        String string2;
        if (this.debugTracker == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Debug tracker is not set");
            }
            return bl;
        }
        DebugOptions debugOptions = (DebugOptions)this.debugTracker.getService();
        if (debugOptions != null && (string2 = debugOptions.getOption(string)) != null) {
            return string2.equalsIgnoreCase("true");
        }
        return bl;
    }

    public Bundle getBundle(String string) {
        if (this.bundleTracker == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Bundle tracker is not set");
            }
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleTracker.getService();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundleArray = packageAdmin.getBundles(string, null);
        if (bundleArray == null) {
            return null;
        }
        int n = 0;
        while (n < bundleArray.length) {
            if ((bundleArray[n].getState() & 3) == 0) {
                return bundleArray[n];
            }
            ++n;
        }
        return null;
    }

    public Location getConfigurationLocation() {
        if (this.configurationLocationTracker != null) {
            return (Location)this.configurationLocationTracker.getService();
        }
        return null;
    }

    public Location getInstanceLocation() {
        if (this.instanceLocationTracker != null) {
            return (Location)this.instanceLocationTracker.getService();
        }
        return null;
    }
}

