/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class SearchCommand
extends ScriptedCommand {
    private URL remoteSiteURL;
    private UpdateSearchRequest searchRequest;
    private IUpdateSearchResultCollector collector;

    public SearchCommand(String string) {
        try {
            this.remoteSiteURL = new URL(UpdateURLDecoder.decode((String)string, (String)"UTF-8"));
            UpdateSearchScope updateSearchScope = new UpdateSearchScope();
            updateSearchScope.addSearchSite("remoteSite", this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), updateSearchScope);
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException malformedURLException) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(malformedURLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public boolean run(IProgressMonitor iProgressMonitor) {
        try {
            iProgressMonitor.beginTask(String.valueOf(Messages.Standalone_searching) + this.remoteSiteURL.toExternalForm(), 4);
            this.searchRequest.performSearch(this.collector, iProgressMonitor);
            Object var4_2 = null;
        }
        catch (CoreException coreException) {
            try {
                IStatus iStatus = coreException.getStatus();
                if (iStatus != null && iStatus.getCode() == 42) {
                    System.out.println(Messages.Standalone_connection);
                } else {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(coreException);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return false;
        }
        iProgressMonitor.done();
        return true;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        UpdateSearchResultCollector() {
        }

        public void accept(IFeature iFeature) {
            System.out.println("\"" + iFeature.getLabel() + "\" " + iFeature.getVersionedIdentifier().getIdentifier() + " " + iFeature.getVersionedIdentifier().getVersion());
        }
    }
}

