/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.MobileDevice;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.ercp.swt.mobile.Screen;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class MobileShell
extends Shell {
    public static final int NO_STATUS_PANE = 1;
    public static final int SMALL_STATUS_PANE = 2;
    public static final int LARGE_STATUS_PANE = 3;
    private Vector keyCodeVector = new Vector(10, 10);
    private boolean isFullScreen = false;
    private boolean isshowSIP = true;
    private boolean setAtInvisible = false;
    private String status = null;
    private Menu internalMenu = null;
    private int MENU_HEIGHT = 26;
    private Listener keyListener;

    protected boolean isValidSubclass() {
        return this.isValidClass(this.getClass());
    }

    boolean isValidClass(Class clazz) {
        int index;
        String name = clazz.getName();
        return name.substring(0, (index = name.lastIndexOf(46)) + 1).equals("org.eclipse.ercp.swt.mobile.");
    }

    public MobileShell(int style) {
        super(style);
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
        this.init();
    }

    public MobileShell(Display display) {
        super(display);
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
        this.init();
    }

    public MobileShell(Display display, int style) {
        super(display, style);
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
        this.init();
    }

    public MobileShell(Display display, int style, int statusStyle) {
        super(display, style);
        if (!this.isValidSubclass()) {
            SWT.error(43);
        }
        this.init();
    }

    public boolean getKeyState(int keyCode) {
        this.checkWidget();
        Display display = this.getDisplay();
        if (display.getActiveShell() != this) {
            return false;
        }
        Iterator keyCodeIterator = this.keyCodeVector.iterator();
        int index = 0;
        while (keyCodeIterator.hasNext()) {
            Integer keyCodeInteger = (Integer)keyCodeIterator.next();
            if (keyCodeInteger == keyCode) {
                this.keyCodeVector.remove(index);
                return true;
            }
            ++index;
        }
        return false;
    }

    public void setFullScreenMode(boolean fullScreenMode) {
        this.checkWidget();
        if (this.isFullScreen == fullScreenMode) {
            return;
        }
        this.isFullScreen = fullScreenMode;
        if (this.getDisplay().getActiveShell() != this) {
            this.setAtInvisible = true;
            return;
        }
        this.isshowSIP = true;
        this.doSetFullScreenMode(fullScreenMode, true);
    }

    public void setFullScreenMode(boolean fullScreenMode, boolean showVKBSelector) {
        this.checkWidget();
        if (this.isFullScreen == fullScreenMode) {
            return;
        }
        this.isFullScreen = fullScreenMode;
        if (this.getDisplay().getActiveShell() != this) {
            this.setAtInvisible = true;
            return;
        }
        this.isshowSIP = showVKBSelector;
        this.doSetFullScreenMode(fullScreenMode, showVKBSelector);
    }

    void doSetFullScreenMode(boolean mode, boolean showSIP) {
        Menu menu = this.getMenuBar();
        if (Platform.IDENTIFY_CODE == 4) {
            if (menu != null && this.internalMenu == null) {
                OS.MobileShell_SetFullScreenMode(this.internal_handle, menu.internal_handle, mode, menu.getItemCount() != 0, showSIP);
            } else {
                if (mode && this.internalMenu == null) {
                    this.internalMenu = new Menu(this, 2);
                    this.setMenuBar(this.internalMenu);
                }
                OS.MobileShell_SetFullScreenMode(this.internal_handle, this.internalMenu.internal_handle, mode, false, showSIP);
            }
        } else if (menu != null) {
            OS.MobileShell_SetFullScreenMode(this.internal_handle, menu.internal_handle, mode, menu.getItemCount() != 0, showSIP);
        } else {
            OS.MobileShell_SetFullScreenMode(this.internal_handle, 0, mode, false, showSIP);
        }
    }

    public void open() {
        super.open();
        if (this.setAtInvisible) {
            this.doSetFullScreenMode(this.isFullScreen, this.isshowSIP);
            this.setAtInvisible = false;
        }
        final MobileShell thisShell = this;
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (MobileShell.this.getFullScreenMode()) {
                    Screen[] screen = MobileDevice.getMobileDevice().getScreens();
                    if (thisShell.getSize().y < screen[0].getBounds().height - MobileShell.this.MENU_HEIGHT) {
                        MobileShell.this.doSetFullScreenMode(true, MobileShell.this.isshowSIP);
                    }
                }
            }
        });
    }

    public void changeTrim(int style, int statusStyle) {
        this.checkWidget();
        int validStatusStyle = -4;
        if ((statusStyle & validStatusStyle) != 0) {
            SWT.error(5);
        }
    }

    public boolean getFullScreenMode() {
        this.checkWidget();
        return this.isFullScreen;
    }

    public void setStatusText(String statusText) {
        this.checkWidget();
        this.status = statusText;
    }

    public void setMenuBar(Menu menu) {
        if (menu != this.internalMenu && this.internalMenu != null) {
            this.internalMenu.dispose();
            this.internalMenu = null;
        }
        super.setMenuBar(menu);
    }

    public String getStatusText() {
        this.checkWidget();
        return this.status;
    }

    public void dispose() {
        if (this.internalMenu != null && !this.internalMenu.isDisposed()) {
            this.internalMenu.dispose();
            this.internalMenu = null;
            this.setMenuBar(null);
        }
        super.dispose();
    }

    public void close() {
        this.setFullScreenMode(false);
        super.close();
    }

    private void init() {
        final Display display = this.getDisplay();
        final MobileShell mobileShell = this;
        this.keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (display.getActiveShell() == mobileShell) {
                    Iterator keyCodeIterator = MobileShell.this.keyCodeVector.iterator();
                    boolean hasEntry = false;
                    while (keyCodeIterator.hasNext()) {
                        Integer keyCode = (Integer)keyCodeIterator.next();
                        if (keyCode != event.keyCode) continue;
                        hasEntry = true;
                        break;
                    }
                    if (!hasEntry) {
                        Integer addKeycode = new Integer(event.keyCode);
                        MobileShell.this.keyCodeVector.add(addKeycode);
                    }
                }
            }
        };
        display.addFilter(1, this.keyListener);
    }
}

