/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.osgi.framework.BundleException;

public class BundleManifest
implements IConfigurationConstants {
    private File manifestFile;
    private PluginEntry pluginEntry;
    private IOException exception;
    private String bundleURL;

    /*
     * Exception decompiling
     */
    public BundleManifest(File var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 69->73)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BundleManifest(InputStream inputStream, String string) {
        this.bundleURL = string;
        if (inputStream != null) {
            this.parse(inputStream);
        }
    }

    private void parse(InputStream inputStream) {
        try {
            String string;
            Object object;
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            String string2 = attributes.getValue("Bundle-SymbolicName");
            if (string2 == null) {
                return;
            }
            try {
                object = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)string2);
                string = object[0].getValue();
            }
            catch (BundleException bundleException) {
                throw new IOException(bundleException.getMessage());
            }
            object = attributes.getValue("Bundle-Version");
            if (object == null) {
                Utils.log(NLS.bind((String)Messages.BundleManifest_noVersion, (Object[])new String[]{"Bundle-Version", string}));
                return;
            }
            String string3 = attributes.getValue("Fragment-Host");
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(string, (String)object));
            this.pluginEntry.isFragment(string3 != null && string3.length() > 0);
            if (this.bundleURL != null) {
                this.pluginEntry.setURL(this.bundleURL);
            } else {
                File file = this.manifestFile.getParentFile();
                if (file != null) {
                    file = file.getParentFile();
                }
                if (file != null) {
                    this.pluginEntry.setURL("plugins/" + file.getName() + "/");
                }
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public boolean exists() {
        return this.exception != null || this.pluginEntry != null;
    }

    public PluginEntry getPluginEntry() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.pluginEntry;
    }
}

