/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private BundleContext context;
    static /* synthetic */ Class class$0;

    public EclipseCommandProvider(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    public String getHelp() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("---");
        stringBuffer.append(EclipseAdaptorMsg.ECLIPSE_CONSOLE_COMMANDS_HEADER);
        stringBuffer.append("---");
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tdiag - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_DIAG_COMMAND_DESCRIPTION);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tactive - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_ACTIVE_COMMAND_DESCRIPTION);
        stringBuffer.append(EclipseAdaptorMsg.NEW_LINE);
        stringBuffer.append("\tgetprop " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_GETPROP_COMMAND_DESCRIPTION);
        return stringBuffer.toString();
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String string) {
        try {
            long l = Long.parseLong(string);
            return state.getBundle(l);
        }
        catch (NumberFormatException numberFormatException) {
            BundleDescription[] bundleDescriptionArray = state.getBundles(string);
            if (bundleDescriptionArray.length > 0) {
                return bundleDescriptionArray[0];
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _diag(CommandInterpreter commandInterpreter) throws Exception {
        ServiceReference serviceReference;
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((serviceReference = this.context.getServiceReference(clazz.getName())) == null) {
            commandInterpreter.print("  ");
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(serviceReference);
            if (platformAdmin == null) {
                Object var10_5 = null;
                this.context.ungetService(serviceReference);
                return;
            }
            State state = platformAdmin.getState(false);
            block5: while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                commandInterpreter.println(String.valueOf(bundleDescription.getLocation()) + " [" + bundleDescription.getBundleId() + "]");
                VersionConstraint[] versionConstraintArray = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundleDescription);
                if (versionConstraintArray.length == 0) {
                    ResolverError[] resolverErrorArray = platformAdmin.getState(false).getResolverErrors(bundleDescription);
                    if (!bundleDescription.isResolved() && resolverErrorArray.length > 0) {
                        int n = 0;
                        while (n < resolverErrorArray.length) {
                            commandInterpreter.print("  ");
                            commandInterpreter.println(resolverErrorArray[n].toString());
                            ++n;
                        }
                    } else {
                        commandInterpreter.print("  ");
                        commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS);
                    }
                }
                int n = 0;
                while (true) {
                    if (n >= versionConstraintArray.length) {
                        string = commandInterpreter.nextArgument();
                        continue block5;
                    }
                    commandInterpreter.print("  ");
                    commandInterpreter.println(EclipseAdaptorMsg.getResolutionFailureMessage(versionConstraintArray[n]));
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        Object var10_7 = null;
        this.context.ungetService(serviceReference);
    }

    public void _active(CommandInterpreter commandInterpreter) throws Exception {
        Bundle[] bundleArray = this.context.getBundles();
        int n = 0;
        int n2 = 0;
        while (n2 < bundleArray.length) {
            if (bundleArray[n2].getState() == 32) {
                commandInterpreter.println(bundleArray[n2]);
                ++n;
            }
            ++n2;
        }
        commandInterpreter.print("  ");
        commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_BUNDLES_ACTIVE, String.valueOf(n)));
    }

    public void _getprop(CommandInterpreter commandInterpreter) throws Exception {
        Properties properties = FrameworkProperties.getProperties();
        String string = commandInterpreter.nextArgument();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string != null && !string2.startsWith(string)) continue;
            commandInterpreter.println(String.valueOf(string2) + '=' + properties.getProperty(string2));
        }
    }
}

