/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.IBuddyPolicy;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class DependentPolicy
implements IBuddyPolicy {
    BundleLoader buddyRequester;
    int lastDependentOfAdded = -1;
    List allDependents = null;

    public DependentPolicy(BundleLoader bundleLoader) {
        this.buddyRequester = bundleLoader;
        this.allDependents = new ArrayList();
        this.basicAddImmediateDependents(this.buddyRequester.getBundle().getBundleDescription());
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    public Class loadClass(String string) {
        if (this.allDependents == null) {
            return null;
        }
        Class clazz = null;
        int n = 0;
        while (n < this.allDependents.size() && clazz == null) {
            block5: {
                BundleDescription bundleDescription = (BundleDescription)this.allDependents.get(n);
                try {
                    BundleLoaderProxy bundleLoaderProxy = this.buddyRequester.getLoaderProxy(bundleDescription);
                    if (bundleLoaderProxy != null) {
                        clazz = bundleLoaderProxy.getBundleLoader().findClass(string, true);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (clazz != null) break block5;
                    this.addDependent(n, bundleDescription);
                }
            }
            ++n;
        }
        return clazz;
    }

    private synchronized void addDependent(int n, BundleDescription bundleDescription) {
        if (n > this.lastDependentOfAdded) {
            this.lastDependentOfAdded = n;
            this.basicAddImmediateDependents(bundleDescription);
        }
    }

    public URL loadResource(String string) {
        if (this.allDependents == null) {
            return null;
        }
        URL uRL = null;
        int n = 0;
        while (n < this.allDependents.size() && uRL == null) {
            BundleDescription bundleDescription = (BundleDescription)this.allDependents.get(n);
            BundleLoaderProxy bundleLoaderProxy = this.buddyRequester.getLoaderProxy(bundleDescription);
            if (bundleLoaderProxy != null && (uRL = bundleLoaderProxy.getBundleLoader().findResource(string, true)) == null) {
                this.addDependent(n, bundleDescription);
            }
            ++n;
        }
        return uRL;
    }

    public Enumeration loadResources(String string) {
        if (this.allDependents == null) {
            return null;
        }
        Vector vector = null;
        int n = 0;
        while (n < this.allDependents.size()) {
            BundleDescription bundleDescription = (BundleDescription)this.allDependents.get(n);
            try {
                BundleLoaderProxy bundleLoaderProxy = this.buddyRequester.getLoaderProxy(bundleDescription);
                if (bundleLoaderProxy != null) {
                    Enumeration enumeration = bundleLoaderProxy.getBundleLoader().findResources(string);
                    if (enumeration != null) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            if (vector.contains(e)) continue;
                            vector.add(e);
                        }
                    }
                    this.addDependent(n, bundleDescription);
                }
            }
            catch (IOException iOException) {}
            ++n;
        }
        return vector == null ? null : vector.elements();
    }

    private void basicAddImmediateDependents(BundleDescription bundleDescription) {
        BundleDescription[] bundleDescriptionArray = bundleDescription.getDependents();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            BundleDescription bundleDescription2 = bundleDescriptionArray[n];
            if (bundleDescription2.getHost() == null && !this.allDependents.contains(bundleDescription2)) {
                this.allDependents.add(bundleDescription2);
            }
            ++n;
        }
    }
}

