/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class MessageResourceBundle {
    private static FrameworkAdaptor adaptor;
    static final Object ASSIGNED;
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static int SEVERITY_ERROR;
    static int SEVERITY_WARNING;

    static {
        ASSIGNED = new Object();
        SEVERITY_ERROR = 4;
        SEVERITY_WARNING = 2;
    }

    private static String[] buildVariants(String string) {
        Object object;
        if (nlSuffixes == null) {
            object = Locale.getDefault().toString();
            ArrayList<String> arrayList = new ArrayList<String>(4);
            while (true) {
                arrayList.add(String.valueOf('_') + (String)object + EXTENSION);
                int n = object.lastIndexOf(95);
                if (n == -1) break;
                object = object.substring(0, n);
            }
            arrayList.add(EXTENSION);
            nlSuffixes = arrayList.toArray(new String[arrayList.size()]);
        }
        string = string.replace('.', '/');
        object = new String[nlSuffixes.length];
        int n = 0;
        while (n < ((String[])object).length) {
            object[n] = String.valueOf(string) + nlSuffixes[n];
            ++n;
        }
        return object;
    }

    static void makeAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static void computeMissingMessages(String string, Class clazz, Map map, Field[] fieldArray, boolean bl) {
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 0x19) == 9 && map.get(field.getName()) != ASSIGNED) {
                try {
                    String string2 = "NLS missing message: " + field.getName() + " in: " + string;
                    if (Debug.DEBUG_MESSAGE_BUNDLES) {
                        System.out.println(string2);
                    }
                    MessageResourceBundle.log(SEVERITY_WARNING, string2, null);
                    if (!bl) {
                        MessageResourceBundle.makeAccessible(field);
                    }
                    field.set(null, string2);
                }
                catch (Exception exception) {
                    MessageResourceBundle.log(SEVERITY_ERROR, "Error setting the missing message value for: " + field.getName(), exception);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String string, Class clazz) {
        long l = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader classLoader = clazz.getClassLoader();
        boolean bl = (clazz.getModifiers() & 1) != 0;
        int n = fieldArray.length;
        HashMap<String, Field> hashMap = new HashMap<String, Field>(n * 2);
        int n2 = 0;
        while (true) {
            if (n2 >= n) break;
            hashMap.put(fieldArray[n2].getName(), fieldArray[n2]);
            ++n2;
        }
        String[] stringArray = MessageResourceBundle.buildVariants(string);
        int n3 = 0;
        while (true) {
            block12: {
                InputStream inputStream;
                if (n3 >= stringArray.length) {
                    MessageResourceBundle.computeMissingMessages(string, clazz, hashMap, fieldArray, bl);
                    if (!Debug.DEBUG_MESSAGE_BUNDLES) return;
                    System.out.println("Time to load message bundle: " + string + " was " + (System.currentTimeMillis() - l) + "ms.");
                    return;
                }
                InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(stringArray[n3]) : classLoader.getResourceAsStream(stringArray[n3]);
                if (inputStream != null) {
                    Object var13_14;
                    try {
                        try {
                            MessagesProperties messagesProperties = new MessagesProperties(hashMap, string, bl);
                            messagesProperties.load(inputStream);
                        }
                        catch (IOException iOException) {
                            MessageResourceBundle.log(SEVERITY_ERROR, "Error loading " + stringArray[n3], iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        var13_14 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var13_14 = null;
                        if (inputStream == null) break block12;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                }
            }
            ++n3;
        }
    }

    static void log(int n, String string, Exception exception) {
        if (adaptor != null) {
            adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi " + n + ' ' + 1, string, 0, exception, null));
        } else {
            System.out.println(string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    static void setAdaptor(FrameworkAdaptor frameworkAdaptor) {
        adaptor = frameworkAdaptor;
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map fields;
        private final boolean isAccessible;

        public MessagesProperties(Map map, String string, boolean bl) {
            this.fields = map;
            this.bundleName = string;
            this.isAccessible = bl;
        }

        public synchronized Object put(Object object, Object object2) {
            Object object3 = this.fields.put(object, ASSIGNED);
            if (object3 == ASSIGNED) {
                return null;
            }
            if (object3 == null) {
                String string = "NLS unused message: " + object + " in: " + this.bundleName;
                if (Debug.DEBUG_MESSAGE_BUNDLES) {
                    System.out.println(string);
                }
                MessageResourceBundle.log(SEVERITY_WARNING, string, null);
                return null;
            }
            Field field = (Field)object3;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    MessageResourceBundle.makeAccessible(field);
                }
                field.set(null, object2);
            }
            catch (Exception exception) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Exception setting field value.", exception);
            }
            return null;
        }
    }
}

