/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.eclipse.osgi.internal.provisional.verifier.CertificateTrustAuthority;
import org.eclipse.osgi.internal.verifier.JarVerifierMessages;
import org.eclipse.osgi.internal.verifier.KeyStores;
import org.eclipse.osgi.util.NLS;

public class DefaultTrustAuthority
implements CertificateTrustAuthority {
    private KeyStores keyStores;
    private int supportFlags;

    public DefaultTrustAuthority(int n) {
        this.supportFlags = n;
    }

    public void checkTrust(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException(JarVerifierMessages.Cert_Verifier_Illegal_Args);
        }
        KeyStores keyStores = this.getKeyStores();
        if (keyStores != null && !keyStores.isTrusted(certificateArray[certificateArray.length - 1])) {
            throw new CertificateException(NLS.bind(JarVerifierMessages.Cert_Verifier_Not_Trusted, new String[]{certificateArray[0].toString()}));
        }
    }

    private synchronized KeyStores getKeyStores() {
        if ((this.supportFlags & 2) == 0 || this.keyStores != null) {
            return this.keyStores;
        }
        this.keyStores = new KeyStores();
        return this.keyStores;
    }

    public void addTrusted(Certificate[] certificateArray) throws CertificateException {
    }
}

