/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class TextProcessor {
    private static final String DOT = ".";
    private static final String COLON = ":";
    private static final String FILE_SEP_FSLASH = "/";
    private static final String FILE_SEP_BSLASH = "\\";
    private static final String delimiterString = ".:/\\";
    private static final char LRM = '\u200e';
    private static final char LRE = '\u202a';
    private static final char PDF = '\u202c';
    private static boolean isBidi = false;

    static {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        if ("iw".equals(string) || "ar".equals(string) || "fa".equals(string) || "ur".equals(string)) {
            isBidi = true;
        }
    }

    public static String process(String string) {
        return TextProcessor.process(string, TextProcessor.getDefaultDelimiters());
    }

    public static String process(String string, String string2) {
        if (!isBidi || string == null) {
            return string;
        }
        string2 = string2 == null ? TextProcessor.getDefaultDelimiters() : string2;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string2.indexOf(string4) != -1) {
                if (string3 == null) {
                    stringBuffer.append('\u200e');
                }
                stringBuffer.append(string4);
                stringBuffer.append('\u200e');
            } else {
                boolean bl = false;
                char c = string4.charAt(0);
                if (c == '\u200e') {
                    if (string4.length() == 1) {
                        if (string3 == null) {
                            stringBuffer.append(string4);
                        }
                        bl = true;
                    } else {
                        string4 = string4.substring(1, string4.length());
                        c = string4.charAt(0);
                    }
                }
                if (!bl) {
                    if (c == '\u202a') {
                        stringBuffer.append(string4);
                    } else {
                        stringBuffer.append('\u202a');
                        stringBuffer.append(string4);
                        stringBuffer.append('\u202c');
                    }
                }
            }
            string3 = string4;
        }
        return stringBuffer.toString();
    }

    public static String getDefaultDelimiters() {
        return delimiterString;
    }

    private TextProcessor() {
    }
}

