/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartSashContainer;

class LayoutPartSash
extends LayoutPart {
    private Composite sash;
    private boolean enabled = false;
    private PartSashContainer rootContainer;
    private int style;
    private LayoutPartSash preLimit;
    private LayoutPartSash postLimit;
    SelectionListener selectionListener;
    private int left = 300;
    private int right = 300;
    private boolean isVisible;

    LayoutPartSash(PartSashContainer partSashContainer, int n) {
        super(null);
        this.style = n;
        this.rootContainer = partSashContainer;
    }

    public void createControl(Composite composite) {
        if (this.isVisible) {
            this.doCreateControl();
        }
    }

    private void doCreateControl() {
        if (this.sash == null) {
            this.sash = new Composite(this.rootContainer.getParent(), this.style | 0x10000);
            this.sash.setEnabled(this.enabled);
        }
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible) {
            return;
        }
        if (bl) {
            this.doCreateControl();
        } else {
            this.dispose();
        }
        super.setVisible(bl);
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void dispose() {
        if (this.sash != null) {
            this.sash.dispose();
        }
        this.sash = null;
    }

    public Rectangle getBounds() {
        if (this.sash == null) {
            return super.getBounds();
        }
        return this.sash.getBounds();
    }

    public Control getControl() {
        return this.sash;
    }

    public String getID() {
        return null;
    }

    LayoutPartSash getPostLimit() {
        return this.postLimit;
    }

    LayoutPartSash getPreLimit() {
        return this.preLimit;
    }

    int getLeft() {
        return this.left;
    }

    int getRight() {
        return this.right;
    }

    boolean isHorizontal() {
        return (this.style & 0x100) == 256;
    }

    boolean isVertical() {
        return (this.style & 0x200) == 512;
    }

    void setPostLimit(LayoutPartSash layoutPartSash) {
        this.postLimit = layoutPartSash;
    }

    void setPreLimit(LayoutPartSash layoutPartSash) {
        this.preLimit = layoutPartSash;
    }

    void setRatio(float f) {
        int n = this.left + this.right;
        int n2 = (int)((float)n * f);
        this.setSizes(n2, n - n2);
    }

    void setSizes(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        if (n == this.left && n2 == this.right) {
            return;
        }
        this.left = n;
        this.right = n2;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.sash != null) {
            this.sash.setEnabled(this.enabled);
        }
    }
}

