/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;

public class EventManager {
    static final boolean DEBUG = false;
    private EventThread thread = null;
    protected final String threadName;

    public EventManager() {
        this(null);
    }

    public EventManager(String string) {
        this.threadName = string;
    }

    public synchronized void close() {
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
    }

    synchronized EventThread getEventThread() {
        if (this.thread == null) {
            this.thread = this.threadName == null ? new EventThread() : new EventThread(this.threadName);
            this.thread.start();
        }
        return this.thread;
    }

    static void dispatchEvent(EventListeners.ListElement[] listElementArray, EventDispatcher eventDispatcher, int n, Object object) {
        int n2 = listElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            EventListeners.ListElement listElement = listElementArray[n3];
            if (listElement == null) break;
            try {
                eventDispatcher.dispatchEvent(listElement.primary, listElement.companion, n, object);
            }
            catch (Throwable throwable) {}
            ++n3;
        }
    }

    static class EventThread
    extends Thread {
        private Queued head;
        private Queued tail;
        private volatile boolean running;

        EventThread(String string) {
            super(string);
            this.init();
        }

        EventThread() {
            this.init();
        }

        private void init() {
            this.running = true;
            this.head = null;
            this.tail = null;
            this.setDaemon(true);
        }

        void close() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            try {
                while (true) {
                    Queued queued;
                    if ((queued = this.getNextEvent()) == null) {
                        return;
                    }
                    EventManager.dispatchEvent(queued.listeners, queued.dispatcher, queued.action, queued.object);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
        }

        synchronized void postEvent(EventListeners.ListElement[] listElementArray, EventDispatcher eventDispatcher, int n, Object object) {
            if (!this.isAlive()) {
                throw new IllegalStateException();
            }
            Queued queued = new Queued(listElementArray, eventDispatcher, n, object);
            if (this.head == null) {
                this.head = queued;
                this.tail = queued;
            } else {
                this.tail.next = queued;
                this.tail = queued;
            }
            this.notify();
        }

        private synchronized Queued getNextEvent() {
            while (this.running && this.head == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.running) {
                return null;
            }
            Queued queued = this.head;
            this.head = queued.next;
            if (this.head == null) {
                this.tail = null;
            }
            return queued;
        }

        private static class Queued {
            final EventListeners.ListElement[] listeners;
            final EventDispatcher dispatcher;
            final int action;
            final Object object;
            Queued next;

            Queued(EventListeners.ListElement[] listElementArray, EventDispatcher eventDispatcher, int n, Object object) {
                this.listeners = listElementArray;
                this.dispatcher = eventDispatcher;
                this.action = n;
                this.object = object;
                this.next = null;
            }
        }
    }
}

