/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ContentHandlerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleNativeCode;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.PermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class Framework
implements EventDispatcher,
EventPublisher {
    private static final String PROP_CONTEXTCLASSLOADER_PARENT = "osgi.contextClassLoaderParent";
    private static final String CONTEXTCLASSLOADER_PARENT_APP = "app";
    private static final String CONTEXTCLASSLOADER_PARENT_EXT = "ext";
    private static final String CONTEXTCLASSLOADER_PARENT_BOOT = "boot";
    private static final String CONTEXTCLASSLOADER_PARENT_FWK = "fwk";
    private static String J2SE = "J2SE-";
    private static String JAVASE = "JavaSE-";
    private static String PROFILE_EXT = ".profile";
    protected FrameworkAdaptor adaptor;
    protected Properties properties;
    protected boolean active;
    protected BundleRepository bundles;
    protected PackageAdminImpl packageAdmin;
    protected PermissionAdminImpl permissionAdmin;
    protected StartLevelManager startLevelManager;
    protected ServiceRegistry serviceRegistry;
    protected long serviceid;
    protected EventListeners bundleEvent;
    protected static final int BUNDLEEVENT = 1;
    protected EventListeners bundleEventSync;
    protected static final int BUNDLEEVENTSYNC = 2;
    protected EventListeners serviceEvent;
    protected static final int SERVICEEVENT = 3;
    protected EventListeners frameworkEvent;
    protected static final int FRAMEWORKEVENT = 4;
    protected static final int BATCHEVENT_BEGIN = -2147483647;
    protected static final int BATCHEVENT_END = Integer.MIN_VALUE;
    protected EventManager eventManager;
    protected Hashtable installLock;
    protected SystemBundle systemBundle;
    String[] bootDelegation;
    String[] bootDelegationStems;
    boolean bootDelegateAll = false;
    boolean contextBootDelegation = "true".equals(FrameworkProperties.getProperty("osgi.context.bootdelegation", "true"));
    boolean compatibiltyBootDelegation = false;
    protected static AliasMapper aliasMapper = new AliasMapper();
    protected ConditionalPermissionAdminImpl condPermAdmin;
    SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private HashMap adminPermissions = new HashMap();
    private StreamHandlerFactory streamHandlerFactory;
    private org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework$GetDataFileAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        clazz2.getName();
    }

    public Framework(FrameworkAdaptor frameworkAdaptor) {
        this.initialize(frameworkAdaptor);
    }

    protected void initialize(FrameworkAdaptor frameworkAdaptor) {
        BundleData[] bundleDataArray;
        if (Profile.STARTUP) {
            Profile.logEnter("Framework.initialze()", null);
        }
        long l = System.currentTimeMillis();
        this.adaptor = frameworkAdaptor;
        this.active = false;
        this.installSecurityManager();
        if (Debug.DEBUG_SECURITY) {
            Debug.println("SecurityManager: " + System.getSecurityManager());
            Debug.println("ProtectionDomain of Framework.class: \n" + this.getClass().getProtectionDomain());
        }
        this.setNLSFrameworkLog();
        this.initializeContextFinder();
        frameworkAdaptor.initialize(this);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter initialized");
        }
        try {
            frameworkAdaptor.initializeStorage();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage());
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter storage initialized");
        }
        this.initializeProperties(frameworkAdaptor.getProperties());
        this.packageAdmin = new PackageAdminImpl(this);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                this.permissionAdmin = new PermissionAdminImpl(this, frameworkAdaptor.getPermissionStorage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException(iOException.getMessage());
            }
            try {
                this.condPermAdmin = new ConditionalPermissionAdminImpl(this, frameworkAdaptor.getPermissionStorage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException(iOException.getMessage());
            }
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done init props & new PermissionAdminImpl");
        }
        this.startLevelManager = new StartLevelManager(this);
        this.eventManager = new EventManager("Framework Event Dispatcher");
        this.bundleEvent = new EventListeners();
        this.bundleEventSync = new EventListeners();
        this.serviceEvent = new EventListeners();
        this.frameworkEvent = new EventListeners();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new EventManager");
        }
        this.serviceid = 1L;
        this.serviceRegistry = frameworkAdaptor.getServiceRegistry();
        this.installLock = new Hashtable(10);
        this.createSystemBundle();
        this.loadVMProfile();
        this.setBootDelegation();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done createSystemBundle");
        }
        this.installURLStreamHandlerFactory(this.systemBundle.context, frameworkAdaptor);
        this.installContentHandlerFactory(this.systemBundle.context, frameworkAdaptor);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new URLStream/Content HandlerFactory");
        }
        this.bundles = new BundleRepository((bundleDataArray = frameworkAdaptor.getInstalledBundles()) == null ? 10 : bundleDataArray.length + 1);
        this.bundles.add(this.systemBundle);
        if (bundleDataArray != null) {
            int n = 0;
            while (n < bundleDataArray.length) {
                try {
                    AbstractBundle abstractBundle = AbstractBundle.createBundle(bundleDataArray[n], this);
                    this.bundles.add(abstractBundle);
                }
                catch (BundleException bundleException) {
                    this.publishFrameworkEvent(2, this.systemBundle, bundleException);
                }
                ++n;
            }
        }
        if (Debug.DEBUG_GENERAL) {
            System.out.println("Initialize the framework: " + (System.currentTimeMillis() - l));
        }
        if (Profile.STARTUP) {
            Profile.logExit("Framework.initialize()");
        }
    }

    private void setNLSFrameworkLog() {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.util.NLS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getDeclaredField("frameworkLog");
            field.setAccessible(true);
            field.set(null, this.adaptor.getFrameworkLog());
        }
        catch (Exception exception) {
            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, exception.getMessage(), 0, exception, null));
        }
    }

    private void createSystemBundle() {
        try {
            this.systemBundle = new SystemBundle(this);
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, bundleException.getMessage()));
        }
    }

    protected void initializeProperties(Properties properties) {
        String string;
        this.properties = FrameworkProperties.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.properties.getProperty(string) != null) continue;
            this.properties.put(string, properties.getProperty(string));
        }
        this.properties.put("org.osgi.framework.vendor", "Eclipse");
        this.properties.put("org.osgi.framework.version", "1.3");
        string = this.properties.getProperty("org.osgi.framework.processor");
        if (string == null && (string = this.properties.getProperty("os.arch")) != null) {
            this.properties.put("org.osgi.framework.processor", string);
        }
        if ((string = this.properties.getProperty("org.osgi.framework.os.name")) == null) {
            string = this.properties.getProperty("os.name");
            try {
                String string2 = (String)aliasMapper.aliasOSName(string);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (ClassCastException classCastException) {}
            if (string != null) {
                this.properties.put("org.osgi.framework.os.name", string);
            }
        }
        if ((string = this.properties.getProperty("org.osgi.framework.os.version")) == null && (string = this.properties.getProperty("os.version")) != null) {
            int n = string.indexOf(32);
            if (n > 0) {
                string = string.substring(0, n);
            }
            this.properties.put("org.osgi.framework.os.version", string);
        }
        if ((string = this.properties.getProperty("org.osgi.framework.language")) == null) {
            this.properties.put("org.osgi.framework.language", Locale.getDefault().getLanguage());
        }
        this.properties.put("org.osgi.supports.framework.fragment", "true");
        this.properties.put("org.osgi.supports.framework.requirebundle", "true");
    }

    private void setBootDelegation() {
        this.compatibiltyBootDelegation = "true".equals(FrameworkProperties.getProperty(Constants.OSGI_COMPATIBILITY_BOOTDELEGATION));
        String string = this.properties.getProperty("org.osgi.framework.bootdelegation");
        if (string == null) {
            return;
        }
        if (string.trim().length() == 0) {
            return;
        }
        String[] stringArray = ManifestElement.getArrayFromList(string);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("*")) {
                this.bootDelegateAll = true;
                return;
            }
            if (stringArray[n].endsWith("*")) {
                if (stringArray[n].length() > 2 && stringArray[n].endsWith(".*")) {
                    arrayList2.add(stringArray[n].substring(0, stringArray[n].length() - 1));
                }
            } else {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.bootDelegation = arrayList.toArray(new String[arrayList.size()]);
        }
        if (arrayList2.size() > 0) {
            this.bootDelegationStems = arrayList2.toArray(new String[arrayList2.size()]);
        }
    }

    private void loadVMProfile() {
        String string;
        Properties properties = this.findVMProfile();
        String string2 = this.properties.getProperty("org.osgi.framework.system.packages");
        if (string2 == null && (string2 = properties.getProperty("org.osgi.framework.system.packages")) != null) {
            this.properties.put("org.osgi.framework.system.packages", string2);
        }
        String string3 = this.properties.getProperty("osgi.java.profile.bootdelegation");
        String string4 = properties.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(string3)) {
            if (string4 == null) {
                this.properties.remove("org.osgi.framework.bootdelegation");
            } else {
                this.properties.put("org.osgi.framework.bootdelegation", string4);
            }
        } else if ("none".equals(string3)) {
            this.properties.remove("org.osgi.framework.bootdelegation");
        }
        if (this.properties.getProperty("org.osgi.framework.executionenvironment") == null && (string = properties.getProperty("org.osgi.framework.executionenvironment", properties.getProperty("osgi.java.profile.name"))) != null) {
            this.properties.put("org.osgi.framework.executionenvironment", string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties findVMProfile() {
        String string;
        Properties properties;
        block24: {
            Version version;
            Object object;
            Object object2;
            Object object3;
            properties = new Properties();
            String string2 = this.properties.getProperty("microedition.configuration");
            String string3 = this.properties.getProperty("microedition.profiles");
            string = null;
            String string4 = null;
            Version version2 = null;
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                object3 = ManifestElement.getArrayFromList(string3, " ");
                if (object3 != null && ((String[])object3).length > 0) {
                    string = String.valueOf(string2) + '_' + (String)object3[((Object)object3).length - 1];
                }
            } else {
                object3 = this.properties.getProperty("java.specification.version");
                if (object3 != null) {
                    object2 = new StringTokenizer((String)object3, " _-");
                    object3 = ((StringTokenizer)object2).nextToken();
                    object = this.properties.getProperty("java.specification.name");
                    if ("J2ME Foundation Specification".equals(object)) {
                        string = "CDC-" + (String)object3 + "_Foundation-" + (String)object3;
                    } else {
                        version = new Version("1.6");
                        string4 = J2SE;
                        try {
                            version2 = new Version((String)object3);
                            if (version.compareTo(version2) <= 0) {
                                string4 = JAVASE;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        string = String.valueOf(string4) + (String)object3;
                    }
                }
            }
            object3 = null;
            object2 = FrameworkProperties.getProperty("osgi.java.profile");
            if (object2 != null) {
                try {
                    object3 = new URL((String)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    object3 = this.findInSystemBundle((String)object2);
                }
            }
            if (object3 == null && string != null && (object3 = this.findInSystemBundle((String)(object = String.valueOf(string) + PROFILE_EXT))) == null) {
                object3 = this.getNextBestProfile(string4, version2);
            }
            if (object3 == null) {
                object3 = this.findInSystemBundle("OSGi_Minimum-1.1.profile");
            }
            if (object3 != null) {
                object = null;
                try {
                    try {
                        object = ((URL)object3).openStream();
                        properties.load(new BufferedInputStream((InputStream)object));
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    version = null;
                    if (object == null) throw throwable;
                    try {
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    version = null;
                    if (object == null) break block24;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)object).close();
            }
        }
        if (properties.getProperty("osgi.java.profile.name") != null) return properties;
        if (string != null) {
            properties.put("osgi.java.profile.name", string.replace('_', '/'));
            return properties;
        }
        properties.put("osgi.java.profile.name", "OSGi/Minimum-1.1");
        return properties;
    }

    private URL getNextBestProfile(String string, Version version) {
        if (version == null || string != J2SE && string != JAVASE) {
            return null;
        }
        URL uRL = this.findNextBestProfile(string, version);
        if (uRL == null && string == JAVASE) {
            uRL = this.findNextBestProfile(J2SE, version);
        }
        return uRL;
    }

    private URL findNextBestProfile(String string, Version version) {
        URL uRL = null;
        int n = version.getMinor();
        while ((uRL = this.findInSystemBundle(String.valueOf(string) + version.getMajor() + "." + n + PROFILE_EXT)) == null && --n > 0) {
        }
        return uRL;
    }

    private URL findInSystemBundle(String string) {
        URL uRL = this.systemBundle.getEntry(string);
        if (uRL == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        }
        return uRL;
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.active) {
            this.shutdown();
        }
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List list = this.bundles.getBundles();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                AbstractBundle abstractBundle = (AbstractBundle)list.get(n2);
                abstractBundle.close();
                ++n2;
            }
            this.bundles.removeAllBundles();
        }
        this.serviceRegistry = null;
        if (this.bundleEvent != null) {
            this.bundleEvent.removeAllListeners();
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.bundleEventSync.removeAllListeners();
            this.bundleEventSync = null;
        }
        if (this.serviceEvent != null) {
            this.serviceEvent.removeAllListeners();
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.frameworkEvent.removeAllListeners();
            this.frameworkEvent = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        this.permissionAdmin = null;
        this.condPermAdmin = null;
        this.packageAdmin = null;
        this.adaptor = null;
        this.uninstallURLStreamHandlerFactory();
        this.uninstallContentHandlerFactory();
    }

    public synchronized void launch() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to launch framework");
        }
        this.systemBundle.resume();
    }

    public synchronized void shutdown() {
        if (!this.active) {
            return;
        }
        this.systemBundle.state = 16;
        this.publishBundleEvent(256, this.systemBundle);
        try {
            this.adaptor.frameworkStopping(this.systemBundle.getContext());
        }
        catch (Throwable throwable) {
            this.publishFrameworkEvent(2, this.systemBundle, throwable);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to shutdown Framework");
        }
        this.systemBundle.suspend();
        try {
            this.adaptor.compactStorage();
        }
        catch (IOException iOException) {
            this.publishFrameworkEvent(2, this.systemBundle, iOException);
        }
        this.active = false;
    }

    AbstractBundle createAndVerifyBundle(BundleData bundleData) throws BundleException {
        AbstractBundle abstractBundle;
        if (bundleData.getSymbolicName() != null && (abstractBundle = this.getBundleBySymbolicName(bundleData.getSymbolicName(), bundleData.getVersion())) != null && abstractBundle.getBundleId() != bundleData.getBundleID()) {
            throw new BundleException(NLS.bind(Msg.BUNDLE_INSTALL_SAME_UNIQUEID, new Object[]{abstractBundle.getSymbolicName(), abstractBundle.getVersion().toString(), abstractBundle.getLocation()}));
        }
        this.verifyExecutionEnvironment(bundleData.getManifest());
        return AbstractBundle.createBundle(bundleData, this);
    }

    protected boolean verifyExecutionEnvironment(Dictionary dictionary) throws BundleException {
        int n;
        ManifestElement[] manifestElementArray;
        if (!Boolean.valueOf(FrameworkProperties.getProperty(Constants.ECLIPSE_EE_INSTALL_VERIFY, ((Object)Boolean.TRUE).toString())).booleanValue()) {
            return true;
        }
        String string = (String)dictionary.get("Bundle-RequiredExecutionEnvironment");
        if (string == null) {
            return true;
        }
        ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", string);
        if (manifestElementArray2.length == 0) {
            return true;
        }
        String string2 = FrameworkProperties.getProperty("org.osgi.framework.executionenvironment");
        if (string2 != null && !string2.equals("")) {
            manifestElementArray = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", string2);
            n = 0;
            while (n < manifestElementArray.length) {
                int n2 = 0;
                while (n2 < manifestElementArray2.length) {
                    if (manifestElementArray[n].getValue().equals(manifestElementArray2[n2].getValue())) {
                        return true;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        manifestElementArray = new StringBuffer(25);
        n = 0;
        while (n < manifestElementArray2.length) {
            if (n > 0) {
                manifestElementArray.append(",");
            }
            manifestElementArray.append(manifestElementArray2[n].getValue());
            ++n;
        }
        throw new BundleException(NLS.bind(Msg.BUNDLE_INSTALL_REQUIRED_EE_EXCEPTION, manifestElementArray.toString()));
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    protected String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    protected Object setProperty(String string, String string2) {
        return this.properties.put(string, string2);
    }

    public AbstractBundle installBundle(final String string) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from location: " + string);
        }
        final AccessControlContext accessControlContext = AccessController.getContext();
        return this.installWorker(string, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                URLConnection uRLConnection = Framework.this.adaptor.mapLocationToURLConnection(string);
                return Framework.this.installWorkerPrivileged(string, uRLConnection, accessControlContext);
            }
        });
    }

    protected AbstractBundle installBundle(final String string, final InputStream inputStream) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from inputstream: " + string + ", " + inputStream);
        }
        final AccessControlContext accessControlContext = AccessController.getContext();
        return this.installWorker(string, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                BundleSource bundleSource = new BundleSource(inputStream);
                return Framework.this.installWorkerPrivileged(string, bundleSource, accessControlContext);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorker(String string, PrivilegedExceptionAction privilegedExceptionAction) throws BundleException {
        Hashtable hashtable;
        Object object;
        AbstractBundle abstractBundle;
        Object object2 = this.installLock;
        synchronized (object2) {
            while (true) {
                if ((abstractBundle = this.getBundleByLocation(string)) != null) {
                    return abstractBundle;
                }
                Thread thread = Thread.currentThread();
                object = this.installLock.put(string, thread);
                if (object == null) break;
                if (thread.equals(object)) {
                    throw new BundleException(Msg.BUNDLE_INSTALL_RECURSION_EXCEPTION);
                }
                try {
                    this.installLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            object2 = (AbstractBundle)AccessController.doPrivileged(privilegedExceptionAction);
            this.publishBundleEvent(1, (Bundle)object2);
            object = object2;
            abstractBundle = null;
            hashtable = this.installLock;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                if (privilegedActionException.getException() instanceof RuntimeException) {
                    throw (RuntimeException)privilegedActionException.getException();
                }
                throw (BundleException)privilegedActionException.getException();
            }
            catch (Throwable throwable) {
                abstractBundle = null;
                Hashtable hashtable2 = this.installLock;
                synchronized (hashtable2) {
                    this.installLock.remove(string);
                    this.installLock.notifyAll();
                }
                throw throwable;
            }
        }
        synchronized (hashtable) {
            this.installLock.remove(string);
            this.installLock.notifyAll();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractBundle installWorkerPrivileged(String string, URLConnection uRLConnection, AccessControlContext accessControlContext) throws BundleException {
        BundleOperation bundleOperation = this.adaptor.installBundle(string, uRLConnection);
        try {
            BundleData bundleData = bundleOperation.begin();
            final AbstractBundle abstractBundle = this.createAndVerifyBundle(bundleData);
            String[] stringArray = this.adaptor.getBundleWatcher();
            if (stringArray != null) {
                stringArray.watchBundle(abstractBundle, 1);
            }
            try {
                try {
                    stringArray = this.selectNativeCode(abstractBundle);
                    if (stringArray != null) {
                        bundleData.installNativeCode(stringArray);
                    }
                    abstractBundle.load();
                    if (System.getSecurityManager() != null) {
                        boolean bl;
                        boolean bl2 = bl = (bundleData.getType() & 6) != 0;
                        if (bl && !abstractBundle.hasPermission(new AllPermission())) {
                            throw new BundleException(Msg.BUNDLE_EXTENSION_PERMISSION, new SecurityException(Msg.BUNDLE_EXTENSION_PERMISSION));
                        }
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    Framework.this.checkAdminPermission(abstractBundle, "lifecycle");
                                    if (bl) {
                                        Framework.this.checkAdminPermission(abstractBundle, "extensionLifecycle");
                                    }
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw privilegedActionException.getException();
                        }
                    }
                    bundleOperation.commit(false);
                }
                catch (Throwable throwable) {
                    BundleRepository bundleRepository = this.bundles;
                    synchronized (bundleRepository) {
                        abstractBundle.unload();
                    }
                    abstractBundle.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                BundleWatcher bundleWatcher = this.adaptor.getBundleWatcher();
                if (bundleWatcher == null) throw throwable;
                bundleWatcher.watchBundle(abstractBundle, 2);
                throw throwable;
            }
            {
                Object var10_16 = null;
                BundleWatcher bundleWatcher = this.adaptor.getBundleWatcher();
                if (bundleWatcher != null) {
                    bundleWatcher.watchBundle(abstractBundle, 2);
                }
                this.bundles.add(abstractBundle);
                return abstractBundle;
            }
        }
        catch (Throwable throwable) {
            try {
                bundleOperation.undo();
            }
            catch (BundleException bundleException) {
                this.publishFrameworkEvent(2, this.systemBundle, bundleException);
            }
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            if (!(throwable instanceof BundleException)) throw new BundleException(throwable.getMessage(), throwable);
            throw (BundleException)throwable;
        }
    }

    String[] selectNativeCode(Bundle bundle) throws BundleException {
        BundleNativeCode bundleNativeCode;
        Version version;
        String string = (String)((AbstractBundle)bundle).getBundleData().getManifest().get("Bundle-NativeCode");
        if (string == null) {
            return null;
        }
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader("Bundle-NativeCode", string);
        ArrayList<BundleNativeCode> arrayList = new ArrayList<BundleNativeCode>(manifestElementArray.length);
        int n = manifestElementArray.length;
        boolean bl = false;
        if (manifestElementArray[n - 1].getValue().equals("*")) {
            bl = true;
            --n;
        }
        String string2 = this.getProperty("org.osgi.framework.processor");
        String string3 = this.getProperty("org.osgi.framework.os.name");
        try {
            version = Version.parseVersion(this.getProperty("org.osgi.framework.os.version"));
        }
        catch (Exception exception) {
            version = Version.emptyVersion;
        }
        String string4 = this.getProperty("org.osgi.framework.language");
        int n2 = 0;
        while (n2 < n) {
            bundleNativeCode = new BundleNativeCode(manifestElementArray[n2], (AbstractBundle)bundle);
            if (bundleNativeCode.matchProcessorOSNameFilter(string2, string3) > 0 && bundleNativeCode.matchOSVersion(version) != null && bundleNativeCode.matchLanguage(string4) > 0) {
                arrayList.add(bundleNativeCode);
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return this.noMatches(bl);
        }
        Iterator iterator = arrayList.iterator();
        bundleNativeCode = (BundleNativeCode)iterator.next();
        while (iterator.hasNext()) {
            BundleNativeCode bundleNativeCode2 = (BundleNativeCode)iterator.next();
            if (!this.isBncGreaterThan(bundleNativeCode2, bundleNativeCode, version, string4)) continue;
            bundleNativeCode = bundleNativeCode2;
        }
        return bundleNativeCode.getPaths();
    }

    private boolean isBncGreaterThan(BundleNativeCode bundleNativeCode, BundleNativeCode bundleNativeCode2, Version version, String string) {
        Version version2;
        Version version3 = bundleNativeCode2.matchOSVersion(version);
        if (version3.compareTo(version2 = bundleNativeCode.matchOSVersion(version)) < 0) {
            return true;
        }
        return bundleNativeCode2.matchLanguage(string) < bundleNativeCode.matchLanguage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundle(long l) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundleBySymbolicName(String string, Version version) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(string, version);
        }
    }

    protected BundleRepository getBundles() {
        return this.bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getAllBundles() {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            int n;
            List list;
            block4: {
                list = this.bundles.getBundles();
                n = list.size();
                if (n != 0) break block4;
                return null;
            }
            AbstractBundle[] abstractBundleArray = new AbstractBundle[n];
            list.toArray(abstractBundleArray);
            return abstractBundleArray;
        }
    }

    protected void resumeBundle(AbstractBundle abstractBundle) {
        if (abstractBundle.isActive()) {
            return;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to resume bundle " + abstractBundle);
            }
            abstractBundle.resume();
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle resume exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.publishFrameworkEvent(2, abstractBundle, bundleException);
        }
    }

    protected boolean suspendBundle(AbstractBundle abstractBundle, boolean bl) {
        boolean bl2 = false;
        if (!abstractBundle.isActive() || abstractBundle.isFragment()) {
            return bl2;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to suspend bundle " + abstractBundle);
            }
            abstractBundle.suspend(bl);
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle suspend exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.publishFrameworkEvent(2, abstractBundle, bundleException);
        }
        if (!abstractBundle.isActive()) {
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundleByLocation(String string) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            final String string2 = string;
            return (AbstractBundle)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    List list = Framework.this.bundles.getBundles();
                    int n = list.size();
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractBundle abstractBundle = (AbstractBundle)list.get(n2);
                        if (string2.equals(abstractBundle.getLocation())) {
                            return abstractBundle;
                        }
                        ++n2;
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getBundleBySymbolicName(String string) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundles(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference[] getServiceReferences(String string, String string2, BundleContextImpl bundleContextImpl, boolean bl) throws InvalidSyntaxException {
        FilterImpl filterImpl = string2 == null ? null : new FilterImpl(string2);
        ServiceReference[] serviceReferenceArray = null;
        if (string != null) {
            try {
                this.checkGetServicePermission(string);
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        ServiceRegistry serviceRegistry = this.serviceRegistry;
        synchronized (serviceRegistry) {
            block17: {
                serviceReferenceArray = this.serviceRegistry.lookupServiceReferences(string, filterImpl);
                if (serviceReferenceArray != null) break block17;
                return null;
            }
            int n = 0;
            int n2 = serviceReferenceArray.length - 1;
            while (n2 >= 0) {
                ServiceReferenceImpl serviceReferenceImpl = (ServiceReferenceImpl)serviceReferenceArray[n2];
                String[] stringArray = serviceReferenceImpl.getClasses();
                if (bl || bundleContextImpl.isAssignableTo((ServiceReferenceImpl)serviceReferenceArray[n2])) {
                    if (string == null) {
                        try {
                            this.checkGetServicePermission(stringArray);
                        }
                        catch (SecurityException securityException) {
                            serviceReferenceArray[n2] = null;
                            ++n;
                        }
                    }
                } else {
                    serviceReferenceArray[n2] = null;
                    ++n;
                }
                --n2;
            }
            if (n > 0) {
                ServiceReference[] serviceReferenceArray2 = serviceReferenceArray;
                serviceReferenceArray = new ServiceReference[serviceReferenceArray2.length - n];
                int n3 = serviceReferenceArray2.length - 1;
                while (n3 >= 0) {
                    if (serviceReferenceArray2[n3] == null) {
                        --n;
                    } else {
                        serviceReferenceArray[n3 - n] = serviceReferenceArray2[n3];
                    }
                    --n3;
                }
            }
        }
        return serviceReferenceArray == null || serviceReferenceArray.length == 0 ? null : serviceReferenceArray;
    }

    protected long getNextServiceId() {
        long l = this.serviceid++;
        return l;
    }

    protected File getDataFile(AbstractBundle abstractBundle, String string) {
        return (File)AccessController.doPrivileged(new GetDataFileAction(abstractBundle, string));
    }

    protected void checkAdminPermission(Bundle bundle, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.getAdminPermission(bundle, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminPermission getAdminPermission(Bundle bundle, String string) {
        HashMap hashMap = this.adminPermissions;
        synchronized (hashMap) {
            AdminPermission adminPermission;
            Long l = new Long(bundle.getBundleId());
            HashMap<String, AdminPermission> hashMap2 = (HashMap<String, AdminPermission>)this.adminPermissions.get(l);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, AdminPermission>();
                this.adminPermissions.put(l, hashMap2);
            }
            if ((adminPermission = (AdminPermission)hashMap2.get(string)) == null) {
                adminPermission = new AdminPermission(bundle, string);
                hashMap2.put(string, adminPermission);
            }
            return adminPermission;
        }
    }

    protected void checkRegisterServicePermission(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                securityManager.checkPermission(new ServicePermission(stringArray[n2], "register"));
                ++n2;
            }
        }
    }

    protected void checkGetServicePermission(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            SecurityException securityException = null;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                try {
                    securityManager.checkPermission(new ServicePermission(stringArray[n2], "get"));
                    return;
                }
                catch (SecurityException securityException2) {
                    securityException = securityException2;
                    ++n2;
                }
            }
            throw securityException;
        }
    }

    protected void checkGetServicePermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ServicePermission(string, "get"));
        }
    }

    protected void installSecurityManager() {
        SecurityManager securityManager;
        String string = System.getProperty("java.security.manager");
        if (string != null && (securityManager = System.getSecurityManager()) == null) {
            if (string.length() < 1) {
                string = "java.lang.SecurityManager";
            }
            try {
                Class<?> clazz = Class.forName(string);
                securityManager = (SecurityManager)clazz.newInstance();
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("Setting SecurityManager to: " + securityManager);
                }
                System.setSecurityManager(securityManager);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            throw new NoClassDefFoundError(string);
        }
    }

    public void publishFrameworkEvent(int n, Bundle bundle, Throwable throwable) {
        if (this.frameworkEvent != null) {
            if (bundle == null) {
                bundle = this.systemBundle;
            }
            final FrameworkEvent frameworkEvent = new FrameworkEvent(n, bundle, throwable);
            if (System.getSecurityManager() == null) {
                this.publishFrameworkEventPrivileged(frameworkEvent);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishFrameworkEventPrivileged(frameworkEvent);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent frameworkEvent) {
        Object object;
        if (frameworkEvent.getType() == 2 && (object = this.adaptor.getFrameworkLog()) != null) {
            object.log(frameworkEvent);
        }
        object = new ListenerQueue(this.eventManager);
        ListenerQueue listenerQueue = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.frameworkEvent;
        synchronized (eventListeners) {
            listenerQueue.queueListeners(this.frameworkEvent, this);
            listenerQueue.dispatchEventSynchronous(4, object);
        }
        ((ListenerQueue)object).dispatchEventAsynchronous(4, frameworkEvent);
    }

    public void publishBundleEvent(int n, Bundle bundle) {
        if (this.bundleEventSync != null || this.bundleEvent != null) {
            final BundleEvent bundleEvent = new BundleEvent(n, bundle);
            if (System.getSecurityManager() == null) {
                this.publishBundleEventPrivileged(bundleEvent);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishBundleEventPrivileged(bundleEvent);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBundleEventPrivileged(BundleEvent bundleEvent) {
        Object object;
        ListenerQueue listenerQueue;
        ListenerQueue listenerQueue2 = null;
        if (this.bundleEventSync != null) {
            listenerQueue2 = new ListenerQueue(this.eventManager);
            listenerQueue = new ListenerQueue(this.eventManager);
            object = this.bundleEventSync;
            synchronized (object) {
                listenerQueue.queueListeners(this.bundleEventSync, this);
                listenerQueue.dispatchEventSynchronous(2, listenerQueue2);
            }
        }
        listenerQueue = null;
        if (this.bundleEvent != null && (bundleEvent.getType() & 0x380) == 0) {
            listenerQueue = new ListenerQueue(this.eventManager);
            object = new ListenerQueue(this.eventManager);
            EventListeners eventListeners = this.bundleEvent;
            synchronized (eventListeners) {
                ((ListenerQueue)object).queueListeners(this.bundleEvent, this);
                ((ListenerQueue)object).dispatchEventSynchronous(1, listenerQueue);
            }
        }
        if (listenerQueue2 != null) {
            listenerQueue2.dispatchEventSynchronous(2, bundleEvent);
        }
        if (listenerQueue != null) {
            listenerQueue.dispatchEventAsynchronous(1, bundleEvent);
        }
    }

    public void publishServiceEvent(int n, ServiceReference serviceReference) {
        if (this.serviceEvent != null) {
            final ServiceEvent serviceEvent = new ServiceEvent(n, serviceReference);
            if (System.getSecurityManager() == null) {
                this.publishServiceEventPrivileged(serviceEvent);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishServiceEventPrivileged(serviceEvent);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishServiceEventPrivileged(ServiceEvent serviceEvent) {
        ListenerQueue listenerQueue = new ListenerQueue(this.eventManager);
        ListenerQueue listenerQueue2 = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.serviceEvent;
        synchronized (eventListeners) {
            listenerQueue2.queueListeners(this.serviceEvent, this);
            listenerQueue2.dispatchEventSynchronous(3, listenerQueue);
        }
        listenerQueue.dispatchEventSynchronous(3, serviceEvent);
    }

    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        block10: {
            try {
                BundleContextImpl bundleContextImpl = (BundleContextImpl)object;
                if (bundleContextImpl.isValid()) {
                    ListenerQueue listenerQueue = (ListenerQueue)object3;
                    switch (n) {
                        case 1: {
                            listenerQueue.queueListeners(bundleContextImpl.bundleEvent, bundleContextImpl);
                            break;
                        }
                        case 2: {
                            listenerQueue.queueListeners(bundleContextImpl.bundleEventSync, bundleContextImpl);
                            break;
                        }
                        case 3: {
                            listenerQueue.queueListeners(bundleContextImpl.serviceEvent, bundleContextImpl);
                            break;
                        }
                        case 4: {
                            listenerQueue.queueListeners(bundleContextImpl.frameworkEvent, bundleContextImpl);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object object4;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in Top level event dispatcher: " + throwable.getMessage());
                    Debug.printStackTrace(throwable);
                }
                this.adaptor.handleRuntimeError(throwable);
                if (n == 4 && ((FrameworkEvent)(object4 = (FrameworkEvent)object3)).getType() == 2) break block10;
                object4 = (BundleContextImpl)object;
                this.publishFrameworkEvent(2, ((BundleContextImpl)object4).bundle, throwable);
            }
        }
    }

    private String[] noMatches(boolean bl) throws BundleException {
        if (bl) {
            return null;
        }
        throw new BundleException(Msg.BUNDLE_NATIVECODE_MATCH_EXCEPTION);
    }

    private void initializeContextFinder() {
        Thread thread = Thread.currentThread();
        Throwable throwable = null;
        try {
            Class<?> clazz;
            Object object;
            ClassLoader classLoader = null;
            String string = FrameworkProperties.getProperty(PROP_CONTEXTCLASSLOADER_PARENT);
            if (CONTEXTCLASSLOADER_PARENT_APP.equals(string)) {
                classLoader = ClassLoader.getSystemClassLoader();
            } else if (CONTEXTCLASSLOADER_PARENT_BOOT.equals(string)) {
                classLoader = null;
            } else if (CONTEXTCLASSLOADER_PARENT_FWK.equals(string)) {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classLoader = clazz2.getClassLoader();
            } else if (CONTEXTCLASSLOADER_PARENT_EXT.equals(string)) {
                object = ClassLoader.getSystemClassLoader();
                if (object != null) {
                    classLoader = ((ClassLoader)object).getParent();
                }
            } else {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("java.lang.Thread");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = clazz3.getMethod("getContextClassLoader", null);
                classLoader = (ClassLoader)((Method)object).invoke((Object)thread, null);
            }
            if ((clazz = class$3) == null) {
                try {
                    clazz = class$3 = Class.forName("java.lang.Thread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("java.lang.ClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz4;
            object = clazz.getMethod("setContextClassLoader", classArray);
            Object[] objectArray = new Object[]{new ContextFinder(classLoader)};
            ((Method)object).invoke((Object)thread, objectArray);
            return;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throwable = illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
        }
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 1, 0, NLS.bind(Msg.CANNOT_SET_CONTEXTFINDER, null), 0, throwable, null);
        this.adaptor.getFrameworkLog().log(frameworkLogEntry);
    }

    private static Field getStaticField(Class clazz, Class clazz2) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (Modifier.isStatic(fieldArray[n].getModifiers()) && fieldArray[n].getType().equals(clazz2)) {
                fieldArray[n].setAccessible(true);
                return fieldArray[n];
            }
            ++n;
        }
        return null;
    }

    private void installContentHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory = new org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory(bundleContext, frameworkAdaptor);
        try {
            URLConnection.setContentHandlerFactory(contentHandlerFactory);
        }
        catch (Error error) {
            try {
                Framework.forceContentHandlerFactory(contentHandlerFactory);
            }
            catch (Exception exception) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, bundleContext.getBundle(), exception));
                throw error;
            }
        }
        this.contentHandlerFactory = contentHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceContentHandlerFactory(org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory contentHandlerFactory) throws Exception {
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("java.net.URLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$6) == null) {
            try {
                clazz = class$6 = Class.forName("java.net.ContentHandlerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getStaticField(clazz2, clazz)) == null) {
            throw new Exception("Could not find ContentHandlerFactory field");
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.net.URLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz4 = clazz3;
        synchronized (clazz3) {
            ContentHandlerFactory contentHandlerFactory2 = (ContentHandlerFactory)field.get(null);
            if (contentHandlerFactory2 != null) {
                try {
                    contentHandlerFactory2.getClass().getMethod("isMultiplexing", null);
                    Class<?> clazz5 = contentHandlerFactory2.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz6 = class$7;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$7 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz6;
                    Method method = clazz5.getMethod("register", classArray);
                    method.invoke((Object)contentHandlerFactory2, contentHandlerFactory);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    contentHandlerFactory.setParentFactory(contentHandlerFactory2);
                    contentHandlerFactory2 = contentHandlerFactory;
                }
            }
            field.set(null, null);
            Framework.resetContentHandlers();
            URLConnection.setContentHandlerFactory(contentHandlerFactory2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallContentHandlerFactory() {
        try {
            Field field;
            Class<?> clazz;
            Class<?> clazz2 = class$5;
            if (clazz2 == null) {
                try {
                    clazz2 = class$5 = Class.forName("java.net.URLConnection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$6) == null) {
                try {
                    clazz = class$6 = Class.forName("java.net.ContentHandlerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((field = Framework.getStaticField(clazz2, clazz)) == null) {
                return;
            }
            Class<?> clazz3 = class$5;
            if (clazz3 == null) {
                try {
                    clazz3 = class$5 = Class.forName("java.net.URLConnection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz4 = clazz3;
            synchronized (clazz3) {
                ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)field.get(null);
                if (contentHandlerFactory == this.contentHandlerFactory) {
                    contentHandlerFactory = (ContentHandlerFactory)this.contentHandlerFactory.designateSuccessor();
                } else {
                    Class<?> clazz5 = contentHandlerFactory.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz6 = class$7;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$7 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz6;
                    Method method = clazz5.getMethod("unregister", classArray);
                    method.invoke((Object)contentHandlerFactory, this.contentHandlerFactory);
                }
                field.set(null, null);
                Framework.resetContentHandlers();
                if (contentHandlerFactory != null) {
                    URLConnection.setContentHandlerFactory(contentHandlerFactory);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception exception) {}
        {
            return;
        }
    }

    private static void resetContentHandlers() throws IllegalAccessException {
        Hashtable hashtable;
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("java.net.URLConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$8) == null) {
            try {
                clazz = class$8 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getStaticField(clazz2, clazz)) != null && (hashtable = (Hashtable)field.get(null)) != null) {
            hashtable.clear();
        }
    }

    private void installURLStreamHandlerFactory(BundleContext bundleContext, FrameworkAdaptor frameworkAdaptor) {
        StreamHandlerFactory streamHandlerFactory = new StreamHandlerFactory(bundleContext, frameworkAdaptor);
        try {
            URL.setURLStreamHandlerFactory(streamHandlerFactory);
        }
        catch (Error error) {
            try {
                Framework.forceURLStreamHandlerFactory(streamHandlerFactory);
            }
            catch (Exception exception) {
                this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, bundleContext.getBundle(), exception));
                throw error;
            }
        }
        this.streamHandlerFactory = streamHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceURLStreamHandlerFactory(StreamHandlerFactory streamHandlerFactory) throws Exception {
        Object object;
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$10) == null) {
            try {
                clazz = class$10 = Class.forName("java.net.URLStreamHandlerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getStaticField(clazz2, clazz)) == null) {
            throw new Exception("Could not find URLStreamHandlerFactory field");
        }
        Object object2 = object = Framework.getURLStreamHandlerFactoryLock();
        synchronized (object2) {
            URLStreamHandlerFactory uRLStreamHandlerFactory = (URLStreamHandlerFactory)field.get(null);
            if (uRLStreamHandlerFactory != null) {
                try {
                    uRLStreamHandlerFactory.getClass().getMethod("isMultiplexing", null);
                    Class<?> clazz3 = uRLStreamHandlerFactory.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz4 = class$7;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$7 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz4;
                    Method method = clazz3.getMethod("register", classArray);
                    method.invoke((Object)uRLStreamHandlerFactory, streamHandlerFactory);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    streamHandlerFactory.setParentFactory(uRLStreamHandlerFactory);
                    uRLStreamHandlerFactory = streamHandlerFactory;
                }
            }
            field.set(null, null);
            Framework.resetURLStreamHandlers();
            URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallURLStreamHandlerFactory() {
        try {
            Object object;
            Field field;
            Class<?> clazz;
            Class<?> clazz2 = class$9;
            if (clazz2 == null) {
                try {
                    clazz2 = class$9 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$10) == null) {
                try {
                    clazz = class$10 = Class.forName("java.net.URLStreamHandlerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((field = Framework.getStaticField(clazz2, clazz)) == null) {
                return;
            }
            Object object2 = object = Framework.getURLStreamHandlerFactoryLock();
            synchronized (object2) {
                URLStreamHandlerFactory uRLStreamHandlerFactory = (URLStreamHandlerFactory)field.get(null);
                if (uRLStreamHandlerFactory == this.streamHandlerFactory) {
                    uRLStreamHandlerFactory = (URLStreamHandlerFactory)this.streamHandlerFactory.designateSuccessor();
                } else {
                    Class<?> clazz3 = uRLStreamHandlerFactory.getClass();
                    Class[] classArray = new Class[1];
                    Class<?> clazz4 = class$7;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$7 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz4;
                    Method method = clazz3.getMethod("unregister", classArray);
                    method.invoke((Object)uRLStreamHandlerFactory, this.streamHandlerFactory);
                }
                field.set(null, null);
                Framework.resetURLStreamHandlers();
                if (uRLStreamHandlerFactory != null) {
                    URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
                }
            }
        }
        catch (Exception exception) {}
    }

    private static Object getURLStreamHandlerFactoryLock() throws IllegalAccessException {
        Object object;
        try {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getDeclaredField("streamHandlerLock");
            field.setAccessible(true);
            object = field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = clazz;
        }
        return object;
    }

    private static void resetURLStreamHandlers() throws IllegalAccessException {
        Hashtable hashtable;
        Field field;
        Class<?> clazz;
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$8) == null) {
            try {
                clazz = class$8 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((field = Framework.getStaticField(clazz2, clazz)) != null && (hashtable = (Hashtable)field.get(null)) != null) {
            hashtable.clear();
        }
    }

    static class GetDataFileAction
    implements PrivilegedAction {
        private AbstractBundle bundle;
        private String filename;

        public GetDataFileAction(AbstractBundle abstractBundle, String string) {
            this.bundle = abstractBundle;
            this.filename = string;
        }

        public Object run() {
            return this.bundle.getBundleData().getDataFile(this.filename);
        }
    }
}

