/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceUse;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    protected ServiceReferenceImpl reference;
    protected Framework framework;
    protected BundleContextImpl context;
    protected AbstractBundle bundle;
    protected ArrayList contextsUsing;
    protected String[] clazzes;
    protected Object service;
    protected Properties properties;
    protected long serviceid;
    protected int serviceranking;
    protected Object registrationLock = new Object();
    protected int state = 0;
    public static final int REGISTERED = 0;
    public static final int UNREGISTERING = 1;
    public static final int UNREGISTERED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRegistrationImpl(BundleContextImpl bundleContextImpl, String[] stringArray, Object object, Dictionary dictionary) {
        this.context = bundleContextImpl;
        this.bundle = bundleContextImpl.bundle;
        this.framework = bundleContextImpl.framework;
        this.clazzes = stringArray;
        this.service = object;
        this.contextsUsing = null;
        this.reference = new ServiceReferenceImpl(this);
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            this.serviceid = this.framework.getNextServiceId();
            this.properties = this.createProperties(dictionary);
            if (Debug.DEBUG_SERVICES) {
                Debug.println("registerService[" + this.bundle + "](" + this + ")");
            }
            this.framework.serviceRegistry.publishService(bundleContextImpl, this);
        }
        this.framework.publishServiceEvent(1, this.reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        BundleContextImpl[] bundleContextImplArray;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("unregisterService[" + this.bundle + "](" + this + ")");
            }
            bundleContextImplArray = this.framework.serviceRegistry;
            synchronized (this.framework.serviceRegistry) {
                this.framework.serviceRegistry.unpublishService(this.context, this);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                this.state = 1;
            }
        }
        {
            this.framework.publishServiceEvent(4, this.reference);
            this.service = null;
            this.state = 2;
            int n = 0;
            bundleContextImplArray = null;
            Object object2 = this.registrationLock;
            synchronized (object2) {
                if (this.contextsUsing != null && (n = this.contextsUsing.size()) > 0) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("unregisterService: releasing users");
                    }
                    bundleContextImplArray = this.contextsUsing.toArray(new BundleContextImpl[n]);
                }
            }
            int n2 = 0;
            while (n2 < n) {
                this.releaseService(bundleContextImplArray[n2]);
                ++n2;
            }
            this.contextsUsing = null;
            this.reference = null;
            this.context = null;
            return;
        }
    }

    public ServiceReference getReference() {
        if (this.reference == null) {
            throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
        }
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary dictionary) {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            this.properties = this.createProperties(dictionary);
        }
        this.framework.publishServiceEvent(2, this.reference);
    }

    protected Properties createProperties(Dictionary dictionary) {
        Properties properties = new Properties(dictionary);
        properties.set("objectClass", this.clazzes, true);
        properties.set("service.id", new Long(this.serviceid), true);
        properties.setReadOnly();
        Object object = properties.getProperty("service.ranking");
        this.serviceranking = object instanceof Integer ? (Integer)object : 0;
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getProperty(String string) {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getProperty(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getPropertyKeys() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getPropertyKeys();
        }
    }

    protected AbstractBundle getBundle() {
        if (this.reference == null) {
            return null;
        }
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getService(BundleContextImpl bundleContextImpl) {
        Object object = this.registrationLock;
        synchronized (object) {
            Hashtable hashtable;
            ServiceUse serviceUse;
            block8: {
                if (this.state != 2) break block8;
                return null;
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getService[" + bundleContextImpl.bundle + "](" + this + ")");
            }
            if ((serviceUse = (ServiceUse)(hashtable = bundleContextImpl.servicesInUse).get(this.reference)) == null) {
                serviceUse = new ServiceUse(bundleContextImpl, this);
                Object object2 = serviceUse.getService();
                if (object2 != null) {
                    hashtable.put(this.reference, serviceUse);
                    if (this.contextsUsing == null) {
                        this.contextsUsing = new ArrayList(10);
                    }
                    this.contextsUsing.add(bundleContextImpl);
                }
                return object2;
            }
            return serviceUse.getService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ungetService(BundleContextImpl bundleContextImpl) {
        Object object = this.registrationLock;
        synchronized (object) {
            block8: {
                ServiceUse serviceUse;
                Object object2;
                block7: {
                    if (this.state != 2) break block7;
                    return false;
                }
                if (Debug.DEBUG_SERVICES) {
                    object2 = bundleContextImpl.bundle == null ? "" : bundleContextImpl.bundle.toString();
                    Debug.println("ungetService[" + (String)object2 + "](" + this + ")");
                }
                if ((object2 = bundleContextImpl.servicesInUse) == null || (serviceUse = (ServiceUse)((Hashtable)object2).get(this.reference)) == null) break block8;
                if (serviceUse.ungetService()) {
                    ((Hashtable)object2).remove(this.reference);
                    this.contextsUsing.remove(bundleContextImpl);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseService(BundleContextImpl bundleContextImpl) {
        Object object = this.registrationLock;
        synchronized (object) {
            ServiceUse serviceUse;
            Object object2;
            if (this.reference == null) {
                return;
            }
            if (Debug.DEBUG_SERVICES) {
                object2 = bundleContextImpl.bundle == null ? "" : bundleContextImpl.bundle.toString();
                Debug.println("releaseService[" + (String)object2 + "](" + this + ")");
            }
            if ((object2 = bundleContextImpl.servicesInUse) != null && (serviceUse = (ServiceUse)((Hashtable)object2).remove(this.reference)) != null) {
                serviceUse.releaseService();
                if (this.contextsUsing != null) {
                    this.contextsUsing.remove(bundleContextImpl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getUsingBundles() {
        Object object = this.registrationLock;
        synchronized (object) {
            int n;
            block9: {
                block8: {
                    block7: {
                        if (this.state != 2) break block7;
                        return null;
                    }
                    if (this.contextsUsing != null) break block8;
                    return null;
                }
                n = this.contextsUsing.size();
                if (n != 0) break block9;
                return null;
            }
            AbstractBundle[] abstractBundleArray = new AbstractBundle[n];
            int n2 = 0;
            while (n2 < n) {
                abstractBundleArray[n2] = ((BundleContextImpl)this.contextsUsing.get((int)n2)).bundle;
                ++n2;
            }
            return abstractBundleArray;
        }
    }

    public String toString() {
        String[] stringArray = this.clazzes;
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(50 * n);
        stringBuffer.append('{');
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        stringBuffer.append("}=");
        stringBuffer.append(this.properties);
        return ((Object)stringBuffer).toString();
    }

    static class Properties
    extends Headers {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties(int n, Dictionary dictionary) {
            super(n);
            if (dictionary != null) {
                Dictionary dictionary2 = dictionary;
                synchronized (dictionary2) {
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        if (!(k instanceof String)) continue;
                        String string = (String)k;
                        this.setProperty(string, dictionary.get(string));
                    }
                }
            }
        }

        protected Properties(Dictionary dictionary) {
            this(dictionary == null ? 2 : dictionary.size() + 2, dictionary);
        }

        protected Object getProperty(String string) {
            return Properties.cloneValue(this.get(string));
        }

        protected synchronized String[] getPropertyKeys() {
            int n = this.size();
            String[] stringArray = new String[n];
            Enumeration enumeration = this.keys();
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
            return stringArray;
        }

        protected synchronized Object setProperty(String string, Object object) {
            return this.set(string, Properties.cloneValue(object));
        }

        protected static Object cloneValue(Object object) {
            block10: {
                if (object == null) {
                    return null;
                }
                if (object instanceof String) {
                    return object;
                }
                if (object instanceof Number) {
                    return object;
                }
                if (object instanceof Character) {
                    return object;
                }
                if (object instanceof Boolean) {
                    return object;
                }
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    Class<?> clazz2 = clazz.getComponentType();
                    int n = Array.getLength(object);
                    Object object2 = Array.newInstance(clazz2, n);
                    System.arraycopy(object, 0, object2, 0, n);
                    return object2;
                }
                try {
                    return clazz.getMethod("clone", null).invoke(object, null);
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    if (object instanceof Vector) {
                        return ((Vector)object).clone();
                    }
                    if (!(object instanceof Hashtable)) break block10;
                    return ((Hashtable)object).clone();
                }
            }
            return object;
        }

        public synchronized String toString() {
            String[] stringArray = this.getPropertyKeys();
            int n = stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(20 * n);
            stringBuffer.append('{');
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                String string = stringArray[n3];
                if (!string.equals("objectClass")) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append('=');
                    Object object = this.get(string);
                    if (object.getClass().isArray()) {
                        stringBuffer.append('[');
                        int n4 = Array.getLength(object);
                        int n5 = 0;
                        while (n5 < n4) {
                            if (n5 > 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(Array.get(object, n5));
                            ++n5;
                        }
                        stringBuffer.append(']');
                    } else {
                        stringBuffer.append(object);
                    }
                    ++n2;
                }
                ++n3;
            }
            stringBuffer.append('}');
            return ((Object)stringBuffer).toString();
        }
    }
}

