/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationActivator
implements BundleActivator,
IBundleGroupProvider,
IConfigurationConstants {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String INSTALL_LOCATION = "osgi.installLocation";
    public static final String LAST_CONFIG_STAMP = "last.config.stamp";
    public static final String NAME_SPACE = "org.eclipse.update";
    public static final String UPDATE_PREFIX = "update@";
    private static final String INITIAL_PREFIX = "initial@";
    public static String OPTION_DEBUG = String.valueOf(PI_CONFIGURATOR) + "/debug";
    public static boolean DEBUG = false;
    private static BundleContext context;
    private ServiceTracker platformTracker;
    private ServiceRegistration configurationFactorySR;
    private ServiceRegistration bundleGroupProviderSR;
    private PlatformConfiguration configuration;
    private Location configLocation;
    private long lastTimeStamp;
    private long lastStateTimeStamp;
    private static ConfigurationActivator configurator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public ConfigurationActivator() {
        configurator = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.loadOptions();
        this.acquireFrameworkLogService();
        this.initialize();
        if (this.canRunWithCachedData()) {
            Utils.debug("Running with cached data");
            this.registerBundleGroupProvider();
            return;
        }
        Utils.debug("Starting update configurator...");
        this.installBundles();
        this.registerBundleGroupProvider();
    }

    private void registerBundleGroupProvider() {
        BundleContext bundleContext = ConfigurationActivator.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IBundleGroupProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundleGroupProviderSR = bundleContext.registerService(clazz.getName(), (Object)this, null);
    }

    /*
     * Exception decompiling
     */
    private void initialize() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 294->298)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            PlatformConfiguration.shutdown();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.configurationFactorySR.unregister();
        if (this.bundleGroupProviderSR != null) {
            this.bundleGroupProviderSR.unregister();
        }
        Utils.shutdown();
    }

    public boolean installBundles() {
        Utils.debug("Installing bundles...");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference serviceReference = context.getServiceReference(clazz.getName());
        int n = 4;
        String string = context.getProperty("osgi.bundles.defaultStartLevel");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 4;
            }
        }
        if (n < 1) {
            n = 4;
        }
        StartLevel startLevel = null;
        if (serviceReference != null) {
            startLevel = (StartLevel)context.getService(serviceReference);
        }
        try {
            URL uRL;
            Bundle[] bundleArray = context.getBundles();
            URL[] uRLArray = this.configuration.getPluginPath();
            List list = this.getUnresolvedBundles();
            Bundle[] bundleArray2 = this.getBundlesToUninstall(bundleArray, uRLArray);
            int n2 = 0;
            while (n2 < bundleArray2.length) {
                try {
                    if (DEBUG) {
                        Utils.debug("Uninstalling " + bundleArray2[n2].getLocation());
                    }
                    list.add(bundleArray2[n2]);
                    bundleArray2[n2].uninstall();
                }
                catch (Exception exception) {
                    Utils.log(NLS.bind((String)Messages.ConfigurationActivator_uninstallBundle, (Object[])new String[]{bundleArray2[n2].getLocation()}));
                }
                ++n2;
            }
            String[] stringArray = this.getBundlesToInstall(bundleArray, uRLArray);
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>(stringArray.length);
            int n3 = 0;
            while (n3 < stringArray.length) {
                block24: {
                    try {
                        if (DEBUG) {
                            Utils.debug("Installing " + stringArray[n3]);
                        }
                        uRL = new URL("reference:file:" + stringArray[n3]);
                        Bundle bundle = context.installBundle(UPDATE_PREFIX + stringArray[n3], uRL.openStream());
                        list.add(bundle);
                        if (startLevel != null) {
                            startLevel.setBundleStartLevel(bundle, n);
                        }
                        if (ConfigurationActivator.hasLazyActivationPolicy(bundle)) {
                            arrayList.add(bundle);
                        }
                    }
                    catch (Exception exception) {
                        if (Utils.isAutomaticallyStartedBundle(stringArray[n3])) break block24;
                        Utils.log(String.valueOf(NLS.bind((String)Messages.ConfigurationActivator_installBundle, (Object[])new String[]{stringArray[n3]})) + "   " + exception.getMessage());
                    }
                }
                ++n3;
            }
            context.ungetService(serviceReference);
            this.removeInitialBundles(list, bundleArray);
            this.refreshPackages(list.toArray(new Bundle[list.size()]));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                uRL = (Bundle)iterator.next();
                try {
                    uRL.start(2);
                }
                catch (BundleException bundleException) {
                    if ((uRL.getState() & 4) == 0) continue;
                    Utils.log(String.valueOf(NLS.bind((String)Messages.ConfigurationActivator_installBundle, (Object[])new String[]{uRL.getLocation()})) + "   " + bundleException.getMessage());
                }
            }
            this.writePlatformConfigurationTimeStamp();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasLazyActivationPolicy(Bundle bundle) {
        block9: {
            ManifestElement[] manifestElementArray;
            block10: {
                Dictionary dictionary;
                block8: {
                    dictionary = bundle.getHeaders("");
                    String string = (String)dictionary.get("Fragment-Host");
                    if (string != null) {
                        return false;
                    }
                    String string2 = (String)dictionary.get("Bundle-ActivationPolicy");
                    try {
                        if (string2 == null) break block8;
                        ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader((String)"Bundle-ActivationPolicy", (String)string2);
                        if (manifestElementArray2 != null && manifestElementArray2.length > 0 && "lazy".equals(manifestElementArray2[0].getValue())) {
                            return true;
                        }
                        break block9;
                    }
                    catch (BundleException bundleException) {}
                }
                String string = (String)dictionary.get("Eclipse-LazyStart");
                if (string == null) {
                    string = (String)dictionary.get("Eclipse-AutoStart");
                }
                if ((manifestElementArray = ManifestElement.parseHeader((String)"Eclipse-LazyStart", (String)string)) == null || manifestElementArray.length <= 0) break block9;
                if (!"true".equals(manifestElementArray[0].getValue())) break block10;
                return true;
            }
            if (manifestElementArray[0].getDirective("exceptions") != null) {
                return true;
            }
        }
        return false;
    }

    private void removeInitialBundles(List list, Bundle[] bundleArray) {
        String[] stringArray = this.getInitialSymbolicNames(bundleArray);
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            Bundle bundle = (Bundle)iterator.next();
            String string = bundle.getSymbolicName();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    iterator.remove();
                    continue block0;
                }
                ++n;
            }
        }
    }

    private String[] getInitialSymbolicNames(Bundle[] bundleArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < bundleArray.length) {
            String string;
            Bundle bundle = bundleArray[n];
            if (bundle.getLocation().startsWith(INITIAL_PREFIX) && (string = bundle.getSymbolicName()) != null) {
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private List getUnresolvedBundles() {
        Bundle[] bundleArray = context.getBundles();
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        int n = 0;
        while (n < bundleArray.length) {
            if (bundleArray[n].getState() == 2) {
                arrayList.add(bundleArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    private String[] getBundlesToInstall(Bundle[] bundleArray, URL[] uRLArray) {
        HashSet<String> hashSet = new HashSet<String>(bundleArray.length);
        int n = UPDATE_PREFIX.length();
        int n2 = 0;
        while (n2 < bundleArray.length) {
            String string;
            if (bundleArray[n2].getBundleId() != 0L && (string = bundleArray[n2].getLocation()).startsWith(UPDATE_PREFIX)) {
                string = string.substring(n);
                hashSet.add(string);
                if (Utils.isWindows) {
                    hashSet.add(string.toLowerCase());
                }
            }
            ++n2;
        }
        ArrayList<String> arrayList = new ArrayList<String>(uRLArray.length);
        int n3 = 0;
        while (n3 < uRLArray.length) {
            String string = Utils.makeRelative(Utils.getInstallURL(), uRLArray[n3]).getFile();
            if (!(hashSet.contains(string) || Utils.isWindows && hashSet.contains(string.toLowerCase()))) {
                arrayList.add(string);
            }
            ++n3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Bundle[] getBundlesToUninstall(Bundle[] bundleArray, URL[] uRLArray) {
        HashSet<String> hashSet = new HashSet<String>(uRLArray.length);
        int n = 0;
        while (n < uRLArray.length) {
            String string = Utils.makeRelative(Utils.getInstallURL(), uRLArray[n]).getFile();
            hashSet.add(string);
            if (Utils.isWindows) {
                hashSet.add(string.toLowerCase());
            }
            ++n;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        int n2 = UPDATE_PREFIX.length();
        int n3 = 0;
        while (n3 < bundleArray.length) {
            String string;
            if (!(bundleArray[n3].getBundleId() == 0L || !(string = bundleArray[n3].getLocation()).startsWith(UPDATE_PREFIX) || hashSet.contains(string = string.substring(n2)) || Utils.isWindows && hashSet.contains(string.toLowerCase()))) {
                arrayList.add(bundleArray[n3]);
            }
            ++n3;
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    private PlatformConfiguration getPlatformConfiguration(URL uRL, Location location) {
        block3: {
            try {
                PlatformConfiguration.startup(uRL, location);
            }
            catch (Exception exception) {
                if (this.platformTracker == null) break block3;
                String string = exception.getMessage();
                if (string == null) {
                    string = "";
                }
                Utils.log(Utils.newStatus(string, exception));
            }
        }
        return PlatformConfiguration.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshPackages(Bundle[] bundleArray) {
        if (bundleArray.length == 0) {
            return;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$3 = clazz2;
        }
        ServiceReference serviceReference = context.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (serviceReference != null && (packageAdmin = (PackageAdmin)context.getService(serviceReference)) == null) {
            return;
        }
        final boolean[] blArray = new boolean[1];
        FrameworkListener frameworkListener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                if (frameworkEvent.getType() != 4) return;
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = true;
                    blArray.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        context.addFrameworkListener(frameworkListener);
        packageAdmin.refreshPackages(bundleArray);
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            while (true) {
                if (blArray[0]) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    break;
                }
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            context.removeFrameworkListener(frameworkListener);
            context.ungetService(serviceReference);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void writePlatformConfigurationTimeStamp() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 162->166)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadOptions() {
        ServiceReference serviceReference;
        DebugOptions debugOptions = null;
        Class<?> clazz = class$4;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$4 = clazz2;
        }
        if ((serviceReference = context.getServiceReference(clazz.getName())) != null) {
            debugOptions = (DebugOptions)context.getService(serviceReference);
        }
        if (debugOptions == null) {
            return;
        }
        try {
            DEBUG = debugOptions.getBooleanOption(OPTION_DEBUG, false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        context.ungetService(serviceReference);
    }

    private boolean canRunWithCachedData() {
        return !"true".equals(context.getProperty("osgi.checkConfiguration")) && this.lastTimeStamp == this.configuration.getChangeStamp() && this.lastStateTimeStamp == Utils.getStateStamp();
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public String getName() {
        return Messages.BundleGroupProvider;
    }

    public IBundleGroup[] getBundleGroups() {
        if (this.configuration == null) {
            return new IBundleGroup[0];
        }
        IPlatformConfiguration.IFeatureEntry[] iFeatureEntryArray = this.configuration.getConfiguredFeatureEntries();
        ArrayList<IPlatformConfiguration.IFeatureEntry> arrayList = new ArrayList<IPlatformConfiguration.IFeatureEntry>(iFeatureEntryArray.length);
        int n = 0;
        while (n < iFeatureEntryArray.length) {
            if (iFeatureEntryArray[n] instanceof FeatureEntry && ((FeatureEntry)iFeatureEntryArray[n]).hasBranding()) {
                arrayList.add(iFeatureEntryArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IBundleGroup[arrayList.size()]);
    }

    public static void setConfigurator(ConfigurationActivator configurationActivator) {
        configurator = configurationActivator;
    }

    public static ConfigurationActivator getConfigurator() {
        return configurator;
    }

    private void acquireFrameworkLogService() throws Exception {
        ServiceReference serviceReference;
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((serviceReference = context.getServiceReference(clazz.getName())) == null) {
            return;
        }
        Utils.log = (FrameworkLog)context.getService(serviceReference);
    }
}

