/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class MultiPageDialog
extends Dialog {
    private int DIALOG_STYLE = 0;
    private static int TITLE_HEIGHT = 26;
    private static int MENU_HEIGHT = 26;
    private static final int INTERNAL_SHELL_LENGTH = 2;
    private MultiPageShell[] mpShells = new MultiPageShell[2];
    private int mpsIndex = 0;
    private MultiPageComposite mpc;
    private Display display;
    private FormLayout layout;
    private Rectangle bound;
    private MultiPageListener mpl;
    private static boolean isInitCallBack = false;

    public MultiPageDialog(Shell parent) {
        this(parent, 0);
    }

    public MultiPageDialog(Shell parent, int style) {
        super(parent, style);
        this.checkDialogStyle(style);
        this.display = parent.getDisplay();
        int current = this.getCurrentInternalShellIndex();
        int next = this.getNextInternalShellIndex();
        this.mpShells[current] = new MultiPageShell(parent, this.DIALOG_STYLE);
        this.mpShells[next] = new MultiPageShell(parent, this.DIALOG_STYLE);
        this.mpc = new MultiPageComposite(parent, this.mpShells[current], 0);
        this.layout = new FormLayout();
        this.mpShells[current].setLayout(this.layout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.mpc.setLayoutData(fd);
        int x = 0;
        int y = 0;
        int w = this.display.getBounds().width;
        int h = this.display.getBounds().height;
        if (SWT.getPlatform().equals("win32")) {
            x = (w /= 2) / 2;
            y = (h /= 2) / 2;
        } else if (SWT.getPlatform().equals("wm2003")) {
            y = TITLE_HEIGHT;
            h -= TITLE_HEIGHT + MENU_HEIGHT;
        }
        this.bound = new Rectangle(x, y, w, h);
        this.mpShells[current].setBounds(this.bound);
        this.mpl = new MultiPageListener();
        this.mpc.addSelectionListener(this.mpl);
        MultiPageDialog.initCallBack(this.display);
        final MultiPageDialog mpd = this;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (mpd != null) {
                    mpd.dispose();
                }
            }
        });
    }

    private MultiPageShell getCurrentInternalShell() {
        return this.mpShells[this.mpsIndex];
    }

    private int getCurrentInternalShellIndex() {
        return this.mpsIndex;
    }

    private int getNextInternalShellIndex() {
        return (this.mpsIndex + 1) % 2;
    }

    private void checkDialogStyle(int style) {
        if ((style & 0x20000) == 131072 && (style | 0x20000) != 131072) {
            SWT.error(5);
        }
        if ((style & 0x10000) == 65536 && (style | 0x10000) != 65536) {
            SWT.error(5);
        }
        if ((style & 0x8000) == 32768 && (style | 0x8000) != 32768) {
            SWT.error(5);
        }
        this.DIALOG_STYLE = (style & 0x20000) != 0 || (style & 0x10000) != 0 ? 67696 : 133232;
    }

    public void addSelectionListener(SelectionListener listener) {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.mpl.addSelectionListener(listener);
    }

    public void close() {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public Composite createPage(String title, Image icon) {
        return this.mpc.createPage(title, icon);
    }

    public void deletePage(int index) {
        this.mpc.deletePage(index);
    }

    public void dispose() {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (this.mpc != null && !this.mpc.isDisposed()) {
            this.mpc.dispose();
        }
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
        int current = this.getCurrentInternalShellIndex();
        this.mpShells[current] = null;
        this.layout = null;
        this.bound = null;
    }

    public Composite getPage(int index) {
        return this.mpc.getPage(index);
    }

    public int getPageCount() {
        return this.mpc.getPageCount();
    }

    public String getTitle(int index) {
        return this.mpc.getTitle(index);
    }

    public int getSelectionIndex() {
        return this.mpc.getSelectionIndex();
    }

    public void open() {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        int next = this.getNextInternalShellIndex();
        int current = this.getCurrentInternalShellIndex();
        if (this.mpShells[next] == null) {
            this.mpShells[next] = new MultiPageShell(super.getParent(), this.DIALOG_STYLE);
        }
        shell.setNextShell(this.mpShells[next]);
        shell.setLayout(this.layout);
        shell.setText(this.getText());
        shell.setBounds(this.bound);
        final Rectangle tmpBound = this.bound;
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Rectangle r = ((Shell)e.widget).getBounds();
                tmpBound.x = r.x;
                tmpBound.y = r.y;
                tmpBound.width = r.width;
                tmpBound.height = r.height;
            }
        });
        shell.open();
        if (this.mpc.getPageCount() > 0) {
            this.mpc.setSelection(this.mpc.getSelectionIndex());
        }
        while (!shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.mpShells[current] = null;
        this.mpsIndex = next;
    }

    public void removeSelectionListener(SelectionListener listener) {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.mpl.removeSelectionListener(listener);
    }

    public void setSelection(int index) {
        this.mpc.setSelection(index);
    }

    public void setImage(int index, Image icon) {
        this.mpc.setImage(index, icon);
    }

    public void setTitle(int index, String title) {
        this.mpc.setTitle(index, title);
    }

    private static synchronized void initCallBack(Display display) {
        if (!isInitCallBack) {
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(display.internal_handle, 32, "org/eclipse/ercp/swt/mobile/MultiPageDialog$MultiPageComposite", "Callback");
            isInitCallBack = true;
        }
    }

    private class MultiPageListener
    implements SelectionListener {
        private Vector listeners = new Vector();

        private MultiPageListener() {
        }

        public void addSelectionListener(SelectionListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        public void removeSelectionListener(SelectionListener listener) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }

        public void widgetSelected(SelectionEvent se) {
            if (!(se.widget instanceof MultiPageComposite)) {
                return;
            }
            MultiPageComposite mpc = (MultiPageComposite)se.widget;
            if (mpc == null) {
                return;
            }
            Composite composite = mpc.getPage(mpc.getSelectionIndex());
            if (composite == null) {
                return;
            }
            Event e = new Event();
            e.display = composite.getDisplay();
            e.x = composite.getLocation().x;
            e.y = composite.getLocation().y;
            e.width = composite.getSize().x;
            e.height = composite.getSize().y;
            e.type = 13;
            e.widget = composite;
            e.time = se.time;
            SelectionEvent nse = new SelectionEvent(e);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                SelectionListener listener = (SelectionListener)enumeration.nextElement();
                if (listener == null) continue;
                listener.widgetSelected(nse);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class CompositePage {
        public Composite composite;
        public String title;
        public int imageHandle;

        public CompositePage(Composite composite, String title) {
            this(composite, title, null);
        }

        public CompositePage(Composite composite, String title, Image icon) {
            this.composite = composite;
            this.title = title;
            this.setImage(icon);
        }

        public void setImage(Image icon) {
            this.imageHandle = icon == null ? 0 : icon.internal_handle;
        }
    }

    private class MultiPageComposite
    extends Composite
    implements Listener {
        private Shell parent;
        private Vector pages = new Vector();
        private int selected = 0;

        public MultiPageComposite(Shell realparent, Composite parent, int style) {
            super(parent, 0);
            this.parent = realparent;
            parent.getDisplay().addFilter(15, this);
        }

        protected boolean traverse(Event event) {
            if (this.isDisposed()) {
                return false;
            }
            switch (event.keyCode) {
                case 0x1000001: {
                    Composite page = this.getPage(this.getSelectionIndex());
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    Control control = this.getLastTabControl(page);
                    if (control == null) {
                        return false;
                    }
                    return control.setFocus();
                }
                case 0x1000002: {
                    Composite page = this.getPage(this.getSelectionIndex());
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    Control control = this.getFirstTabControl(page);
                    if (control == null) {
                        return false;
                    }
                    return control.setFocus();
                }
                case 0x1000004: {
                    if (this.getSelectionIndex() + 1 >= this.getPageCount()) {
                        return false;
                    }
                    Composite page = this.getPage(this.getSelectionIndex() + 1);
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    return page.setFocus();
                }
                case 0x1000003: {
                    if (this.getSelectionIndex() - 1 < 0) {
                        return false;
                    }
                    Composite page = this.getPage(this.getSelectionIndex() - 1);
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    return page.setFocus();
                }
            }
            return super.traverse(event);
        }

        protected void internal_createHandle(int index) {
            this.internal_handle = OS.MultiPageComposite_New(this.internal_parent.internal_handle, 0);
        }

        public void addSelectionListener(SelectionListener listener) {
            this.checkWidget();
            if (listener == null) {
                SWT.error(4);
            }
            TypedListener typedListener = new TypedListener(listener);
            this.addListener(13, typedListener);
            this.addListener(14, typedListener);
        }

        public synchronized Composite createPage(String title, Image icon) {
            this.checkWidget();
            if (title == null) {
                SWT.error(4);
            }
            int imageHandle = 0;
            if (icon != null) {
                imageHandle = icon.internal_handle;
            }
            Composite composite = new Composite(this, 0);
            boolean success = OS.MultiPageComposite_AddPage(this.internal_handle, composite.internal_handle, title, imageHandle);
            if (success) {
                this.pages.add(new CompositePage(composite, title, icon));
            } else {
                composite.dispose();
                composite = null;
                SWT.error(14);
            }
            MultiPageComposite mpc = this;
            composite.getDisplay().addFilter(31, new Listener(this, mpc){
                private final /* synthetic */ MultiPageComposite val$mpc;
                private final /* synthetic */ MultiPageComposite this$1;
                {
                    this.this$1 = this$1;
                    this.val$mpc = val$mpc;
                }

                public void handleEvent(Event event) {
                    if (this.val$mpc == null || this.val$mpc.isDisposed()) {
                        return;
                    }
                    Composite page = this.val$mpc.getPage(this.val$mpc.getSelectionIndex());
                    if (page == null || page.isDisposed()) {
                        return;
                    }
                    Control[] childs = page.getChildren();
                    if (childs == null || childs.length == 0) {
                        return;
                    }
                    switch (event.detail) {
                        case 64: {
                            Control control = this.this$1.getLastTabControl(page);
                            if (!this.this$1.isChild((Control)event.widget, control) || !control.allowTraverseByArrowKey(event)) break;
                            event.doit = false;
                            this.val$mpc.forceFocus();
                            break;
                        }
                        case 32: {
                            Control control = this.this$1.getFirstTabControl(page);
                            if (!this.this$1.isChild((Control)event.widget, control) || !control.allowTraverseByArrowKey(event)) break;
                            event.doit = false;
                            this.val$mpc.forceFocus();
                        }
                    }
                }
            });
            return composite;
        }

        Control getFirstTabControl(Composite composite) {
            Control[] childs = composite.getTabList();
            if (childs == null || childs.length == 0) {
                return null;
            }
            for (int i = 0; i < childs.length; ++i) {
                Control child;
                if (childs[i] instanceof Composite && (child = this.getFirstTabControl((Composite)childs[i])) != null) {
                    return child;
                }
                if (!childs[i].isVisible() || childs[i] instanceof Label) continue;
                return childs[i];
            }
            return null;
        }

        Control getLastTabControl(Composite composite) {
            Control[] childs = composite.getTabList();
            if (childs == null || childs.length == 0) {
                return null;
            }
            for (int i = childs.length - 1; i >= 0; --i) {
                Control child;
                if (childs[i] instanceof Composite && (child = this.getLastTabControl((Composite)childs[i])) != null) {
                    return child;
                }
                if (!childs[i].isVisible() || childs[i] instanceof Label) continue;
                return childs[i];
            }
            return null;
        }

        boolean isChild(Control parent, Control child) {
            if (parent == null || child == null) {
                return false;
            }
            if (parent == child) {
                return true;
            }
            for (Composite tmp = child.getParent(); tmp != null; tmp = tmp.getParent()) {
                if (tmp != parent) continue;
                return true;
            }
            return false;
        }

        public synchronized void deletePage(int index) {
            boolean success;
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_DeletePage(this.internal_handle, index)) {
                CompositePage page = (CompositePage)this.pages.elementAt(index);
                if (page.composite != null && !page.composite.isDisposed()) {
                    page.composite.dispose();
                }
                page.composite = null;
                this.pages.removeElementAt(index);
                if (this.selected >= index && this.selected > 0) {
                    --this.selected;
                    this.setSelection(this.selected);
                } else if (index == 0 && this.pages.size() > 0) {
                    this.setSelection(this.selected);
                }
            }
        }

        public void dispose() {
            this.checkWidget();
            int size = this.pages.size();
            for (int i = 0; i < size; ++i) {
                CompositePage page = (CompositePage)this.pages.elementAt(i);
                if (page == null) continue;
                if (page.composite != null && !page.composite.isDisposed()) {
                    page.composite.dispose();
                }
                page.composite = null;
                Object var3_3 = null;
            }
            this.pages.removeAllElements();
            this.pages = null;
            this.parent.getDisplay().removeFilter(15, this);
            super.dispose();
        }

        public Composite getPage(int index) {
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            return ((CompositePage)this.pages.elementAt((int)index)).composite;
        }

        public int getPageCount() {
            this.checkWidget();
            return this.pages.size();
        }

        public String getTitle(int index) {
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            return ((CompositePage)this.pages.elementAt((int)index)).title;
        }

        public int getSelectionIndex() {
            this.checkWidget();
            return this.selected;
        }

        public void removeSelectionListener(SelectionListener listener) {
            this.checkWidget();
            if (listener == null) {
                SWT.error(4);
            }
            this.removeListener(13, listener);
            this.removeListener(14, listener);
        }

        public void setSelection(int index) {
            CompositePage page;
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if ((page = (CompositePage)this.pages.elementAt(index)) == null) {
                return;
            }
            boolean success = OS.MultiPageComposite_SetSelection(this.internal_handle, index);
            if (success) {
                this.forceFocus();
                this.selected = index;
            }
        }

        public void setImage(int index, Image icon) {
            boolean success;
            this.checkWidget();
            if (icon == null) {
                SWT.error(4);
            }
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_SetImage(this.internal_handle, index, icon.internal_handle)) {
                CompositePage page = (CompositePage)this.pages.elementAt(index);
                page.setImage(icon);
            }
        }

        public void setTitle(int index, String title) {
            boolean success;
            this.checkWidget();
            if (title == null) {
                SWT.error(4);
            }
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_SetTitle(this.internal_handle, index, title)) {
                CompositePage page = (CompositePage)this.pages.elementAt(index);
                page.title = title;
            }
        }

        private void Callback(int index) {
            int size = this.pages.size();
            if (index < 0 || index >= size) {
                return;
            }
            CompositePage page = (CompositePage)this.pages.elementAt(index);
            if (page == null || page.composite == null || page.composite.isDisposed()) {
                return;
            }
            this.selected = index;
            this.internal_sendEvent(13);
        }

        public void handleEvent(Event e) {
            if (e.widget == null || e.widget.isDisposed()) {
                return;
            }
            if (((Control)e.widget).getShell() == null || ((Control)e.widget).getShell().isDisposed()) {
                return;
            }
            if (this == null || this.isDisposed()) {
                return;
            }
            if (this.getParent() != null && !this.getParent().isDisposed() && ((Control)e.widget).getShell() == this.parent) {
                ((Shell)this.getParent()).setActive();
            }
        }
    }

    public class MultiPageShell
    extends Shell {
        MultiPageShell next = null;

        public MultiPageShell(Shell parent, int style) {
            super(parent, style);
        }

        public void setNextShell(MultiPageShell mps) {
            this.next = mps;
        }

        public void dispose() {
            if (this.next != null) {
                Control[] controls = this.getChildren();
                for (int i = 0; i < controls.length; ++i) {
                    controls[i].setParent(this.next);
                }
            }
            super.dispose();
        }
    }
}

