/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    Control[] children;
    int childCount;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getTabList() {
        int index;
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        for (index = 0; index < this.tabList.length; ++index) {
            if (this.tabList[index].isDisposed()) continue;
            ++count;
        }
        if (index == count) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        index = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[index].isDisposed()) continue;
            newList[index++] = this.tabList[i];
        }
        this.tabList = newList;
        return this.tabList;
    }

    protected void checkSubclass() {
    }

    public void internal_removeChild(Control child) {
        if (child == null) {
            SWT.error(5);
        }
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.childCount; ++i) {
            if (!this.children[i].equals(child)) continue;
            System.arraycopy(this.children, i + 1, this.children, i, this.childCount - i - 1);
            --this.childCount;
        }
    }

    void addChild(Control child) {
        if (child == null) {
            SWT.error(5);
        }
        if (this.children == null) {
            this.children = new Control[5];
            this.childCount = 0;
        }
        if (this.childCount == this.children.length) {
            Control[] newChildren = new Control[this.childCount * 2];
            System.arraycopy(this.children, 0, newChildren, 0, this.childCount);
            this.children = newChildren;
        }
        this.children[this.childCount++] = child;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    Control[] computeTabList() {
        int listCount;
        Control[] list;
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        if (this.tabList != null) {
            list = this._getTabList();
            listCount = list.length;
        } else {
            list = this.children;
            listCount = this.childCount;
        }
        for (int i = 0; i < listCount; ++i) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length == 0) continue;
            Control[] newResult = new Control[result.length + childList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(childList, 0, newResult, result.length, childList.length);
            result = newResult;
        }
        return result;
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = OS.Composite_New(this.internal_parent.internal_handle, this.internal_getNativeStyle());
    }

    protected int internal_getNativeStyle() {
        int nativeStyle = super.internal_getNativeStyle();
        if ((this.internal_style & 0x40000) == 262144) {
            nativeStyle |= 0x40000;
        }
        if ((this.internal_style & 0x80000) == 524288) {
            nativeStyle |= 0x100000;
        }
        if ((this.internal_style & 0x200000) == 0x200000) {
            nativeStyle |= 0x80000;
        }
        if ((this.internal_style & 0x100000) == 0x100000) {
            nativeStyle |= 0x200000;
        }
        return nativeStyle;
    }

    public Control[] getChildren() {
        this.checkWidget();
        Control[] childrenCopy = new Control[this.childCount];
        if (this.childCount > 0) {
            System.arraycopy(this.children, 0, childrenCopy, 0, this.childCount);
        }
        return childrenCopy;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            for (int i = 0; i < this.childCount; ++i) {
                if (!this.children[i].isTabGroup()) continue;
                ++count;
            }
            tabList = new Control[count];
            int index = 0;
            for (int i = 0; i < this.childCount; ++i) {
                if (!this.children[i].isTabGroup()) continue;
                tabList[index++] = this.children[i];
            }
        }
        return tabList;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2) || this.hooks(31);
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        if (this.childCount > 0) {
            this.layout.layout(this, changed);
        }
    }

    Point minimumSize() {
        int width = 0;
        int height = 0;
        for (int i = 0; i < this.childCount; ++i) {
            Rectangle rect = this.children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
        }
        return new Point(width, height);
    }

    void releaseWidget() {
        int temp = this.childCount;
        for (int i = 0; i < temp; ++i) {
            Control child = this.children[0];
            if (child.isDisposed()) continue;
            child.releaseWidget();
            child.releaseHandle();
        }
        this.layout = null;
        super.releaseWidget();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.layout != null) {
            this.layout(false);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.layout != null) {
            this.layout(false);
        }
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList == null) {
            Composite.error(4);
        }
        for (int i = 0; i < tabList.length; ++i) {
            Control control = tabList[i];
            if (control == null) {
                Composite.error(5);
            }
            if (control.isDisposed()) {
                Composite.error(5);
            }
            if (control.internal_parent == this) continue;
            Composite.error(32);
        }
        this.tabList = tabList;
    }

    boolean setTabGroupFocus() {
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        if ((this.internal_style & 0x80000) == 0) {
            boolean takeFocus = true;
            if (this.isTrueComposite()) {
                takeFocus = this.hooksKeys();
            }
            if (takeFocus && this.setTabItemFocus()) {
                return true;
            }
        }
        for (int i = 0; i < this.childCount; ++i) {
            Control child = this.children[i];
            if (!child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean setTabItemFocus() {
        if ((this.internal_style & 0x80000) == 0) {
            boolean takeFocus = true;
            if (this.isTrueComposite()) {
                takeFocus = this.hooksKeys();
            }
            if (takeFocus) {
                if (!this.isShowing()) {
                    return false;
                }
                if (this.forceFocus()) {
                    return true;
                }
            }
        }
        return super.setTabItemFocus();
    }

    int traversalCode() {
        if (this.isTrueComposite()) {
            if ((this.internal_style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooks(1) || this.hooks(2)) {
                return 0;
            }
        }
        return super.traversalCode();
    }

    boolean isTrueComposite() {
        return true;
    }

    public boolean setFocus() {
        this.checkWidget();
        if (this.children != null) {
            for (int i = 0; i < this.childCount; ++i) {
                Control child = this.children[i];
                if (!child.getVisible() || !child.setFocus()) continue;
                return true;
            }
        }
        return super.setFocus();
    }

    void clientAreaResized() {
        this.layout();
    }

    public boolean allowTraverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }
}

