/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.InstallHandlerEntryModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.UpdateCore;

public class FeatureModel
extends ModelObject {
    private String featureId;
    private String featureVersion;
    private String label;
    private String localizedLabel;
    private String provider;
    private String localizedProvider;
    private String imageURLString;
    private URL imageURL;
    private String os;
    private String ws;
    private String nl;
    private String arch;
    private boolean primary = false;
    private boolean exclusive = false;
    private String primaryPluginID;
    private String application;
    private String affinity;
    private InstallHandlerEntryModel installHandler;
    private URLEntryModel description;
    private URLEntryModel copyright;
    private URLEntryModel license;
    private URLEntryModel updateSiteInfo;
    private List discoverySiteInfo;
    private List imports;
    private List pluginEntries;
    private List featureIncludes;
    private List nonPluginEntries;
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;

    public boolean equals(Object object) {
        if (!(object instanceof FeatureModel)) {
            return false;
        }
        FeatureModel featureModel = (FeatureModel)((Object)object);
        return this.featureId.toLowerCase().equals(featureModel.getFeatureIdentifier()) && this.featureVersion.toLowerCase().equals(featureModel.getFeatureVersion());
    }

    public String getFeatureIdentifier() {
        return this.featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public String getLabel() {
        this.delayedResolve();
        if (this.localizedLabel != null) {
            return this.localizedLabel;
        }
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public String getProvider() {
        this.delayedResolve();
        if (this.localizedProvider != null) {
            return this.localizedProvider;
        }
        return this.provider;
    }

    public String getProviderNonLocalized() {
        return this.provider;
    }

    public String getImageURLString() {
        this.delayedResolve();
        return this.imageURLString;
    }

    public URL getImageURL() {
        this.delayedResolve();
        return this.imageURL;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getOSArch() {
        return this.arch;
    }

    public String getNL() {
        return this.nl;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public String getApplication() {
        return this.application;
    }

    public String getAffinityFeature() {
        return this.affinity;
    }

    public InstallHandlerEntryModel getInstallHandlerModel() {
        return this.installHandler;
    }

    public URLEntryModel getDescriptionModel() {
        return this.description;
    }

    public URLEntryModel getCopyrightModel() {
        return this.copyright;
    }

    public URLEntryModel getLicenseModel() {
        return this.license;
    }

    public URLEntryModel getUpdateSiteEntryModel() {
        return this.updateSiteInfo;
    }

    public URLEntryModel[] getDiscoverySiteEntryModels() {
        if (this.discoverySiteInfo == null || this.discoverySiteInfo.size() == 0) {
            return new URLEntryModel[0];
        }
        return (URLEntryModel[])this.discoverySiteInfo.toArray(this.arrayTypeFor(this.discoverySiteInfo));
    }

    public ImportModel[] getImportModels() {
        if (this.imports == null || this.imports.size() == 0) {
            return new ImportModel[0];
        }
        return (ImportModel[])this.imports.toArray(this.arrayTypeFor(this.imports));
    }

    public PluginEntryModel[] getPluginEntryModels() {
        if (this.pluginEntries == null || this.pluginEntries.size() == 0) {
            return new PluginEntryModel[0];
        }
        return (PluginEntryModel[])this.pluginEntries.toArray(this.arrayTypeFor(this.pluginEntries));
    }

    public VersionedIdentifier[] getFeatureIncludeVersionedIdentifier() {
        if (this.featureIncludes == null) {
            return new VersionedIdentifier[0];
        }
        Iterator iterator = this.featureIncludes.iterator();
        VersionedIdentifier[] versionedIdentifierArray = new VersionedIdentifier[this.featureIncludes.size()];
        int n = 0;
        while (iterator.hasNext()) {
            IncludedFeatureReferenceModel includedFeatureReferenceModel = (IncludedFeatureReferenceModel)iterator.next();
            versionedIdentifierArray[n] = includedFeatureReferenceModel.getVersionedIdentifier();
            ++n;
        }
        return versionedIdentifierArray;
    }

    public IIncludedFeatureReference[] getFeatureIncluded() {
        if (this.featureIncludes == null || this.featureIncludes.size() == 0) {
            return new IIncludedFeatureReference[0];
        }
        return (IIncludedFeatureReference[])this.featureIncludes.toArray(this.arrayTypeFor(this.featureIncludes));
    }

    public NonPluginEntryModel[] getNonPluginEntryModels() {
        if (this.nonPluginEntries == null || this.nonPluginEntries.size() == 0) {
            return new NonPluginEntryModel[0];
        }
        return (NonPluginEntryModel[])this.nonPluginEntries.toArray(this.arrayTypeFor(this.nonPluginEntries));
    }

    public void setFeatureIdentifier(String string) {
        this.assertIsWriteable();
        this.featureId = string;
    }

    public void setFeatureVersion(String string) {
        this.assertIsWriteable();
        this.featureVersion = string;
    }

    public void setLabel(String string) {
        this.assertIsWriteable();
        this.label = string;
        this.localizedLabel = null;
    }

    public void setProvider(String string) {
        this.assertIsWriteable();
        this.provider = string;
        this.localizedProvider = null;
    }

    public void setImageURLString(String string) {
        this.assertIsWriteable();
        this.imageURLString = string;
        this.imageURL = null;
    }

    public void setOS(String string) {
        this.assertIsWriteable();
        this.os = string;
    }

    public void setWS(String string) {
        this.assertIsWriteable();
        this.ws = string;
    }

    public void setNL(String string) {
        this.assertIsWriteable();
        this.nl = string;
    }

    public void setArch(String string) {
        this.assertIsWriteable();
        this.arch = string;
    }

    public void setPrimary(boolean bl) {
        this.assertIsWriteable();
        this.primary = bl;
    }

    public void setExclusive(boolean bl) {
        this.assertIsWriteable();
        this.exclusive = bl;
    }

    public void setApplication(String string) {
        this.assertIsWriteable();
        this.application = string;
    }

    public void setAffinityFeature(String string) {
        this.assertIsWriteable();
        this.affinity = string;
    }

    public void setInstallHandlerModel(InstallHandlerEntryModel installHandlerEntryModel) {
        this.assertIsWriteable();
        this.installHandler = installHandlerEntryModel;
    }

    public void setDescriptionModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        this.description = uRLEntryModel;
    }

    public void setCopyrightModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        this.copyright = uRLEntryModel;
    }

    public void setLicenseModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        this.license = uRLEntryModel;
    }

    public void setUpdateSiteEntryModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        this.updateSiteInfo = uRLEntryModel;
    }

    public void setDiscoverySiteEntryModels(URLEntryModel[] uRLEntryModelArray) {
        this.assertIsWriteable();
        this.discoverySiteInfo = uRLEntryModelArray == null ? null : new ArrayList<URLEntryModel>(Arrays.asList(uRLEntryModelArray));
    }

    public void setImportModels(ImportModel[] importModelArray) {
        this.assertIsWriteable();
        this.imports = importModelArray == null ? null : new ArrayList<ImportModel>(Arrays.asList(importModelArray));
    }

    public void setPluginEntryModels(PluginEntryModel[] pluginEntryModelArray) {
        this.assertIsWriteable();
        this.pluginEntries = pluginEntryModelArray == null ? null : new ArrayList<PluginEntryModel>(Arrays.asList(pluginEntryModelArray));
    }

    public void setNonPluginEntryModels(NonPluginEntryModel[] nonPluginEntryModelArray) {
        this.assertIsWriteable();
        this.nonPluginEntries = nonPluginEntryModelArray == null ? null : new ArrayList<NonPluginEntryModel>(Arrays.asList(nonPluginEntryModelArray));
    }

    public void addDiscoverySiteEntryModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        if (this.discoverySiteInfo == null) {
            this.discoverySiteInfo = new ArrayList();
        }
        if (!this.discoverySiteInfo.contains((Object)uRLEntryModel)) {
            this.discoverySiteInfo.add(uRLEntryModel);
        }
    }

    public void addImportModel(ImportModel importModel) {
        this.assertIsWriteable();
        if (this.imports == null) {
            this.imports = new ArrayList();
        }
        if (!this.imports.contains((Object)importModel)) {
            this.imports.add(importModel);
        }
    }

    public void addPluginEntryModel(PluginEntryModel pluginEntryModel) {
        this.assertIsWriteable();
        if (this.pluginEntries == null) {
            this.pluginEntries = new ArrayList();
        }
        this.pluginEntries.add(pluginEntryModel);
    }

    public void addIncludedFeatureReferenceModel(IncludedFeatureReferenceModel includedFeatureReferenceModel) {
        this.assertIsWriteable();
        if (this.featureIncludes == null) {
            this.featureIncludes = new ArrayList();
        }
        if (includedFeatureReferenceModel instanceof FeatureReferenceModel) {
            this.featureIncludes.add(includedFeatureReferenceModel);
        } else {
            this.featureIncludes.add(new IncludedFeatureReference((IFeatureReference)includedFeatureReferenceModel));
        }
    }

    public void addNonPluginEntryModel(NonPluginEntryModel nonPluginEntryModel) {
        this.assertIsWriteable();
        if (this.nonPluginEntries == null) {
            this.nonPluginEntries = new ArrayList();
        }
        this.nonPluginEntries.add(nonPluginEntryModel);
    }

    public void removeDiscoverySiteEntryModel(URLEntryModel uRLEntryModel) {
        this.assertIsWriteable();
        if (this.discoverySiteInfo != null) {
            this.discoverySiteInfo.remove((Object)uRLEntryModel);
        }
    }

    public void removeImportModel(ImportModel importModel) {
        this.assertIsWriteable();
        if (this.imports != null) {
            this.imports.remove((Object)importModel);
        }
    }

    public void removePluginEntryModel(PluginEntryModel pluginEntryModel) {
        this.assertIsWriteable();
        if (this.pluginEntries != null) {
            this.pluginEntries.remove((Object)pluginEntryModel);
        }
    }

    public void removeNonPluginEntryModel(NonPluginEntryModel nonPluginEntryModel) {
        this.assertIsWriteable();
        if (this.nonPluginEntries != null) {
            this.nonPluginEntries.remove((Object)nonPluginEntryModel);
        }
    }

    public void markReadOnly() {
        super.markReadOnly();
        this.markReferenceReadOnly(this.getDescriptionModel());
        this.markReferenceReadOnly(this.getCopyrightModel());
        this.markReferenceReadOnly(this.getLicenseModel());
        this.markReferenceReadOnly(this.getUpdateSiteEntryModel());
        this.markListReferenceReadOnly(this.getDiscoverySiteEntryModels());
        this.markListReferenceReadOnly(this.getImportModels());
        this.markListReferenceReadOnly(this.getPluginEntryModels());
        this.markListReferenceReadOnly(this.getNonPluginEntryModels());
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
        this.bundleURL = uRL2;
        this.base = uRL;
        this.resolveListReference(this.getPluginEntryModels(), uRL, uRL2);
        this.resolveListReference(this.getNonPluginEntryModels(), uRL, uRL2);
        this.resolveReference(this.getDescriptionModel(), uRL, uRL2);
        this.resolveReference(this.getCopyrightModel(), uRL, uRL2);
        this.resolveReference(this.getLicenseModel(), uRL, uRL2);
        this.resolveReference(this.getUpdateSiteEntryModel(), uRL, uRL2);
        this.resolveListReference(this.getDiscoverySiteEntryModels(), uRL, uRL2);
        this.resolveListReference(this.getImportModels(), uRL, uRL2);
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.localizedLabel = this.resolveNLString(this.bundleURL, this.label);
        this.localizedProvider = this.resolveNLString(this.bundleURL, this.provider);
        try {
            this.imageURL = this.resolveURL(this.base, this.bundleURL, this.imageURLString);
        }
        catch (MalformedURLException malformedURLException) {
            UpdateCore.warn("", malformedURLException);
        }
    }

    public void setPrimaryPluginID(String string) {
        if (this.primary && this.primaryPluginID == null) {
            this.primaryPluginID = this.featureId;
        }
        this.primaryPluginID = string;
    }

    public String getPrimaryPluginID() {
        return this.primaryPluginID;
    }

    public boolean isPatch() {
        ImportModel[] importModelArray = this.getImportModels();
        int n = 0;
        while (n < importModelArray.length) {
            if (importModelArray[n].isPatch()) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

