/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class ReferenceHashSet {
    HashedReference[] values;
    public int elementSize = 0;
    int threshold;
    ReferenceQueue referenceQueue = new ReferenceQueue();
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;

    public ReferenceHashSet() {
        this(5);
    }

    public ReferenceHashSet(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.values = new HashedReference[n2];
    }

    private HashedReference toReference(int n, Object object) {
        switch (n) {
            case 0: {
                return new StrongReference(object, this.referenceQueue);
            }
            case 1: {
                return new HashableSoftReference(object, this.referenceQueue);
            }
            case 2: {
                return new HashableWeakReference(object, this.referenceQueue);
            }
        }
        throw new Error();
    }

    public Object add(Object object, int n) {
        HashedReference hashedReference;
        this.cleanupGarbageCollectedValues();
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % this.values.length;
        while ((hashedReference = this.values[n2]) != null) {
            Object object2 = hashedReference.get();
            if (object.equals(object2)) {
                return object2;
            }
            n2 = (n2 + 1) % this.values.length;
        }
        this.values[n2] = this.toReference(n, object);
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    private void addValue(HashedReference hashedReference) {
        HashedReference hashedReference2;
        Object object = hashedReference.get();
        if (object == null) {
            return;
        }
        int n = this.values.length;
        int n2 = (hashedReference.hashCode() & Integer.MAX_VALUE) % n;
        while ((hashedReference2 = this.values[n2]) != null) {
            if (object.equals(hashedReference2.get())) {
                return;
            }
            n2 = (n2 + 1) % n;
        }
        this.values[n2] = hashedReference;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
    }

    private void cleanupGarbageCollectedValues() {
        HashedReference hashedReference;
        block0: while ((hashedReference = (HashedReference)((Object)this.referenceQueue.poll())) != null) {
            HashedReference hashedReference2;
            int n = hashedReference.hashCode();
            int n2 = this.values.length;
            int n3 = (n & Integer.MAX_VALUE) % n2;
            while ((hashedReference2 = this.values[n3]) != null) {
                if (hashedReference2 == hashedReference) {
                    int n4;
                    int n5 = n3;
                    while ((hashedReference2 = this.values[n4 = (n5 + 1) % n2]) != null && hashedReference2.hashCode() == n) {
                        n5 = n4;
                    }
                    this.values[n3] = this.values[n5];
                    this.values[n5] = null;
                    --this.elementSize;
                    continue block0;
                }
                n3 = (n3 + 1) % n2;
            }
        }
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        HashedReference hashedReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((hashedReference = this.values[n2]) != null) {
            Object object2 = hashedReference.get();
            if (object.equals(object2)) {
                return object2;
            }
            n2 = (n2 + 1) % n;
        }
        return null;
    }

    private void rehash() {
        ReferenceHashSet referenceHashSet = new ReferenceHashSet(this.elementSize * 2);
        referenceHashSet.referenceQueue = this.referenceQueue;
        int n = 0;
        int n2 = this.values.length;
        while (n < n2) {
            HashedReference hashedReference = this.values[n];
            if (hashedReference != null) {
                referenceHashSet.addValue(hashedReference);
            }
            ++n;
        }
        this.values = referenceHashSet.values;
        this.threshold = referenceHashSet.threshold;
        this.elementSize = referenceHashSet.elementSize;
    }

    public Object remove(Object object) {
        HashedReference hashedReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((hashedReference = this.values[n2]) != null) {
            Object object2 = hashedReference.get();
            if (object.equals(object2)) {
                --this.elementSize;
                this.values[n2] = null;
                this.rehash();
                return object2;
            }
            n2 = (n2 + 1) % n;
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = 0;
        int n2 = this.values.length;
        while (n < n2) {
            Object object;
            HashedReference hashedReference = this.values[n];
            if (hashedReference != null && (object = hashedReference.get()) != null) {
                stringBuffer.append(object.toString());
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Object[] toArray() {
        this.cleanupGarbageCollectedValues();
        Object[] objectArray = new Object[this.elementSize];
        int n = 0;
        int n2 = 0;
        while (n2 < this.values.length) {
            Object object;
            if (this.values[n2] != null && (object = this.values[n2].get()) != null) {
                objectArray[n++] = object;
            }
            ++n2;
        }
        if (objectArray.length == n) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    private class HashableSoftReference
    extends SoftReference
    implements HashedReference {
        public int hashCode;

        public HashableSoftReference(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hashCode = object.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashableWeakReference)) {
                return false;
            }
            Object t = super.get();
            Object t2 = ((HashableWeakReference)object).get();
            if (t == null) {
                return t2 == null;
            }
            return t.equals(t2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object t = super.get();
            if (t == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] " + t.toString();
        }
    }

    private class HashableWeakReference
    extends WeakReference
    implements HashedReference {
        public int hashCode;

        public HashableWeakReference(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hashCode = object.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashableWeakReference)) {
                return false;
            }
            Object t = super.get();
            Object t2 = ((HashableWeakReference)object).get();
            if (t == null) {
                return t2 == null;
            }
            return t.equals(t2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object t = super.get();
            if (t == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] " + t.toString();
        }
    }

    private static interface HashedReference {
        public int hashCode();

        public Object get();
    }

    private class StrongReference
    implements HashedReference {
        private Object referent;

        public StrongReference(Object object, ReferenceQueue referenceQueue) {
            this.referent = object;
        }

        public int hashCode() {
            return this.referent.hashCode();
        }

        public Object get() {
            return this.referent;
        }

        public boolean equals(Object object) {
            return this.referent.equals(object);
        }
    }
}

