/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class FilteredServiceListener
implements ServiceListener {
    private final FilterImpl filter;
    private final ServiceListener listener;
    private final BundleContextImpl context;
    private final boolean allservices;
    private final String objectClass;

    protected FilteredServiceListener(String string, ServiceListener serviceListener, BundleContextImpl bundleContextImpl) throws InvalidSyntaxException {
        if (string == null) {
            this.filter = null;
            this.objectClass = null;
        } else {
            FilterImpl filterImpl = new FilterImpl(string);
            String string2 = filterImpl.getRequiredObjectClass();
            if (string2 == null) {
                this.objectClass = null;
                this.filter = filterImpl;
            } else {
                this.objectClass = string2.intern();
                String string3 = FilterImpl.getObjectClassFilterString(this.objectClass);
                this.filter = string3.equals(string) ? null : filterImpl;
            }
        }
        this.listener = serviceListener;
        this.context = bundleContextImpl;
        this.allservices = serviceListener instanceof AllServiceListener;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object object;
        ServiceReferenceImpl serviceReferenceImpl;
        block7: {
            serviceReferenceImpl = (ServiceReferenceImpl)serviceEvent.getServiceReference();
            if (this.objectClass != null) {
                object = serviceReferenceImpl.getClasses();
                int n = ((String[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    if (object[n2] != this.objectClass) {
                        ++n2;
                        continue;
                    }
                    break block7;
                }
                return;
            }
        }
        if (!this.context.hasListenServicePermission(serviceEvent)) {
            return;
        }
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this));
            Debug.println("filterServiceEvent(" + (String)object + ", \"" + this.filter + "\", " + serviceReferenceImpl.registration.properties + ")");
        }
        if ((this.filter == null || this.filter.match(serviceReferenceImpl)) && (this.allservices || this.context.isAssignableTo(serviceReferenceImpl))) {
            if (Debug.DEBUG_EVENTS) {
                object = String.valueOf(this.listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(this.listener));
                Debug.println("dispatchFilteredServiceEvent(" + (String)object + ")");
            }
            this.listener.serviceChanged(serviceEvent);
        }
    }

    public String toString() {
        return this.filter == null ? this.listener.toString() : this.filter.toString();
    }
}

