/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.ReferenceInputStream;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class BundleInstall
implements BundleOperation {
    private BaseData data;
    private URLConnection source;
    private BaseStorage storage;

    public BundleInstall(BaseData baseData, URLConnection uRLConnection, BaseStorage baseStorage) {
        this.data = baseData;
        this.source = uRLConnection;
        this.storage = baseStorage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BundleData begin() throws BundleException {
        try {
            InputStream inputStream = null;
            try {
                Object object;
                String string;
                BaseStorageHook baseStorageHook;
                this.data.setLastModified(System.currentTimeMillis());
                this.data.setStartLevel(this.storage.getInitialBundleStartLevel());
                StorageHook[] storageHookArray = this.data.getAdaptor().getHookRegistry().getStorageHooks();
                StorageHook[] storageHookArray2 = new StorageHook[storageHookArray.length];
                int n = 0;
                while (true) {
                    if (n >= storageHookArray.length) {
                        this.data.setStorageHooks(storageHookArray2);
                        baseStorageHook = (BaseStorageHook)this.data.getStorageHook(BaseStorageHook.KEY);
                        inputStream = this.source.getInputStream();
                        URL uRL = this.source.getURL();
                        String string2 = string = uRL == null ? null : uRL.getProtocol();
                    }
                    storageHookArray2[n] = storageHookArray[n].create(this.data);
                    ++n;
                }
                if (inputStream instanceof ReferenceInputStream) {
                    object = ((ReferenceInputStream)inputStream).getReference();
                    if (!"file".equals(((URL)object).getProtocol())) {
                        throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_URL_CREATE_EXCEPTION, object));
                    }
                    baseStorageHook.setReference(true);
                    baseStorageHook.setFileName(((URL)object).getPath());
                } else {
                    object = baseStorageHook.createGenerationDir();
                    if (!((File)object).exists()) {
                        throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, ((File)object).getPath()));
                    }
                    baseStorageHook.setReference(false);
                    baseStorageHook.setFileName("bundlefile");
                    File file = new File((File)object, baseStorageHook.getFileName());
                    if ("file".equals(string)) {
                        File file2 = new File(this.source.getURL().getPath());
                        if (file2.isDirectory()) {
                            AdaptorUtil.copyDir(file2, file);
                        } else {
                            AdaptorUtil.readFile(inputStream, file);
                        }
                    } else {
                        AdaptorUtil.readFile(inputStream, file);
                    }
                }
                object = this.storage.loadManifest(this.data, true);
                int n2 = 0;
                while (n2 < storageHookArray2.length) {
                    storageHookArray2[n2].initialize((Dictionary)object);
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var10_15 = null;
                try {}
                catch (IOException iOException) {
                    return this.data;
                }
                if (inputStream == null) return this.data;
                inputStream.close();
                return this.data;
            }
        }
        catch (IOException iOException) {
            throw new BundleException(AdaptorMsg.BUNDLE_READ_EXCEPTION, iOException);
        }
    }

    public void undo() {
        block7: {
            if (this.data != null) {
                try {
                    this.data.close();
                }
                catch (IOException iOException) {
                    if (!Debug.DEBUG_GENERAL) break block7;
                    Debug.println("Unable to close " + this.data + ": " + iOException.getMessage());
                }
            }
        }
        if (this.data != null) {
            BaseStorageHook baseStorageHook = (BaseStorageHook)this.data.getStorageHook(BaseStorageHook.KEY);
            try {
                if (baseStorageHook != null) {
                    baseStorageHook.delete(false, 1);
                }
            }
            catch (IOException iOException) {
                this.data.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.data.getBundle(), iOException);
            }
        }
    }

    public void commit(boolean bl) throws BundleException {
        this.storage.processExtension(this.data, (byte)2);
        try {
            this.data.save();
        }
        catch (IOException iOException) {
            throw new BundleException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION, iOException);
        }
        this.storage.updateState(this.data, 1);
    }
}

