/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SignedStorageHook
implements StorageHook {
    static final String KEY;
    static final int HASHCODE;
    private static final int STORAGE_VERSION = 2;
    private static ArrayList saveChainCache;
    private static long firstIDSaved;
    private static long lastIDSaved;
    private static ArrayList loadChainCache;
    private static long lastIDLoaded;
    private BaseData bundledata;
    SignedBundleFile signedBundleFile;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.verifier.SignedStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
        saveChainCache = new ArrayList(5);
        firstIDSaved = -1L;
        lastIDSaved = -1L;
        loadChainCache = new ArrayList(5);
    }

    public int getStorageVersion() {
        return 2;
    }

    public StorageHook create(BaseData baseData) throws BundleException {
        SignedStorageHook signedStorageHook = new SignedStorageHook();
        signedStorageHook.bundledata = baseData;
        return signedStorageHook;
    }

    public void initialize(Dictionary dictionary) throws BundleException {
    }

    public StorageHook load(BaseData baseData, DataInputStream dataInputStream) throws IOException {
        Object object;
        int n;
        Object object2;
        if (lastIDLoaded > baseData.getBundleID()) {
            loadChainCache.clear();
        }
        lastIDLoaded = baseData.getBundleID();
        SignedStorageHook signedStorageHook = new SignedStorageHook();
        signedStorageHook.bundledata = baseData;
        boolean bl = dataInputStream.readBoolean();
        if (!bl) {
            return signedStorageHook;
        }
        int n2 = dataInputStream.readInt();
        CertificateChain[] certificateChainArray = new CertificateChain[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = dataInputStream.readInt();
            if (n4 >= 0) {
                certificateChainArray[n3] = (CertificateChain)loadChainCache.get(n4);
                if (certificateChainArray[n3] == null) {
                    throw new IOException("Invalid chain cache.");
                }
            } else {
                object2 = dataInputStream.readUTF();
                n = dataInputStream.readBoolean();
                int n5 = dataInputStream.readInt();
                object = new byte[n5][];
                int n6 = 0;
                while (n6 < ((byte[][])object).length) {
                    int n7 = dataInputStream.readInt();
                    object[n6] = new byte[n7];
                    dataInputStream.readFully(object[n6]);
                    ++n6;
                }
                long l = dataInputStream.readLong();
                try {
                    certificateChainArray[n3] = new PKCS7Processor((String)object2, n != 0, (byte[][])object, l);
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.getMessage());
                }
                loadChainCache.add(certificateChainArray[n3]);
            }
            ++n3;
        }
        n3 = dataInputStream.readInt();
        Hashtable<String, byte[][]> hashtable = null;
        object2 = null;
        if (n3 >= 0) {
            hashtable = new Hashtable<String, byte[][]>(n3);
            object2 = new Hashtable(n3);
            n = 0;
            while (n < n3) {
                String string = dataInputStream.readUTF();
                object = dataInputStream.readInt() == 0 ? (Object)"MD5" : (Object)"SHA1";
                byte[] byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray);
                hashtable.put(string, (byte[][])object);
                ((Hashtable)object2).put(string, byArray);
                ++n;
            }
        }
        String string = null;
        String string2 = null;
        if (dataInputStream.readBoolean()) {
            string = dataInputStream.readUTF();
        }
        if (dataInputStream.readBoolean()) {
            string2 = dataInputStream.readUTF();
        }
        signedStorageHook.signedBundleFile = new SignedBundleFile(certificateChainArray, hashtable, (Hashtable)object2, string, string2);
        return signedStorageHook;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        Certificate[] certificateArray;
        this.getFirstLastID();
        if (firstIDSaved == this.bundledata.getBundleID()) {
            saveChainCache.clear();
        }
        if (lastIDSaved == this.bundledata.getBundleID()) {
            lastIDSaved = -1L;
            firstIDSaved = -1L;
        }
        BundleFile bundleFile = this.bundledata.getBundleFile();
        CertificateChain[] certificateChainArray = null;
        String string = null;
        String string2 = null;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        if (bundleFile instanceof SignedBundleFile) {
            SignedBundleFile signedBundleFile = (SignedBundleFile)bundleFile;
            certificateChainArray = signedBundleFile.chains;
            string = signedBundleFile.manifestMD5Result;
            string2 = signedBundleFile.manifestSHAResult;
            hashtable = signedBundleFile.digests4entries;
            hashtable2 = signedBundleFile.results4entries;
        }
        dataOutputStream.writeBoolean(certificateChainArray != null);
        if (certificateChainArray == null) {
            return;
        }
        dataOutputStream.writeInt(certificateChainArray.length);
        int n = 0;
        while (n < certificateChainArray.length) {
            int n2 = saveChainCache.indexOf(certificateChainArray[n]);
            dataOutputStream.writeInt(n2);
            if (n2 < 0) {
                saveChainCache.add(certificateChainArray[n]);
                dataOutputStream.writeUTF(certificateChainArray[n].getChain());
                dataOutputStream.writeBoolean(certificateChainArray[n].isTrusted());
                certificateArray = certificateChainArray[n].getCertificates();
                dataOutputStream.writeInt(certificateArray == null ? 0 : certificateArray.length);
                if (certificateArray != null) {
                    int n3 = 0;
                    while (n3 < certificateArray.length) {
                        byte[] byArray;
                        try {
                            byArray = certificateArray[n3].getEncoded();
                        }
                        catch (CertificateEncodingException certificateEncodingException) {
                            throw new IOException(certificateEncodingException.getMessage());
                        }
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                        ++n3;
                    }
                }
                dataOutputStream.writeLong(certificateChainArray[n].getSigningTime() != null ? certificateChainArray[n].getSigningTime().getTime() : Long.MIN_VALUE);
            }
            ++n;
        }
        if (hashtable == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                certificateArray = (Certificate[])hashtable.get(string3);
                byte[] byArray = (byte[])hashtable2.get(string3);
                dataOutputStream.writeUTF(string3);
                if (certificateArray == "MD2") {
                    dataOutputStream.writeInt(0);
                } else {
                    dataOutputStream.writeInt(1);
                }
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
        }
        dataOutputStream.writeBoolean(string != null);
        if (string != null) {
            dataOutputStream.writeUTF(string);
        }
        dataOutputStream.writeBoolean(string2 != null);
        if (string2 != null) {
            dataOutputStream.writeUTF(string2);
        }
    }

    private void getFirstLastID() {
        if (firstIDSaved >= 0L) {
            return;
        }
        Bundle[] bundleArray = this.bundledata.getAdaptor().getContext().getBundles();
        if (bundleArray.length > 1) {
            firstIDSaved = bundleArray[1].getBundleId();
            lastIDSaved = bundleArray[bundleArray.length - 1].getBundleId();
        }
    }

    public void copy(StorageHook storageHook) {
    }

    public void validate() throws IllegalArgumentException {
    }

    public Dictionary getManifest(boolean bl) throws BundleException {
        return null;
    }

    public boolean forgetStatusChange(int n) {
        return false;
    }

    public boolean forgetStartLevelChange(int n) {
        return false;
    }

    public boolean matchDNChain(String string) {
        BundleFile bundleFile = this.bundledata.getBundleFile();
        if (!(bundleFile instanceof SignedBundleFile)) {
            return false;
        }
        return ((SignedBundleFile)bundleFile).matchDNChain(string);
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public boolean compare(KeyedElement keyedElement) {
        return keyedElement.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }
}

