/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Composite;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Composite.CompositeShowCaseComplexLayout;
import org.eclipse.ercp.swt.samples.eswtdemo.Composite.CompositeShowCaseSimpleLayout;
import org.eclipse.ercp.swt.samples.eswtdemo.MainMenu;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CompositeShowCase
extends ShowCase
implements SelectionListener,
ShellListener {
    public static CompositeShowCase instance;
    private MobileShell mobileShell;
    private Command commandExit;
    private FocusListener superShellListener = null;

    public CompositeShowCase() {
        instance = this;
    }

    private Vector loadShowCases() {
        Vector<ShowCase> vector = new Vector<ShowCase>();
        vector.add(new CompositeShowCaseSimpleLayout());
        vector.add(new CompositeShowCaseComplexLayout(this.mobileShell));
        return vector;
    }

    public String getName() {
        return Messages.getString("CompositeShowCase.0");
    }

    public Composite getComposite() {
        return this.mobileShell;
    }

    public void show() {
        this.mobileShell = new MobileShell(Display.getCurrent(), 1264);
        this.mobileShell.setText(Messages.getString("CompositeShowCase.1"));
        this.mobileShell.addShellListener((ShellListener)this);
        Vector vector = this.loadShowCases();
        new MainMenu(this.getComposite(), vector);
        this.enableExit(true);
        this.getComposite().forceFocus();
        this.mobileShell.open();
        this.superShellListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (CompositeShowCase.this.mobileShell != null && !CompositeShowCase.this.mobileShell.isDisposed()) {
                    CompositeShowCase.this.mobileShell.forceActive();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        };
        super.getComposite().getShell().addFocusListener(this.superShellListener);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.commandExit = null;
        this.mobileShell.dispose();
        if (super.getComposite() != null && !super.getComposite().isDisposed()) {
            super.getComposite().getShell().removeFocusListener(this.superShellListener);
        }
        this.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void enableExit(boolean bl) {
        if (bl) {
            if (this.commandExit == null) {
                this.commandExit = new Command((Control)this.getComposite(), 7, 0);
                this.commandExit.setText(Messages.getString("CompositeShowCase.2"));
                this.commandExit.setLongLabel(Messages.getString("CompositeShowCase.3"));
                this.commandExit.addSelectionListener((SelectionListener)this);
            }
        } else if (this.commandExit != null) {
            this.commandExit.dispose();
            this.commandExit = null;
        }
    }

    public static CompositeShowCase getInstance() {
        return instance;
    }

    public void shellClosed(ShellEvent shellEvent) {
        if (super.getComposite() != null && !super.getComposite().isDisposed()) {
            super.getComposite().getShell().removeFocusListener(this.superShellListener);
        }
        this.dispose();
    }

    public void shellActivated(ShellEvent shellEvent) {
    }

    public void shellDeactivated(ShellEvent shellEvent) {
    }

    public void shellIconified(ShellEvent shellEvent) {
    }

    public void shellDeiconified(ShellEvent shellEvent) {
    }
}

