/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionDelta;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.ExtensionsParser;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.registry.ReadWriteMonitor;
import org.eclipse.core.internal.registry.RegistryChangeEvent;
import org.eclipse.core.internal.registry.RegistryDelta;
import org.eclipse.core.internal.registry.RegistryIndexElement;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectFactory;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.registry.RegistryTimestamp;
import org.eclipse.core.internal.registry.TableReader;
import org.eclipse.core.internal.registry.TableWriter;
import org.eclipse.core.internal.registry.spi.ConfigurationElementAttribute;
import org.eclipse.core.internal.registry.spi.ConfigurationElementDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExtensionRegistry
implements IExtensionRegistry {
    private ReadWriteMonitor access = new ReadWriteMonitor();
    private transient Map deltas = new HashMap(11);
    protected StorageManager cacheStorageManager;
    private transient ListenerList listeners = new ListenerList();
    private RegistryObjectManager registryObjects = null;
    protected boolean isRegistryFilledFromCache = false;
    protected TableReader theTableReader = new TableReader(this);
    private Object masterToken;
    private Object userToken;
    protected RegistryStrategy strategy;
    private RegistryTimestamp aggregatedTimestamp = new RegistryTimestamp();
    protected RegistryObjectFactory theRegistryObjectFactory = null;
    private RegistryEventThread eventThread = null;
    private final List queue = new LinkedList();

    public RegistryObjectManager getObjectManager() {
        return this.registryObjects;
    }

    protected void setFileManager(File file, boolean bl) {
        if (this.cacheStorageManager != null) {
            this.cacheStorageManager.close();
        }
        if (file != null) {
            this.cacheStorageManager = new StorageManager(file, bl ? "none" : null, bl);
            try {
                this.cacheStorageManager.open(!bl);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void add(Contribution contribution) {
        this.access.enterWrite();
        try {
            this.basicAdd(contribution, true);
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.access.exitWrite();
            return;
        }
    }

    static Object concatArrays(Object object, Object object2) {
        Object[] objectArray = (Object[])Array.newInstance(object.getClass().getComponentType(), Array.getLength(object) + Array.getLength(object2));
        System.arraycopy(object, 0, objectArray, 0, Array.getLength(object));
        System.arraycopy(object2, 0, objectArray, Array.getLength(object), Array.getLength(object2));
        return objectArray;
    }

    private String addExtension(int n) {
        Extension extension = (Extension)this.registryObjects.getObject(n, (byte)2);
        String string = extension.getExtensionPointIdentifier();
        ExtensionPoint extensionPoint = this.registryObjects.getExtensionPointObject(string);
        if (extensionPoint == null) {
            this.registryObjects.addOrphan(string, n);
            return null;
        }
        int[] nArray = extensionPoint.getRawChildren();
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray2.length - 1] = n;
        this.link(extensionPoint, nArray2);
        return this.recordChange(extensionPoint, n, 1);
    }

    private String addExtensionPoint(int n) {
        ExtensionPoint extensionPoint = (ExtensionPoint)this.registryObjects.getObject(n, (byte)3);
        int[] nArray = this.registryObjects.removeOrphans(extensionPoint.getUniqueIdentifier());
        if (nArray == null) {
            return null;
        }
        this.link(extensionPoint, nArray);
        return this.recordChange(extensionPoint, nArray, 1);
    }

    private Set addExtensionsAndExtensionPoints(Contribution contribution) {
        HashSet<String> hashSet = new HashSet<String>();
        int[] nArray = contribution.getExtensionPoints();
        int n = 0;
        while (n < nArray.length) {
            String string = this.addExtensionPoint(nArray[n]);
            if (string != null) {
                hashSet.add(string);
            }
            ++n;
        }
        int[] nArray2 = contribution.getExtensions();
        int n2 = 0;
        while (n2 < nArray2.length) {
            String string = this.addExtension(nArray2[n2]);
            if (string != null) {
                hashSet.add(string);
            }
            ++n2;
        }
        return hashSet;
    }

    public void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        this.addRegistryChangeListener(iRegistryChangeListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener, String string) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.add((Object)new ListenerInfo(iRegistryChangeListener, string));
        }
    }

    private void basicAdd(Contribution contribution, boolean bl) {
        this.registryObjects.addContribution(contribution);
        if (!bl) {
            return;
        }
        Set set = this.addExtensionsAndExtensionPoints(contribution);
        this.setObjectManagers(set, this.registryObjects.createDelegatingObjectManager(this.registryObjects.getAssociatedObjects(contribution.getContributorId())));
    }

    private void setObjectManagers(Set set, IObjectManager iObjectManager) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.getDelta((String)iterator.next()).setObjectManager(iObjectManager);
        }
    }

    private void basicRemove(String string) {
        Set set = this.removeExtensionsAndExtensionPoints(string);
        Map map = this.registryObjects.getAssociatedObjects(string);
        this.registryObjects.removeObjects(map);
        this.registryObjects.addNavigableObjects(map);
        this.setObjectManagers(set, this.registryObjects.createDelegatingObjectManager(map));
        this.registryObjects.removeContribution(string);
        this.registryObjects.removeContributor(string);
    }

    void enterRead() {
        this.access.enterRead();
    }

    void exitRead() {
        this.access.exitRead();
    }

    private void fireRegistryChangeEvent() {
        if (this.deltas.isEmpty() || this.listeners.isEmpty()) {
            return;
        }
        Object[] objectArray = this.listeners.getListeners();
        HashMap hashMap = new HashMap(this.deltas);
        this.deltas.clear();
        this.strategy.scheduleChangeEvent(objectArray, hashMap, this);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return new IConfigurationElement[0];
        }
        return this.getConfigurationElementsFor(string.substring(0, n), string.substring(n + 1));
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string, String string2) {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string, string2);
        if (iExtensionPoint == null) {
            return new IConfigurationElement[0];
        }
        return iExtensionPoint.getConfigurationElements();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String string, String string2, String string3) {
        IExtension iExtension = this.getExtension(string, string2, string3);
        if (iExtension == null) {
            return new IConfigurationElement[0];
        }
        return iExtension.getConfigurationElements();
    }

    private RegistryDelta getDelta(String string) {
        RegistryDelta registryDelta = (RegistryDelta)this.deltas.get(string);
        if (registryDelta != null) {
            return registryDelta;
        }
        RegistryDelta registryDelta2 = new RegistryDelta();
        this.deltas.put(string, registryDelta2);
        return registryDelta2;
    }

    public IExtension getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        ExtensionHandle[] extensionHandleArray = this.registryObjects.getExtensionsFromNamespace(string2);
        int n2 = 0;
        while (n2 < extensionHandleArray.length) {
            ExtensionHandle extensionHandle = extensionHandleArray[n2];
            if (string.equals(extensionHandle.getUniqueIdentifier())) {
                return extensionHandle;
            }
            ++n2;
        }
        return null;
    }

    public IExtension getExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return this.getExtension(string.substring(0, n), string.substring(n + 1), string2);
    }

    public IExtension getExtension(String string, String string2, String string3) {
        IExtensionPoint iExtensionPoint = this.getExtensionPoint(string, string2);
        if (iExtensionPoint != null) {
            return iExtensionPoint.getExtension(string3);
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String string) {
        return this.registryObjects.getExtensionPointHandle(string);
    }

    public IExtensionPoint getExtensionPoint(String string, String string2) {
        this.access.enterRead();
        try {
            ExtensionPointHandle extensionPointHandle = this.registryObjects.getExtensionPointHandle(String.valueOf(string) + '.' + string2);
            Object var3_4 = null;
            this.access.exitRead();
            return extensionPointHandle;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtensionPoint[] getExtensionPoints() {
        this.access.enterRead();
        try {
            IExtensionPoint[] iExtensionPointArray = this.registryObjects.getExtensionPointsHandles();
            Object var1_2 = null;
            this.access.exitRead();
            return iExtensionPointArray;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtensionPoint[] getExtensionPoints(String string) {
        this.access.enterRead();
        try {
            IExtensionPoint[] iExtensionPointArray = this.registryObjects.getExtensionPointsFromNamespace(string);
            Object var2_3 = null;
            this.access.exitRead();
            return iExtensionPointArray;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtension[] getExtensions(String string) {
        this.access.enterRead();
        try {
            IExtension[] iExtensionArray = this.registryObjects.getExtensionsFromNamespace(string);
            Object var2_3 = null;
            this.access.exitRead();
            return iExtensionArray;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public String[] getNamespaces() {
        this.access.enterRead();
        try {
            KeyedElement[] keyedElementArray = this.registryObjects.getNamespacesIndex().elements();
            String[] stringArray = new String[keyedElementArray.length];
            int n = 0;
            while (n < keyedElementArray.length) {
                stringArray[n] = (String)((RegistryIndexElement)keyedElementArray[n]).getKey();
                ++n;
            }
            String[] stringArray2 = stringArray;
            Object var4_5 = null;
            this.access.exitRead();
            return stringArray2;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public boolean hasContribution(String string) {
        this.access.enterRead();
        try {
            boolean bl = this.registryObjects.hasContribution(string);
            Object var2_3 = null;
            this.access.exitRead();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    private void link(ExtensionPoint extensionPoint, int[] nArray) {
        extensionPoint.setRawChildren(nArray);
        this.registryObjects.add(extensionPoint, true);
    }

    private String recordChange(ExtensionPoint extensionPoint, int n, int n2) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        ExtensionDelta extensionDelta = new ExtensionDelta();
        extensionDelta.setExtension(n);
        extensionDelta.setExtensionPoint(extensionPoint.getObjectId());
        extensionDelta.setKind(n2);
        this.getDelta(extensionPoint.getNamespace()).addExtensionDelta(extensionDelta);
        return extensionPoint.getNamespace();
    }

    private String recordChange(ExtensionPoint extensionPoint, int[] nArray, int n) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        RegistryDelta registryDelta = this.getDelta(extensionPoint.getNamespace());
        int n2 = 0;
        while (n2 < nArray.length) {
            ExtensionDelta extensionDelta = new ExtensionDelta();
            extensionDelta.setExtension(nArray[n2]);
            extensionDelta.setExtensionPoint(extensionPoint.getObjectId());
            extensionDelta.setKind(n);
            registryDelta.addExtensionDelta(extensionDelta);
            ++n2;
        }
        return extensionPoint.getNamespace();
    }

    public void remove(String string, long l) {
        this.remove(string);
        if (l != 0L) {
            this.aggregatedTimestamp.remove(l);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String string) {
        this.access.enterWrite();
        try {
            this.basicRemove(string);
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.access.exitWrite();
            return;
        }
    }

    private String removeExtension(int n) {
        Extension extension = (Extension)this.registryObjects.getObject(n, (byte)2);
        this.registryObjects.removeExtensionFromNamespaceIndex(n, extension.getNamespaceIdentifier());
        String string = extension.getExtensionPointIdentifier();
        ExtensionPoint extensionPoint = this.registryObjects.getExtensionPointObject(string);
        if (extensionPoint == null) {
            this.registryObjects.removeOrphan(string, n);
            return null;
        }
        int[] nArray = extensionPoint.getRawChildren();
        int[] nArray2 = RegistryObjectManager.EMPTY_INT_ARRAY;
        if (nArray.length > 1) {
            if (nArray.length == 1) {
                nArray2 = RegistryObjectManager.EMPTY_INT_ARRAY;
            }
            nArray2 = new int[nArray.length - 1];
            int n2 = 0;
            int n3 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] != extension.getObjectId()) {
                    nArray2[n3++] = nArray[n2];
                }
                ++n2;
            }
        }
        this.link(extensionPoint, nArray2);
        return this.recordChange(extensionPoint, extension.getObjectId(), 2);
    }

    private String removeExtensionPoint(int n) {
        ExtensionPoint extensionPoint = (ExtensionPoint)this.registryObjects.getObject(n, (byte)3);
        this.registryObjects.removeExtensionPointFromNamespaceIndex(n, extensionPoint.getNamespace());
        int[] nArray = extensionPoint.getRawChildren();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        this.registryObjects.addOrphans(extensionPoint.getUniqueIdentifier(), nArray);
        this.link(extensionPoint, RegistryObjectManager.EMPTY_INT_ARRAY);
        return this.recordChange(extensionPoint, nArray, 2);
    }

    private Set removeExtensionsAndExtensionPoints(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        int[] nArray = this.registryObjects.getExtensionsFrom(string);
        int n = 0;
        while (n < nArray.length) {
            String string2 = this.removeExtension(nArray[n]);
            if (string2 != null) {
                hashSet.add(string2);
            }
            ++n;
        }
        int[] nArray2 = this.registryObjects.getExtensionPointsFrom(string);
        int n2 = 0;
        while (n2 < nArray2.length) {
            String string3 = this.removeExtensionPoint(nArray2[n2]);
            if (string3 != null) {
                hashSet.add(string3);
            }
            ++n2;
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.remove((Object)new ListenerInfo(iRegistryChangeListener, null));
        }
    }

    public ExtensionRegistry(RegistryStrategy registryStrategy, Object object, Object object2) {
        this.strategy = registryStrategy != null ? registryStrategy : new RegistryStrategy(null, null);
        this.masterToken = object;
        this.userToken = object2;
        this.registryObjects = new RegistryObjectManager(this);
        if (this.strategy.cacheUse()) {
            long l = 0L;
            if (this.debug()) {
                l = System.currentTimeMillis();
            }
            if (this.checkCache()) {
                try {
                    this.theTableReader.setTableFile(this.cacheStorageManager.lookup(".table", false));
                    this.theTableReader.setExtraDataFile(this.cacheStorageManager.lookup(".extraData", false));
                    this.theTableReader.setMainDataFile(this.cacheStorageManager.lookup(".mainData", false));
                    this.theTableReader.setContributionsFile(this.cacheStorageManager.lookup(".contributions", false));
                    this.theTableReader.setContributorsFile(this.cacheStorageManager.lookup(".contributors", false));
                    this.theTableReader.setNamespacesFile(this.cacheStorageManager.lookup(".namespaces", false));
                    this.theTableReader.setOrphansFile(this.cacheStorageManager.lookup(".orphans", false));
                    long l2 = this.strategy.getContributionsTimestamp();
                    this.isRegistryFilledFromCache = this.registryObjects.init(l2);
                    if (this.isRegistryFilledFromCache) {
                        this.aggregatedTimestamp.set(l2);
                    }
                }
                catch (IOException iOException) {
                    this.isRegistryFilledFromCache = false;
                    this.clearRegistryCache();
                    this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.registry_bad_cache, (Throwable)iOException));
                }
            }
            if (!this.isRegistryFilledFromCache) {
                int n = 0;
                while (n < this.strategy.getLocationsLength()) {
                    if (!this.strategy.isCacheReadOnly(n)) {
                        this.setFileManager(this.strategy.getStorage(n), false);
                        break;
                    }
                    ++n;
                }
            }
            if (this.debug() && this.isRegistryFilledFromCache) {
                System.out.println("Reading registry cache: " + (System.currentTimeMillis() - l));
            }
            if (this.debug()) {
                if (!this.isRegistryFilledFromCache) {
                    System.out.println("Reloading registry from manifest files...");
                } else {
                    System.out.println("Using registry cache...");
                }
            }
        }
        if (this.debugEvents()) {
            this.addRegistryChangeListener(new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
                    System.out.println(iRegistryChangeEvent);
                }
            });
        }
        this.strategy.onStart(this);
    }

    public void stop(Object object) {
        if (this.masterToken != null && this.masterToken != object) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.stop() method. Check if proper access token is supplied.");
        }
        this.strategy.onStop(this);
        this.stopChangeEventScheduler();
        if (this.cacheStorageManager == null) {
            return;
        }
        if (!this.registryObjects.isDirty() || this.cacheStorageManager.isReadOnly()) {
            this.cacheStorageManager.close();
            return;
        }
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        File file5 = null;
        File file6 = null;
        File file7 = null;
        TableWriter tableWriter = new TableWriter(this);
        try {
            this.cacheStorageManager.lookup(".table", true);
            this.cacheStorageManager.lookup(".mainData", true);
            this.cacheStorageManager.lookup(".extraData", true);
            this.cacheStorageManager.lookup(".contributions", true);
            this.cacheStorageManager.lookup(".contributors", true);
            this.cacheStorageManager.lookup(".namespaces", true);
            this.cacheStorageManager.lookup(".orphans", true);
            file = File.createTempFile(".table", ".new", this.cacheStorageManager.getBase());
            file2 = File.createTempFile(".mainData", ".new", this.cacheStorageManager.getBase());
            file3 = File.createTempFile(".extraData", ".new", this.cacheStorageManager.getBase());
            file4 = File.createTempFile(".contributions", ".new", this.cacheStorageManager.getBase());
            file5 = File.createTempFile(".contributors", ".new", this.cacheStorageManager.getBase());
            file6 = File.createTempFile(".namespaces", ".new", this.cacheStorageManager.getBase());
            file7 = File.createTempFile(".orphans", ".new", this.cacheStorageManager.getBase());
            tableWriter.setTableFile(file);
            tableWriter.setExtraDataFile(file3);
            tableWriter.setMainDataFile(file2);
            tableWriter.setContributionsFile(file4);
            tableWriter.setContributorsFile(file5);
            tableWriter.setNamespacesFile(file6);
            tableWriter.setOrphansFile(file7);
        }
        catch (IOException iOException) {
            this.cacheStorageManager.close();
            return;
        }
        try {
            long l = this.aggregatedTimestamp.isModifed() ? this.aggregatedTimestamp.getContentsTimestamp() : this.strategy.getContributionsTimestamp();
            if (tableWriter.saveCache(this.registryObjects, l)) {
                this.cacheStorageManager.update(new String[]{".table", ".mainData", ".extraData", ".contributions", ".contributors", ".namespaces", ".orphans"}, new String[]{file.getName(), file2.getName(), file3.getName(), file4.getName(), file5.getName(), file6.getName(), file7.getName()});
            }
        }
        catch (IOException iOException) {}
        this.theTableReader.close();
        this.cacheStorageManager.close();
    }

    public void clearRegistryCache() {
        String[] stringArray = new String[]{".table", ".mainData", ".extraData", ".contributions", ".orphans"};
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.cacheStorageManager.remove(stringArray[n]);
            }
            catch (IOException iOException) {
                this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 4, RegistryMessages.meta_registryCacheReadProblems, (Throwable)iOException));
            }
            ++n;
        }
        this.aggregatedTimestamp.reset();
    }

    protected void setElementFactory() {
        this.theRegistryObjectFactory = new RegistryObjectFactory(this);
    }

    public RegistryObjectFactory getElementFactory() {
        if (this.theRegistryObjectFactory == null) {
            this.setElementFactory();
        }
        return this.theRegistryObjectFactory;
    }

    TableReader getTableReader() {
        return this.theTableReader;
    }

    public void log(IStatus iStatus) {
        this.strategy.log(iStatus);
    }

    public String translate(String string, ResourceBundle resourceBundle) {
        return this.strategy.translate(string, resourceBundle);
    }

    public boolean debug() {
        return this.strategy.debug();
    }

    public boolean debugEvents() {
        return this.strategy.debugRegistryEvents();
    }

    public boolean useLazyCacheLoading() {
        return this.strategy.cacheLazyLoading();
    }

    public long computeState() {
        return this.strategy.getContainerTimestamp();
    }

    protected boolean checkCache() {
        int n = 0;
        while (n < this.strategy.getLocationsLength()) {
            File file = this.strategy.getStorage(n);
            if (file == null) break;
            this.setFileManager(file, this.strategy.isCacheReadOnly(n));
            if (this.cacheStorageManager != null) {
                File file2 = null;
                try {
                    file2 = this.cacheStorageManager.lookup(TableReader.getTestFileName(), false);
                }
                catch (IOException iOException) {}
                if (file2 != null && file2.isFile()) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public boolean filledFromCache() {
        return this.isRegistryFilledFromCache;
    }

    public Object createExecutableExtension(RegistryContributor registryContributor, String string, String string2) throws CoreException {
        return this.strategy.createExecutableExtension(registryContributor, string, string2);
    }

    public IStatus processChangeEvent(Object[] objectArray, final Map map) {
        final MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.registry", 0, RegistryMessages.plugin_eventListenerError, null);
        int n = 0;
        while (n < objectArray.length) {
            final ListenerInfo listenerInfo = (ListenerInfo)objectArray[n];
            if ((listenerInfo.filter == null || map.containsKey(listenerInfo.filter)) && listenerInfo.listener instanceof IRegistryChangeListener) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listenerInfo.listener.registryChanged(new RegistryChangeEvent(map, listenerInfo.filter));
                    }

                    public void handleException(Throwable throwable) {
                        multiStatus.add((IStatus)new Status(4, "org.eclipse.equinox.registry", RegistryMessages.plugin_eventListenerError, throwable));
                    }
                });
            }
            ++n;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ((RegistryDelta)iterator.next()).getObjectManager().close();
        }
        return multiStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleChangeEvent(Object[] objectArray, Map map) {
        QueueElement queueElement = new QueueElement(objectArray, map);
        if (this.eventThread == null) {
            this.eventThread = new RegistryEventThread(this);
            this.eventThread.start();
        }
        List list = this.queue;
        synchronized (list) {
            this.queue.add(queueElement);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopChangeEventScheduler() {
        if (this.eventThread != null) {
            List list = this.queue;
            synchronized (list) {
                this.eventThread.interrupt();
                this.eventThread = null;
            }
        }
    }

    private boolean checkReadWriteAccess(Object object, boolean bl) {
        if (this.masterToken == object) {
            return true;
        }
        return this.userToken == object && !bl;
    }

    public boolean addContribution(InputStream inputStream, IContributor iContributor, boolean bl, String string, ResourceBundle resourceBundle, Object object, long l) {
        boolean bl2 = this.addContribution(inputStream, iContributor, bl, string, resourceBundle, object);
        if (l != 0L) {
            this.aggregatedTimestamp.add(l);
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addContribution(InputStream inputStream, IContributor iContributor, boolean bl, String string, ResourceBundle resourceBundle, Object object) {
        if (!this.checkReadWriteAccess(object, bl)) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.addContribution() method. Check if proper access token is supplied.");
        }
        if (string == null) {
            string = "";
        }
        RegistryContributor registryContributor = (RegistryContributor)iContributor;
        this.registryObjects.addContributor(registryContributor);
        String string2 = registryContributor.getActualName();
        String string3 = NLS.bind((String)RegistryMessages.parse_problems, (Object)string2);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.registry", 1, string3, null);
        ExtensionsParser extensionsParser = new ExtensionsParser(multiStatus, this);
        Contribution contribution = this.getElementFactory().createContribution(registryContributor.getActualId(), bl);
        try {
            block13: {
                block14: {
                    try {
                        extensionsParser.parseManifest(this.strategy.getXMLParser(), new InputSource(inputStream), string, this.getObjectManager(), contribution, resourceBundle);
                        int n = multiStatus.getSeverity();
                        if (n == 0) break block13;
                        this.log((IStatus)multiStatus);
                        if (n == 4) break block14;
                        if (n != 8) break block13;
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        this.logError(string2, string, parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        this.logError(string2, string, sAXException);
                    }
                    catch (IOException iOException) {
                        this.logError(string2, string, iOException);
                    }
                }
                Object var14_17 = null;
                try {
                    inputStream.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            Object var14_19 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            try {}
            catch (IOException iOException) {}
            inputStream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        this.add(contribution);
        return true;
    }

    private void logError(String string, String string2, Exception exception) {
        String string3 = NLS.bind((String)RegistryMessages.parse_failedParsingManifest, (Object)(String.valueOf(string) + "/" + string2));
        this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, string3, (Throwable)exception));
    }

    public boolean addExtensionPoint(String string, IContributor iContributor, boolean bl, String string2, String string3, Object object) throws IllegalArgumentException {
        String string4;
        String string5;
        Object object2;
        if (!this.checkReadWriteAccess(object, bl)) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.addExtensionPoint() method. Check if proper access token is supplied.");
        }
        RegistryContributor registryContributor = (RegistryContributor)iContributor;
        this.registryObjects.addContributor(registryContributor);
        String string6 = registryContributor.getActualId();
        if (string == null) {
            object2 = NLS.bind((String)RegistryMessages.create_failedExtensionPoint, (Object)string2);
            this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, (String)object2, null));
        }
        if (string3 == null) {
            string3 = "";
        }
        object2 = this.getElementFactory().createContribution(string6, bl);
        ExtensionPoint extensionPoint = this.getElementFactory().createExtensionPoint(bl);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            string5 = ((Contribution)object2).getDefaultNamespace();
            string4 = String.valueOf(string5) + '.' + string;
        } else {
            string5 = string.substring(0, n);
            string4 = string;
        }
        extensionPoint.setUniqueIdentifier(string4);
        extensionPoint.setNamespace(string5);
        String string7 = this.translate(string2, null);
        extensionPoint.setLabel(string7);
        extensionPoint.setSchema(string3);
        if (!this.getObjectManager().addExtensionPoint(extensionPoint, true)) {
            if (this.debug()) {
                String string8 = NLS.bind((String)RegistryMessages.parse_duplicateExtensionPoint, (Object)string4, (Object)((Contribution)object2).getDefaultNamespace());
                this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, string8, null));
            }
            return false;
        }
        extensionPoint.setContributorId(string6);
        int[] nArray = new int[]{1, 0, extensionPoint.getObjectId()};
        ((Contribution)object2).setRawChildren(nArray);
        this.add((Contribution)object2);
        return true;
    }

    public boolean addExtension(String string, IContributor iContributor, boolean bl, String string2, String string3, ConfigurationElementDescription configurationElementDescription, Object object) throws IllegalArgumentException {
        Object object2;
        IExtension iExtension;
        String string4;
        String string5;
        if (!this.checkReadWriteAccess(object, bl)) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.addExtensionPoint() method. Check if proper access token is supplied.");
        }
        RegistryContributor registryContributor = (RegistryContributor)iContributor;
        this.registryObjects.addContributor(registryContributor);
        String string6 = registryContributor.getActualId();
        Contribution contribution = this.getElementFactory().createContribution(string6, bl);
        Extension extension = this.getElementFactory().createExtension(bl);
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string5 = string.substring(n + 1);
            string4 = string.substring(0, n);
        } else {
            string5 = string;
            string4 = contribution.getDefaultNamespace();
        }
        extension.setSimpleIdentifier(string5);
        extension.setNamespaceIdentifier(string4);
        String string7 = this.translate(string2, null);
        extension.setLabel(string7);
        String string8 = string3.indexOf(46) == -1 ? String.valueOf(contribution.getDefaultNamespace()) + '.' + string3 : string3;
        extension.setExtensionPointIdentifier(string8);
        if (string5 != null && this.debug() && (iExtension = this.getExtension((String)(object2 = String.valueOf(string4) + '.' + string5))) != null) {
            String string9 = contribution.getDefaultNamespace();
            String string10 = iExtension.getContributor().getName();
            String string11 = NLS.bind((String)RegistryMessages.parse_duplicateExtension, (Object[])new String[]{string9, string10, object2});
            this.log((IStatus)new Status(2, "org.eclipse.equinox.registry", 0, string11, null));
            return false;
        }
        this.getObjectManager().add(extension, true);
        this.createExtensionData(string6, configurationElementDescription, extension, bl);
        extension.setContributorId(string6);
        object2 = new int[3];
        object2[0] = false;
        object2[1] = true;
        object2[2] = extension.getObjectId();
        contribution.setRawChildren((int[])object2);
        this.add(contribution);
        return true;
    }

    private void createExtensionData(String string, ConfigurationElementDescription configurationElementDescription, RegistryObject registryObject, boolean bl) {
        int n;
        Object[] objectArray;
        ConfigurationElement configurationElement = this.getElementFactory().createConfigurationElement(bl);
        configurationElement.setContributorId(string);
        configurationElement.setName(configurationElementDescription.getName());
        ConfigurationElementAttribute[] configurationElementAttributeArray = configurationElementDescription.getAttributes();
        if (configurationElementAttributeArray != null && configurationElementAttributeArray.length != 0) {
            int n2 = configurationElementAttributeArray.length;
            objectArray = new String[n2 * 2];
            n = 0;
            while (n < n2) {
                objectArray[n * 2] = configurationElementAttributeArray[n].getName();
                objectArray[n * 2 + 1] = this.translate(configurationElementAttributeArray[n].getValue(), null);
                ++n;
            }
            configurationElement.setProperties((String[])objectArray);
        } else {
            configurationElement.setProperties(RegistryObjectManager.EMPTY_STRING_ARRAY);
        }
        String string2 = configurationElementDescription.getValue();
        if (string2 != null) {
            configurationElement.setValue(string2);
        }
        this.getObjectManager().add(configurationElement, true);
        objectArray = configurationElementDescription.getChildren();
        if (objectArray != null) {
            n = 0;
            while (n < objectArray.length) {
                this.createExtensionData(string, (ConfigurationElementDescription)objectArray[n], configurationElement, bl);
                ++n;
            }
        }
        int[] nArray = registryObject.getRawChildren();
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + 1];
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n4] = nArray[n4];
            ++n4;
        }
        nArray2[n3] = configurationElement.getObjectId();
        registryObject.setRawChildren(nArray2);
        configurationElement.setParentId(registryObject.getObjectId());
        configurationElement.setParentType(registryObject instanceof ConfigurationElement ? (byte)1 : 2);
    }

    public boolean removeExtension(IExtension iExtension, Object object) throws IllegalArgumentException {
        if (!(iExtension instanceof ExtensionHandle)) {
            return false;
        }
        return this.removeObject(((ExtensionHandle)iExtension).getObject(), false, object);
    }

    public boolean removeExtensionPoint(IExtensionPoint iExtensionPoint, Object object) throws IllegalArgumentException {
        if (!(iExtensionPoint instanceof ExtensionPointHandle)) {
            return false;
        }
        return this.removeObject(((ExtensionPointHandle)iExtensionPoint).getObject(), true, object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeObject(RegistryObject registryObject, boolean bl, Object object) {
        if (!this.checkReadWriteAccess(object, registryObject.shouldPersist())) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.removeExtension() method. Check if proper access token is supplied.");
        }
        int n = registryObject.getObjectId();
        this.access.enterWrite();
        try {
            String string = bl ? this.removeExtensionPoint(n) : this.removeExtension(n);
            HashMap<Integer, RegistryObject> hashMap = new HashMap<Integer, RegistryObject>(1);
            hashMap.put(new Integer(n), registryObject);
            this.registryObjects.removeObjects(hashMap);
            this.registryObjects.addNavigableObjects(hashMap);
            this.getDelta(string).setObjectManager(this.registryObjects.createDelegatingObjectManager(hashMap));
            this.registryObjects.unlinkChildFromContributions(n);
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.access.exitWrite();
            return true;
        }
    }

    public Object getTemporaryUserToken() {
        return this.userToken;
    }

    protected class ListenerInfo {
        public String filter;
        public IRegistryChangeListener listener;

        public ListenerInfo(IRegistryChangeListener iRegistryChangeListener, String string) {
            this.listener = iRegistryChangeListener;
            this.filter = string;
        }

        public boolean equals(Object object) {
            return object instanceof ListenerInfo && ((ListenerInfo)object).listener == this.listener;
        }
    }

    private class QueueElement {
        Object[] listenerInfos;
        Map deltas;

        QueueElement(Object[] objectArray, Map map) {
            this.deltas = map;
            this.listenerInfos = objectArray;
        }
    }

    private class RegistryEventThread
    extends Thread {
        private ExtensionRegistry registry;

        public RegistryEventThread(ExtensionRegistry extensionRegistry2) {
            super("Extension Registry Event Dispatcher");
            this.setDaemon(true);
            this.registry = extensionRegistry2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                QueueElement queueElement;
                List list = ExtensionRegistry.this.queue;
                synchronized (list) {
                    try {
                        while (ExtensionRegistry.this.queue.isEmpty()) {
                            ExtensionRegistry.this.queue.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    queueElement = (QueueElement)ExtensionRegistry.this.queue.remove(0);
                }
                this.registry.processChangeEvent(queueElement.listenerInfos, queueElement.deltas);
            }
        }
    }
}

