/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class ReferenceMap {
    public static final int HARD = 0;
    public static final int SOFT = 1;
    private int entryCount;
    private float loadFactor;
    private transient ReferenceQueue queue = new ReferenceQueue();
    private transient int size;
    private transient IEntry[] table;
    private transient int threshold;
    int valueType;

    public ReferenceMap(int n, int n2, float f) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(" must be HARD or SOFT.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than 1.");
        }
        this.valueType = n;
        int n3 = 1;
        while (n3 < n2) {
            n3 *= 2;
        }
        this.table = new IEntry[n3];
        this.loadFactor = f;
        this.threshold = (int)((float)n3 * f);
    }

    private Object doRemove(int n) {
        int n2 = this.indexFor(n);
        IEntry iEntry = null;
        IEntry iEntry2 = this.table[n2];
        while (iEntry2 != null) {
            if (n == iEntry2.getKey()) {
                if (iEntry == null) {
                    this.table[n2] = iEntry2.getNext();
                } else {
                    iEntry.setNext(iEntry2.getNext());
                }
                --this.size;
                return iEntry2.getValue();
            }
            iEntry = iEntry2;
            iEntry2 = iEntry2.getNext();
        }
        return null;
    }

    public Object get(int n) {
        this.purge();
        IEntry iEntry = this.table[this.indexFor(n)];
        while (iEntry != null) {
            if (iEntry.getKey() == n) {
                return iEntry.getValue();
            }
            iEntry = iEntry.getNext();
        }
        return null;
    }

    private int indexFor(int n) {
        n += ~(n << 15);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += ~(n << 11);
        n ^= n >>> 16;
        return n & this.table.length - 1;
    }

    private IEntry newEntry(int n, Object object, IEntry iEntry) {
        ++this.entryCount;
        switch (this.valueType) {
            case 0: {
                return new HardRef(n, object, iEntry);
            }
            case 1: {
                return new SoftRef(n, object, iEntry, this.queue);
            }
        }
        throw new Error();
    }

    private void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.doRemove(((IEntry)((Object)reference)).getKey());
            reference.clear();
            reference = this.queue.poll();
        }
    }

    public void put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purge();
        if (this.size + 1 > this.threshold) {
            this.resize();
        }
        int n2 = this.indexFor(n);
        IEntry iEntry = null;
        IEntry iEntry2 = this.table[n2];
        while (iEntry2 != null) {
            if (n == iEntry2.getKey()) {
                if (iEntry == null) {
                    this.table[n2] = this.newEntry(n, object, iEntry2.getNext());
                } else {
                    iEntry.setNext(this.newEntry(n, object, iEntry2.getNext()));
                }
                return;
            }
            iEntry = iEntry2;
            iEntry2 = iEntry2.getNext();
        }
        ++this.size;
        this.table[n2] = this.newEntry(n, object, this.table[n2]);
    }

    public Object remove(int n) {
        this.purge();
        return this.doRemove(n);
    }

    private void resize() {
        IEntry[] iEntryArray = this.table;
        this.table = new IEntry[iEntryArray.length * 2];
        int n = 0;
        while (n < iEntryArray.length) {
            IEntry iEntry = iEntryArray[n];
            while (iEntry != null) {
                IEntry iEntry2 = iEntry;
                iEntry = iEntry.getNext();
                int n2 = this.indexFor(iEntry2.getKey());
                iEntry2.setNext(this.table[n2]);
                this.table[n2] = iEntry2;
            }
            iEntryArray[n] = null;
            ++n;
        }
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    private static class HardRef
    implements IEntry {
        private int key;
        private IEntry next;
        private Object value;

        public HardRef(int n, Object object, IEntry iEntry) {
            this.key = n;
            this.value = object;
            this.next = iEntry;
        }

        public int getKey() {
            return this.key;
        }

        public IEntry getNext() {
            return this.next;
        }

        public Object getValue() {
            return this.value;
        }

        public void setNext(IEntry iEntry) {
            this.next = iEntry;
        }

        public String toString() {
            return "HardRef(" + this.key + ',' + this.value + ')';
        }
    }

    private static interface IEntry {
        public int getKey();

        public IEntry getNext();

        public Object getValue();

        public void setNext(IEntry var1);
    }

    private static class SoftRef
    extends SoftReference
    implements IEntry {
        private int key;
        private IEntry next;

        public SoftRef(int n, Object object, IEntry iEntry, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.key = n;
            this.next = iEntry;
        }

        public int getKey() {
            return this.key;
        }

        public IEntry getNext() {
            return this.next;
        }

        public Object getValue() {
            return super.get();
        }

        public void setNext(IEntry iEntry) {
            this.next = iEntry;
        }
    }
}

