/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.Property;
import org.eclipse.core.internal.expressions.TypeExtensionManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Element;

public class TestExpression
extends Expression {
    private String fNamespace;
    private String fProperty;
    private Object[] fArgs;
    private Object fExpectedValue;
    private boolean fForcePluginActivation;
    private static final String ATT_PROPERTY = "property";
    private static final String ATT_ARGS = "args";
    private static final String ATT_FORCE_PLUGIN_ACTIVATION = "forcePluginActivation";
    private static final int HASH_INITIAL;
    private static final TypeExtensionManager fgTypeExtensionManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.TestExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
        fgTypeExtensionManager = new TypeExtensionManager("propertyTesters");
    }

    public TestExpression(IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getAttribute(ATT_PROPERTY);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new CoreException((IStatus)new ExpressionStatus(300, ExpressionMessages.TestExpression_no_name_space));
        }
        this.fNamespace = string.substring(0, n);
        this.fProperty = string.substring(n + 1);
        this.fArgs = Expressions.getArguments(iConfigurationElement, ATT_ARGS);
        this.fExpectedValue = Expressions.convertArgument(iConfigurationElement.getAttribute("value"));
        this.fForcePluginActivation = Expressions.getOptionalBooleanAttribute(iConfigurationElement, ATT_FORCE_PLUGIN_ACTIVATION);
    }

    public TestExpression(Element element) throws CoreException {
        String string = element.getAttribute(ATT_PROPERTY);
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new CoreException((IStatus)new ExpressionStatus(300, ExpressionMessages.TestExpression_no_name_space));
        }
        this.fNamespace = string.substring(0, n);
        this.fProperty = string.substring(n + 1);
        this.fArgs = Expressions.getArguments(element, ATT_ARGS);
        String string2 = element.getAttribute("value");
        this.fExpectedValue = Expressions.convertArgument(string2.length() > 0 ? string2 : null);
        this.fForcePluginActivation = Expressions.getOptionalBooleanAttribute(element, ATT_FORCE_PLUGIN_ACTIVATION);
    }

    public TestExpression(String string, String string2, Object[] objectArray, Object object) {
        this(string, string2, objectArray, object, false);
    }

    public TestExpression(String string, String string2, Object[] objectArray, Object object, boolean bl) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.fNamespace = string;
        this.fProperty = string2;
        this.fArgs = objectArray != null ? objectArray : Expressions.EMPTY_ARGS;
        this.fExpectedValue = object;
        this.fForcePluginActivation = bl;
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        Object object = iEvaluationContext.getDefaultVariable();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.System");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(object)) {
            String string = System.getProperty(this.fProperty);
            if (string == null) {
                return EvaluationResult.FALSE;
            }
            return EvaluationResult.valueOf(string.equals(this.fArgs[0]));
        }
        Property property = fgTypeExtensionManager.getProperty(object, this.fNamespace, this.fProperty, iEvaluationContext.getAllowPluginActivation() && this.fForcePluginActivation);
        if (!property.isInstantiated()) {
            return EvaluationResult.NOT_LOADED;
        }
        return EvaluationResult.valueOf(property.test(object, this.fArgs, this.fExpectedValue));
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        expressionInfo.markDefaultVariableAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TestExpression)) {
            return false;
        }
        TestExpression testExpression = (TestExpression)object;
        return this.fNamespace.equals(testExpression.fNamespace) && this.fProperty.equals(testExpression.fProperty) && this.fForcePluginActivation == testExpression.fForcePluginActivation && TestExpression.equals(this.fArgs, testExpression.fArgs) && TestExpression.equals(this.fExpectedValue, testExpression.fExpectedValue);
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + TestExpression.hashCode(this.fArgs) * 89 + TestExpression.hashCode(this.fExpectedValue) * 89 + this.fNamespace.hashCode() * 89 + this.fProperty.hashCode() * 89 + (this.fForcePluginActivation ? 1 : 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fArgs.length) {
            Object object = this.fArgs[n];
            if (object instanceof String) {
                stringBuffer.append('\'');
                stringBuffer.append(object);
                stringBuffer.append('\'');
            } else {
                stringBuffer.append(object.toString());
            }
            if (n < this.fArgs.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return "<test property=\"" + this.fProperty + (this.fArgs.length != 0 ? "\" args=\"" + stringBuffer + "\"" : "\"") + (this.fExpectedValue != null ? "\" value=\"" + this.fExpectedValue + "\"" : "\"") + " plug-in activation: " + (this.fForcePluginActivation ? "eager" : "lazy") + "/>";
    }

    public boolean testGetForcePluginActivation() {
        return this.fForcePluginActivation;
    }

    public static TypeExtensionManager testGetTypeExtensionManager() {
        return fgTypeExtensionManager;
    }
}

