/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import org.eclipse.ercp.swt.mobile.CompositeLayout;
import org.eclipse.ercp.swt.mobile.ListBoxData;
import org.eclipse.ercp.swt.mobile.ListBoxItem;
import org.eclipse.ercp.swt.mobile.ListBoxLayout;
import org.eclipse.ercp.swt.mobile.ListComposite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class ListBox
extends Scrollable {
    ListBoxItem[] fItems = null;
    Label[] fLabels = new Label[40];
    int fLabelCount = 0;
    int fColumns = 0;
    int[] fColumnWidth;
    int fLayoutStyle = 0;
    Canvas fComposite;
    Composite innerComposite;
    Composite parentComposite;
    static Composite hackComposite;
    static int hackStyle;
    int widgetStyle;
    ListBoxLayout fListBoxLayout;
    int[] selectedIndex = new int[100];
    int selectedCount = 0;
    final Display display = this.getDisplay();
    Color textFocusColor = this.display.getSystemColor(27);
    Color focusColor = this.display.getSystemColor(25);
    Color focusAndSelColor = null;
    Color selectedColor = this.display.getSystemColor(26);
    Color normalColor = this.display.getSystemColor(20);
    int setWidth = -1;
    int setHeight = -1;
    int scrollbarWidthHeight = 12;
    ScrollBar fVScrollBar = null;
    ScrollBar fHScrollBar = null;
    boolean ifVscrollBar = false;
    boolean ifHscrollBar = false;
    int ScrollY = 0;
    int detailPosition = 0;
    int headingPosition = 0;
    int headingIconPosition = 0;
    boolean twoLine = false;
    private boolean isDispose = false;
    boolean styleDefined = false;
    boolean showNumber = false;
    boolean showHeadingText = false;
    boolean showHeadingIcon = false;
    boolean showDetailIcon = false;
    boolean twoline = false;
    boolean oneline = false;
    int preferredWidth = 0;
    int preferredHeight = 0;
    Listener keyListener;
    ListComposite[] listCells = new ListComposite[40];
    private int focusIndex = 0;
    private Font font = null;
    private Font headingFont = null;
    public static final int LB_STYLE_NO_HEADING_TEXT = 0;
    public static final int LB_STYLE_1LINE_ITEM = 1;
    public static final int LB_STYLE_2LINE_ITEM = 2;
    public static final int LB_MOD_SHOW_SELECTION_NUMBER = 16;
    public static final int LB_MOD_SHOW_HEADING_ICONS = 32;
    public static final int LB_MOD_SHOW_DETAIL_ICONS = 64;

    public ListBox(Composite parent, int style, int layoutStyle) {
        super(ListBox.SaveStyle(parent, style), 0);
        this.widgetStyle = style;
        if ((this.widgetStyle & 2) != 2) {
            this.widgetStyle |= 4;
        }
        if (parent == null) {
            SWT.error(4);
        }
        this.fLayoutStyle = layoutStyle;
        if ((style & 0x200) == 512) {
            this.ifVscrollBar = true;
        }
        if ((style & 0x100) == 256) {
            this.ifHscrollBar = true;
        }
        this.fListBoxLayout = new ListBoxLayout();
        this.innerComposite.setLayout(this.fListBoxLayout);
        final ListBox lb = this;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!lb.isDisposed()) {
                    lb.parentDispose();
                }
            }
        });
        int red = this.selectedColor.getRGB().red - 30;
        int green = this.selectedColor.getRGB().green + 30;
        int blue = this.selectedColor.getRGB().blue + 30;
        if (red < 0) {
            red = 0;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        this.focusAndSelColor = new Color(this.display, new RGB(red, green, blue));
        this.parentComposite = hackComposite;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (this.fItems != null && index < this.fItems.length && index >= 0) {
            for (int i = 0; i < this.selectedCount; ++i) {
                if (index != this.selectedIndex[i]) continue;
                this.unfillRow(index);
                this.shrink(i);
            }
        }
    }

    void shrink(int index) {
        for (int i = index; i < this.selectedCount; ++i) {
            if (i == this.selectedCount - 1) {
                --this.selectedCount;
                continue;
            }
            this.selectedIndex[i] = this.selectedIndex[i + 1];
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        for (int i = start; i <= end; ++i) {
            this.deselect(i);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.deselect(indices[i]);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if (this.fItems != null) {
            for (int i = 0; i < this.fItems.length; ++i) {
                this.deselect(i);
            }
            this.selectedCount = 0;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.getSize();
    }

    public int getFocusIndex() {
        this.checkWidget();
        return this.focusIndex;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selectedCount;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] result = new int[this.selectedCount];
        System.arraycopy(this.selectedIndex, 0, result, 0, this.selectedCount);
        for (int i = 0; i < this.selectedCount - 1; ++i) {
            for (int j = 0; j < this.selectedCount - 1; ++j) {
                if (result[j] <= result[j + 1]) continue;
                int temp = result[j];
                result[j] = result[j + 1];
                result[j + 1] = temp;
            }
        }
        return result;
    }

    public void refreshItem(int index) {
        this.checkWidget();
        if (this.fItems != null) {
            if (index < 0 || index >= this.fItems.length) {
                SWT.error(6);
            }
            int row = index;
            int start = row * this.fColumns;
            if (this.showNumber) {
                ++start;
            }
            if (this.showHeadingIcon) {
                if (this.fItems[row].getHeadingIcons() != null) {
                    this.fLabels[start].setImage(this.fItems[row].getHeadingIcons()[0]);
                    this.fLabels[start].pack();
                    this.listCells[start].setSize(this.fLabels[start].getSize());
                }
                ++start;
            }
            if (this.oneline) {
                this.fLabels[start].setText(this.getheading(row));
                this.fLabels[start].setFont(this.headingFont);
                this.fLabels[start].pack();
                this.listCells[start].setSize(this.fLabels[start].getSize());
                this.fLabels[++start].setText(this.fItems[row].getDetailText());
                this.fLabels[start].setFont(this.font);
                this.fLabels[start].pack();
                this.listCells[start].setSize(this.fLabels[start].getSize());
                ++start;
            } else if (this.twoLine) {
                String text = new String();
                text = this.getheading(row);
                this.fLabels[start].setText(text);
                this.fLabels[start].setFont(this.headingFont);
                this.fLabels[start].pack();
                this.listCells[start].setSize(this.fLabels[start].getSize());
                ++start;
            } else {
                this.fLabels[start].setText(this.fItems[row].getDetailText());
                this.fLabels[start].setFont(this.font);
                this.fLabels[start].pack();
                this.listCells[start].setSize(this.fLabels[start].getSize());
            }
            if (this.showDetailIcon) {
                if (this.fItems[row].getDetailIcons() != null) {
                    this.fLabels[start].setImage(this.fItems[row].getDetailIcons()[0]);
                    this.fLabels[start].pack();
                    this.listCells[start].setSize(this.fLabels[start].getSize());
                }
                ++start;
            }
            if (this.twoLine) {
                this.fLabels[start].setText(this.fItems[row].getDetailText());
                this.fLabels[start].setFont(this.font);
                this.fLabels[start].pack();
                this.listCells[start].setSize(this.fLabels[start].getSize());
            }
            this.updateSize();
        }
    }

    public void refreshList() {
        this.checkWidget();
        if (this.fItems != null) {
            for (int i = 0; i < this.fItems.length; ++i) {
                this.refreshItem(i);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (null == font) {
            this.font = this.getDisplay().getSystemFont();
        } else if (font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        for (int i = 0; i < this.fLabelCount; ++i) {
            if (i % this.fColumns != this.detailPosition) continue;
            this.fLabels[i].setFont(font);
        }
        this.updateSize();
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.getDisplay().getSystemFont();
    }

    public void setHeadingFont(Font font) {
        this.checkWidget();
        if (null == font) {
            this.headingFont = this.getDisplay().getSystemFont();
        } else if (font.isDisposed()) {
            SWT.error(5);
        }
        this.headingFont = font;
        for (int i = 0; i < this.fLabelCount; ++i) {
            if (this.headingPosition == 0 || i % this.fColumns != this.headingPosition) continue;
            this.fLabels[i].setFont(font);
        }
        this.updateSize();
    }

    public void select(int index) {
        this.checkWidget();
        if (this.fItems != null) {
            if ((this.widgetStyle & 4) == 4) {
                this.deselectAll();
            }
            if (index < this.fItems.length && index >= 0) {
                for (int i = 0; i < this.selectedCount; ++i) {
                    if (this.selectedIndex[i] != index) continue;
                    this.fillRow(index, this.selectedColor);
                    return;
                }
                this.selectedIndex[this.selectedCount] = index;
                ++this.selectedCount;
                if (this.selectedCount == this.selectedIndex.length) {
                    int[] newArray = new int[this.selectedIndex.length * 2];
                    System.arraycopy(this.selectedIndex, 0, newArray, 0, this.selectedIndex.length);
                    this.selectedIndex = newArray;
                }
                this.fillRow(index, this.selectedColor);
            }
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (this.fItems != null) {
            if ((this.widgetStyle & 4) == 4) {
                if (start == end && start >= 0 && end < this.fItems.length) {
                    this.select(start);
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    this.select(i);
                }
            }
        }
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        if ((this.widgetStyle & 4) == 4) {
            if (indices.length > 1 || indices.length == 0) {
                return;
            }
            this.select(indices[0]);
        } else {
            for (int i = 0; i < indices.length; ++i) {
                this.select(indices[i]);
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if (this.fItems != null && (this.widgetStyle & 4) != 4) {
            for (int i = 0; i < this.fItems.length; ++i) {
                this.select(i);
            }
        }
    }

    public void setDataModel(ListBoxItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
        }
        this.selectedCount = 0;
        this.fItems = items;
        this.deleteContent();
        this.createContent();
        Control[] children = this.innerComposite.getTabList();
        for (int i = 0; i < children.length; ++i) {
            final int index = i;
            final ListBox listBox = this;
            children[i].addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    listBox.forceFocus();
                    ListBox.this.pressed(index);
                    listBox.internal_sendEvent(14);
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            Control[] grandchildren = ((Composite)children[i]).getChildren();
            for (int j = 0; j < grandchildren.length; ++j) {
                grandchildren[j].addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        listBox.forceFocus();
                        ListBox.this.pressed(index);
                        listBox.internal_sendEvent(14);
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
            }
        }
    }

    void pressed(int index) {
        int row = index / this.fColumns;
        if ((this.widgetStyle & 4) == 4) {
            this.deselectAll();
        }
        if (!this.isSelectedItem(this.focusIndex)) {
            this.unfillRow(this.focusIndex);
        } else {
            this.setKeyStrokeColor(this.focusIndex, this.selectedColor);
        }
        this.focusIndex = row;
        if ((this.widgetStyle & 4) == 4) {
            this.setSelection(row);
        } else if ((this.widgetStyle & 2) == 2) {
            for (int i = 0; i < this.selectedCount; ++i) {
                if (this.selectedIndex[i] != row) continue;
                this.deselect(row);
                return;
            }
            this.select(row);
        }
    }

    private void setKeyStrokeColor(int index, Color backgroundColor) {
        if (this.fItems != null && index < this.fItems.length && index >= 0) {
            this.fillRow(index, backgroundColor);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        for (int i = this.selectedCount - 1; i >= 0; --i) {
            this.deselect(this.selectedIndex[i]);
        }
        this.selectedCount = 0;
        this.select(index);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        for (int i = this.selectedCount - 1; i >= 0; --i) {
            this.deselect(this.selectedIndex[i]);
        }
        if ((this.widgetStyle & 4) == 4) {
            if (start == end) {
                this.setSelection(start);
            }
        } else {
            this.selectedCount = 0;
            this.select(start, end);
        }
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        for (int i = this.selectedCount - 1; i >= 0; --i) {
            this.deselect(this.selectedIndex[i]);
        }
        if ((this.widgetStyle & 4) != 0 && indices.length > 1) {
            return;
        }
        if (indices == null) {
            SWT.error(4);
        }
        this.selectedCount = 0;
        this.select(indices);
    }

    public void showSelection() {
        this.checkWidget();
        int[] selected = this.getSelectionIndices();
        Rectangle r = this.listCells[selected[0] * this.fColumns].getBounds();
        if (r.y > this.ScrollY && r.y + r.height < this.ScrollY + this.fComposite.getClientArea().height) {
            return;
        }
        Rectangle innerR = this.innerComposite.getBounds();
        if (r.y >= innerR.height - this.fComposite.getClientArea().height) {
            r.y = innerR.height - this.fComposite.getClientArea().height;
        }
        this.ScrollY = r.y;
        this.innerComposite.setBounds(innerR.x, -r.y, innerR.width, innerR.height);
        if (this.fVScrollBar != null) {
            int max = this.fVScrollBar.getMaximum() - this.fVScrollBar.getThumb();
            int min = this.fVScrollBar.getMinimum();
            int diff = this.innerComposite.getBounds().height - this.fComposite.getClientArea().height;
            int percent = r.y * (max - min);
            if (diff == 0) {
                return;
            }
            int value = percent / diff;
            if (value >= this.fVScrollBar.getMaximum()) {
                value = this.fVScrollBar.getMaximum();
            }
            this.fVScrollBar.setSelection(value);
        }
    }

    void scrollNext(int focusIndex) {
        Rectangle r = this.listCells[focusIndex * this.fColumns].getBounds();
        if (r.y > this.ScrollY && r.y + r.height < this.ScrollY + this.fComposite.getClientArea().height) {
            return;
        }
        Rectangle innerR = this.innerComposite.getBounds();
        r.y = r.y + r.height < this.fComposite.getClientArea().height ? 0 : r.y + r.height - this.fComposite.getClientArea().height;
        this.ScrollY = r.y;
        this.innerComposite.setBounds(innerR.x, -r.y, innerR.width, innerR.height);
        if (this.fVScrollBar != null) {
            int diff;
            int min;
            int max = this.fVScrollBar.getMaximum() - this.fVScrollBar.getThumb();
            int percent = (r.y + r.height) * (max - (min = this.fVScrollBar.getMinimum()));
            int value = percent / (diff = this.innerComposite.getBounds().height - this.fComposite.getClientArea().height);
            if (value >= this.fVScrollBar.getMaximum()) {
                value = this.fVScrollBar.getMaximum() + 1;
            }
            this.fVScrollBar.setSelection(value);
        }
    }

    void updateSize() {
        if (this.setWidth != -1 && this.setHeight != -1) {
            this.setSize(this.setWidth, this.setHeight);
        } else {
            this.pack();
        }
    }

    public void pack() {
        this.checkWidget();
        this.setWidth = -1;
        this.setHeight = -1;
        for (int i = 0; i < this.fLabelCount; ++i) {
            this.listCells[i].setSize(this.fLabels[i].getSize());
        }
        this.innerComposite.pack();
        this.preferredWidth = this.innerComposite.getSize().x;
        this.preferredHeight = this.innerComposite.getSize().y;
        this.fComposite.pack();
        this.fVScrollBar = this.fComposite.getVerticalBar();
        if (this.fVScrollBar != null) {
            this.fVScrollBar.setVisible(false);
        }
        if ((this.fHScrollBar = this.fComposite.getHorizontalBar()) != null) {
            this.fHScrollBar.setVisible(false);
        }
        this.vCenterTexts();
    }

    public void setBounds(int x, int y, int w, int h) {
        this.checkWidget();
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    public void setSize(int w, int h) {
        this.checkWidget();
        this.fHScrollBar = this.fComposite.getHorizontalBar();
        if (this.fHScrollBar != null) {
            if (w < this.preferredWidth) {
                this.fHScrollBar.setVisible(true);
            } else {
                this.fHScrollBar.setVisible(false);
            }
        }
        if ((this.fVScrollBar = this.fComposite.getVerticalBar()) != null) {
            if (h < this.preferredHeight) {
                this.fVScrollBar.setVisible(true);
            } else {
                this.fVScrollBar.setVisible(false);
            }
        }
        if (w < 0 || h < 0) {
            return;
        }
        this.setWidth = w;
        this.setHeight = h;
        super.setSize(w, h);
        for (int i = 0; i < this.fLabelCount; ++i) {
            this.listCells[i].setSize(this.fLabels[i].getSize());
        }
        this.innerComposite.pack();
        this.fComposite.setSize(w, h);
        if (this.fItems != null) {
            int page;
            this.fVScrollBar = this.fComposite.getVerticalBar();
            if (this.fVScrollBar != null) {
                this.fVScrollBar.setMaximum(this.innerComposite.getSize().y);
                page = this.fComposite.getClientArea().height;
                this.fVScrollBar.setThumb(page);
                this.fVScrollBar.setPageIncrement(page);
                this.fVScrollBar.setIncrement(page / 10);
                this.fVScrollBar.setMinimum(0);
            }
            if ((this.fHScrollBar = this.fComposite.getHorizontalBar()) != null) {
                this.fHScrollBar.setMaximum(this.innerComposite.getSize().x);
                page = this.fComposite.getClientArea().width;
                this.fHScrollBar.setThumb(page);
                this.fHScrollBar.setPageIncrement(page);
                this.fHScrollBar.setIncrement(page / 10);
                this.fHScrollBar.setMinimum(0);
            }
        }
        this.vCenterTexts();
    }

    void vCenterTexts() {
        for (int i = 0; i < this.fLabelCount; ++i) {
            Point p;
            Point pp;
            int col = i % this.fColumns;
            if (this.showNumber && col == 0) {
                pp = this.listCells[i].getSize();
                p = this.fLabels[i].getSize();
                this.fLabels[i].setLocation((pp.x - p.x) / 2, (pp.y - p.y) / 2);
            }
            if (this.oneline || this.twoLine) {
                if (col == this.detailPosition || col == this.headingPosition) {
                    pp = this.listCells[i].getSize();
                    p = this.fLabels[i].getSize();
                    this.fLabels[i].setLocation((pp.x - p.x) / 2, (pp.y - p.y) / 2);
                }
            } else if (col == this.detailPosition) {
                pp = this.listCells[i].getSize();
                p = this.fLabels[i].getSize();
                this.fLabels[i].setLocation((pp.x - p.x) / 2, (pp.y - p.y) / 2);
            }
            if (this.showDetailIcon) {
                if (this.twoLine) {
                    if (col == this.fColumns - 2) {
                        pp = this.listCells[i].getSize();
                        p = this.fLabels[i].getSize();
                        this.fLabels[i].setLocation(pp.x - p.x, pp.y - p.y);
                    }
                } else if (col == this.fColumns - 1) {
                    pp = this.listCells[i].getSize();
                    p = this.fLabels[i].getSize();
                    this.fLabels[i].setLocation(pp.x - p.x, pp.y - p.y);
                }
            }
            if (!this.showHeadingIcon || col != this.headingIconPosition) continue;
            pp = this.listCells[i].getSize();
            p = this.fLabels[i].getSize();
            this.fLabels[i].setLocation((pp.x - p.x) / 2, (pp.y - p.y) / 2);
        }
    }

    public void internal_createHandle(int index) {
        this.fComposite = new Canvas(hackComposite, hackStyle);
        CompositeLayout layout = new CompositeLayout();
        this.fComposite.setLayout(layout);
        this.innerComposite = new Composite(this.fComposite, 0);
        this.innerComposite.setBackground(new Color(this.display, 0, 0, 0));
        this.fComposite.setBackground(new Color(this.display, 215, 215, 255));
        this.internal_handle = this.fComposite.internal_handle;
        hackComposite.internal_removeChild(this.fComposite);
    }

    private static Composite SaveStyle(Composite parent, int style) {
        hackStyle = style;
        hackComposite = parent;
        return parent;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        for (int i = 0; i < this.fLabelCount; ++i) {
            if (this.fLabels[i] == null) continue;
            this.fLabels[i].dispose();
            this.fLabels[i] = null;
            this.listCells[i].dispose();
            this.listCells[i] = null;
        }
        this.fLabelCount = 0;
        if (this.innerComposite != null) {
            this.innerComposite.dispose();
            this.innerComposite = null;
        }
        super.dispose();
        this.parentComposite.internal_removeChild(this);
        this.isDispose = true;
    }

    protected void removeInternalFilter() {
        if (this.keyListener != null) {
            this.getDisplay().removeFilter(1, this.keyListener);
        }
    }

    private void parentDispose() {
        for (int i = 0; i < this.fLabelCount; ++i) {
            if (this.fLabels[i] == null) continue;
            this.fLabels[i].dispose();
            this.fLabels[i] = null;
        }
        this.fLabelCount = 0;
        if (this.innerComposite != null) {
            this.innerComposite.dispose();
            this.innerComposite = null;
        }
        this.parentComposite.internal_removeChild(this);
        this.isDispose = true;
    }

    public boolean isDisposed() {
        return this.isDispose;
    }

    public ScrollBar getVerticalBar() {
        if (this.fComposite.getVerticalBar() != null) {
            return this.fComposite.getVerticalBar();
        }
        return null;
    }

    public ScrollBar getHorizontalBar() {
        if (this.fComposite.getHorizontalBar() != null) {
            return this.fComposite.getHorizontalBar();
        }
        return null;
    }

    void deleteContent() {
        for (int i = 0; i < this.fLabelCount; ++i) {
            this.fLabels[i].dispose();
            this.listCells[i].dispose();
        }
        this.fLabelCount = 0;
        this.removeInternalFilter();
    }

    void createContent() {
        this.fColumns = 0;
        this.setColumns();
        if (this.fItems != null) {
            for (int i = 0; i < this.fItems.length; ++i) {
                Label l;
                if (this.showNumber) {
                    l = new Label(this.innerComposite, 0);
                    l.setText(Integer.toString(i + 1));
                    FontData fontData = l.getFont().getFontData()[0];
                    Font font = new Font(this.display, fontData.getName(), fontData.getHeight(), 1);
                    l.setFont(font);
                    this.newLabel(l);
                    l = null;
                }
                if (this.showHeadingIcon) {
                    l = new Label(this.innerComposite, 0);
                    if (this.fItems[i] != null && this.fItems[i].getHeadingIcons() != null) {
                        l.setImage(this.fItems[i].getHeadingIcons()[0]);
                    }
                    this.newLabel(l);
                    l = null;
                }
                if (this.oneline) {
                    this.styleDefined = true;
                    l = new Label(this.innerComposite, 0);
                    l.setText(this.getheading(i));
                    l.setFont(this.headingFont);
                    this.newLabel(l);
                    l = new Label(this.innerComposite, 0);
                    if (this.fItems[i] != null) {
                        l.setText(this.fItems[i].getDetailText());
                        l.setFont(this.font);
                    }
                    this.newLabel(l);
                    l = null;
                } else if (this.twoLine) {
                    this.styleDefined = true;
                    String text = new String();
                    text = this.getheading(i);
                    Label l2 = new Label(this.innerComposite, 0);
                    l2.setText(text);
                    l2.setFont(this.headingFont);
                    this.newLabel(l2);
                    Object var3_4 = null;
                } else {
                    l = new Label(this.innerComposite, 0);
                    if (this.fItems[i] != null) {
                        l.setText(this.fItems[i].getDetailText());
                        l.setFont(this.font);
                    }
                    this.newLabel(l);
                    l = null;
                }
                if (this.showDetailIcon) {
                    l = new Label(this.innerComposite, 0);
                    if (this.fItems[i] != null && this.fItems[i].getDetailIcons() != null) {
                        l.setImage(this.fItems[i].getDetailIcons()[0]);
                    }
                    this.newLabel(l);
                    l = null;
                }
                if (!this.twoLine) continue;
                l = new Label(this.innerComposite, 0);
                if (this.fItems[i] != null) {
                    l.setText(this.fItems[i].getDetailText());
                    l.setFont(this.font);
                }
                this.newLabel(l);
            }
        }
        this.updateSize();
        if (this.fComposite.getVerticalBar() != null) {
            this.fVScrollBar = this.fComposite.getVerticalBar();
            this.fVScrollBar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int sel = ListBox.this.fVScrollBar.getSelection();
                    ListBox.this.doScroll(ListBox.this.fVScrollBar, sel);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.fComposite.getHorizontalBar() != null) {
            this.fHScrollBar = this.fComposite.getHorizontalBar();
            this.fHScrollBar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int sel = ListBox.this.fHScrollBar.getSelection();
                    ListBox.this.doScroll(ListBox.this.fHScrollBar, sel);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        final Display display = this.getDisplay();
        final ListBox lb = this;
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ListBox.this.fItems.length > 0) {
                    if (!ListBox.this.isSelectedItem(ListBox.this.focusIndex)) {
                        ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.focusColor);
                    } else {
                        ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.focusAndSelColor);
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                if (!ListBox.this.isSelectedItem(ListBox.this.focusIndex)) {
                    ListBox.this.unfillRow(ListBox.this.focusIndex);
                } else {
                    ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.selectedColor);
                }
            }
        });
        this.keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (display.getFocusControl() == lb) {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            if (!ListBox.this.isSelectedItem(ListBox.this.focusIndex)) {
                                ListBox.this.unfillRow(ListBox.this.focusIndex);
                            } else {
                                ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.selectedColor);
                            }
                            ListBox.this.focusIndex--;
                            if (ListBox.this.focusIndex < 0) {
                                ListBox.this.focusIndex = ListBox.this.fItems.length - 1;
                            }
                            if (!ListBox.this.isSelectedItem(ListBox.this.focusIndex)) {
                                ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.focusColor);
                            } else {
                                ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.focusAndSelColor);
                            }
                            ((ListBox)lb).internal_sendEvent(13);
                            ListBox.this.showFocusedItem(ListBox.this.focusIndex);
                            break;
                        }
                        case 0x1000002: {
                            if (!ListBox.this.isSelectedItem(ListBox.this.focusIndex)) {
                                ListBox.this.unfillRow(ListBox.this.focusIndex);
                            } else {
                                ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.selectedColor);
                            }
                            ListBox.this.focusIndex++;
                            if (ListBox.this.focusIndex == ListBox.this.fItems.length) {
                                ListBox.this.focusIndex = 0;
                            }
                            if (!ListBox.this.isSelectedItem(ListBox.this.focusIndex)) {
                                ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.focusColor);
                            } else {
                                ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.focusAndSelColor);
                            }
                            ((ListBox)lb).internal_sendEvent(13);
                            if (ListBox.this.focusIndex == 0) {
                                ListBox.this.showFocusedItem(ListBox.this.focusIndex);
                                break;
                            }
                            ListBox.this.scrollNext(ListBox.this.focusIndex);
                            break;
                        }
                        case 13: {
                            if ((ListBox.this.widgetStyle & 4) != 4) {
                                ListBox.this.deselectAll();
                                ListBox.this.select(ListBox.this.focusIndex);
                            } else if (ListBox.this.isSelectedItem(ListBox.this.focusIndex)) {
                                ListBox.this.deselect(ListBox.this.focusIndex);
                                ListBox.this.setKeyStrokeColor(ListBox.this.focusIndex, ListBox.this.focusColor);
                            } else {
                                ListBox.this.select(ListBox.this.focusIndex);
                            }
                            ((ListBox)lb).internal_sendEvent(14);
                            break;
                        }
                        case 49: 
                        case 0x1000031: {
                            ListBox.this.select(0);
                            break;
                        }
                        case 50: 
                        case 16777266: {
                            ListBox.this.select(1);
                            break;
                        }
                        case 51: 
                        case 0x1000033: {
                            ListBox.this.select(2);
                            break;
                        }
                        case 52: 
                        case 16777268: {
                            ListBox.this.select(3);
                            break;
                        }
                        case 53: 
                        case 16777269: {
                            ListBox.this.select(4);
                            break;
                        }
                        case 54: 
                        case 16777270: {
                            ListBox.this.select(5);
                            break;
                        }
                        case 55: 
                        case 16777271: {
                            ListBox.this.select(6);
                            break;
                        }
                        case 56: 
                        case 16777272: {
                            ListBox.this.select(7);
                            break;
                        }
                        case 57: 
                        case 16777273: {
                            ListBox.this.select(8);
                        }
                    }
                }
            }
        };
        display.addFilter(1, this.keyListener);
    }

    private void showFocusedItem(int index) {
        Rectangle r = this.listCells[index * this.fColumns].getBounds();
        if (r.y > this.ScrollY && r.y + r.height < this.ScrollY + this.fComposite.getClientArea().height) {
            return;
        }
        Rectangle innerR = this.innerComposite.getBounds();
        if (r.y >= innerR.height - this.fComposite.getClientArea().height) {
            r.y = innerR.height - this.fComposite.getClientArea().height;
        }
        this.ScrollY = r.y;
        this.innerComposite.setBounds(innerR.x, -r.y, innerR.width, innerR.height);
        if (this.fVScrollBar != null) {
            int max = this.fVScrollBar.getMaximum() - this.fVScrollBar.getThumb();
            int min = this.fVScrollBar.getMinimum();
            int diff = this.innerComposite.getBounds().height - this.fComposite.getClientArea().height;
            int percent = r.y * (max - min);
            if (diff == 0) {
                return;
            }
            int value = percent / diff;
            if (value >= this.fVScrollBar.getMaximum()) {
                value = this.fVScrollBar.getMaximum();
            }
            this.fVScrollBar.setSelection(value);
        }
    }

    boolean isSelectedItem(int index) {
        boolean isSelected = false;
        for (int num = 0; num < this.selectedCount; ++num) {
            if (this.selectedIndex[num] != index) continue;
            isSelected = true;
            break;
        }
        return isSelected;
    }

    void doScroll(ScrollBar scrollbar, int value) {
        int max = scrollbar.getMaximum() - scrollbar.getThumb();
        int min = scrollbar.getMinimum();
        Rectangle innerRect = this.innerComposite.getBounds();
        if (scrollbar == this.fHScrollBar) {
            int diff = innerRect.width - this.fComposite.getClientArea().width;
            int Scale = diff * value / (max - min);
            this.innerComposite.setBounds(-Scale, innerRect.y, innerRect.width, innerRect.height);
        } else {
            int Scale;
            int diff = innerRect.height - this.fComposite.getClientArea().height;
            this.ScrollY = Scale = diff * value / (max - min);
            this.innerComposite.setBounds(innerRect.x, -value, innerRect.width, innerRect.height);
        }
    }

    void setColumns() {
        if ((this.fLayoutStyle & 1) == 1) {
            this.oneline = true;
            ++this.detailPosition;
            this.fColumns += 2;
        } else if ((this.fLayoutStyle & 2) == 2) {
            this.twoLine = true;
            ++this.detailPosition;
            this.fColumns += 2;
        } else {
            ++this.fColumns;
        }
        if ((this.fLayoutStyle & 0x10) == 16) {
            this.showNumber = true;
            ++this.detailPosition;
            ++this.headingPosition;
            ++this.headingIconPosition;
            ++this.fColumns;
        }
        if ((this.fLayoutStyle & 0x20) == 32) {
            this.showHeadingIcon = true;
            ++this.headingPosition;
            ++this.detailPosition;
            ++this.fColumns;
        }
        if ((this.fLayoutStyle & 0x40) == 64) {
            this.showDetailIcon = true;
            if (this.twoLine) {
                ++this.detailPosition;
            }
            ++this.fColumns;
        }
        this.fListBoxLayout.numColumns = this.twoLine ? this.fColumns - 1 : this.fColumns;
        this.fListBoxLayout.verticalSpacing = 0;
        this.fListBoxLayout.horizontalSpacing = 0;
        this.fListBoxLayout.marginWidth = 1;
        this.fListBoxLayout.marginHeight = 1;
        this.fListBoxLayout.makeColumnsEqualWidth = false;
    }

    void newLabel(Label l) {
        Control[] newArray;
        if (this.fLabelCount == this.fLabels.length) {
            newArray = new Label[this.fLabels.length * 2];
            System.arraycopy(this.fLabels, 0, newArray, 0, this.fLabels.length);
            this.fLabels = newArray;
        }
        if (this.fLabelCount == this.listCells.length) {
            newArray = new ListComposite[this.listCells.length * 2];
            System.arraycopy(this.listCells, 0, newArray, 0, this.listCells.length);
            this.listCells = newArray;
        }
        ListBoxData lbd = new ListBoxData(1808);
        lbd.verticalIndent = 1;
        lbd.horizontalIndent = 0;
        if (this.fLabelCount % this.fColumns == this.detailPosition) {
            lbd.horizontalIndent = 1;
        }
        if (this.showNumber) {
            if (this.fLabelCount % this.fColumns == 1) {
                lbd.horizontalIndent = 1;
            }
        } else if (this.showHeadingIcon && !this.styleDefined && this.fLabelCount % this.fColumns == this.detailPosition) {
            lbd.horizontalIndent = 0;
        }
        if (this.twoLine) {
            if (this.fLabelCount % this.fColumns != this.detailPosition && this.fLabelCount % this.fColumns != this.headingPosition) {
                lbd.verticalSpan = 2;
            } else if (this.fLabelCount % this.fColumns == this.headingPosition) {
                if (this.showHeadingIcon) {
                    lbd.verticalIndent = 1;
                    lbd.horizontalIndent = 0;
                } else if (this.showNumber) {
                    lbd.verticalIndent = 1;
                    lbd.horizontalIndent = 1;
                } else {
                    lbd.verticalIndent = 1;
                    lbd.horizontalIndent = 0;
                }
            } else if (this.fLabelCount % this.fColumns == this.detailPosition) {
                if (this.showHeadingIcon) {
                    lbd.verticalIndent = 0;
                    lbd.horizontalIndent = 0;
                } else if (this.showNumber) {
                    lbd.verticalIndent = 0;
                    lbd.horizontalIndent = 1;
                } else {
                    lbd.verticalIndent = 0;
                    lbd.horizontalIndent = 0;
                }
            } else {
                lbd.verticalIndent = 0;
                lbd.horizontalIndent = 1;
            }
        }
        if (this.fLabelCount < this.fColumns) {
            lbd.verticalIndent = 0;
        }
        if ((this.widgetStyle & 0x800) != 2048) {
            lbd.verticalIndent = 0;
            lbd.horizontalIndent = 0;
        }
        this.listCells[this.fLabelCount] = new ListComposite(this.innerComposite, 0);
        this.listCells[this.fLabelCount].setLayoutData(lbd);
        this.fLabels[this.fLabelCount] = l;
        this.fLabels[this.fLabelCount].setParent(this.listCells[this.fLabelCount]);
        this.fLabels[this.fLabelCount].pack();
        this.fLabels[this.fLabelCount].setBackground(this.normalColor);
        this.listCells[this.fLabelCount].setBackground(this.normalColor);
        ++this.fLabelCount;
    }

    void fillRow(int index, Color backgroundColor) {
        int target;
        for (int i = target = this.fColumns * index; i < target + this.fColumns; ++i) {
            if (this.fLabels[i].getImage() != null) continue;
            this.fLabels[i].setForeground(this.textFocusColor);
            this.fLabels[i].setBackground(backgroundColor);
            this.listCells[i].setBackground(backgroundColor);
        }
    }

    void unfillRow(int index) {
        int target;
        for (int i = target = this.fColumns * index; i < target + this.fColumns; ++i) {
            this.fLabels[i].setForeground(null);
            this.fLabels[i].setBackground(this.normalColor);
            this.listCells[i].setBackground(this.normalColor);
        }
    }

    String getheading(int i) {
        if (this.fItems[i] != null) {
            String s = this.fItems[i].getHeadingText();
            if (s == null) {
                return "";
            }
            return s;
        }
        return "";
    }

    public boolean allowTraverseByArrowKey(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
            case 0x1000001: {
                if (this.getFocusIndex() > 0) break;
                return true;
            }
            case 0x1000002: {
                if (this.fItems != null && this.getFocusIndex() < this.fItems.length - 1) break;
                return true;
            }
        }
        return false;
    }

    protected boolean traverse(Event event) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }
}

